/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.awt.SplashScreen;
import net.sourceforge.squirrel_sql.client.gui.SplashStringWriter;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.fw.util.ClassLoaderListener;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SquirrelSplashScreen {
    private static final ILogger s_log = LoggerController.createLogger(SquirrelSplashScreen.class);
    private SplashStringWriter _splashStringWriter;

    public SquirrelSplashScreen(SquirrelPreferences prefs, int numberOffCallsToindicateNewTask) {
        SplashScreen splashScreen = SplashScreen.getSplashScreen();
        if (null == splashScreen) {
            s_log.error("No SplashScreen availabe", new NullPointerException("No SplashScreen available. Please check VM parameter -splash:"));
            return;
        }
        this._splashStringWriter = new SplashStringWriter(splashScreen, prefs.getShowPluginFilesInSplashScreen(), numberOffCallsToindicateNewTask);
    }

    private void indicateLoadingFile(String filename) {
        if (null == this._splashStringWriter) {
            return;
        }
        this._splashStringWriter.writeLowerProgressLine(filename);
    }

    public void indicateNewTask(String text) {
        if (null == this._splashStringWriter) {
            return;
        }
        this._splashStringWriter.writeUpperProgressLine(text);
    }

    public ClassLoaderListener getClassLoaderListener() {
        return new ClassLoaderListener(){

            @Override
            public void loadedZipFile(String filename) {
                SquirrelSplashScreen.this.indicateLoadingFile(filename);
            }

            @Override
            public void finishedLoadingZipFiles() {
                SquirrelSplashScreen.this.indicateLoadingFile(null);
            }
        };
    }
}

