/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.lang.invoke.LambdaMetafactory;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.LogFile;
import net.sourceforge.squirrel_sql.client.gui.ViewLogSheetAppendState;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.gui.CursorChanger;
import net.sourceforge.squirrel_sql.fw.gui.DirectoryListComboBox;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.ToolBar;
import net.sourceforge.squirrel_sql.fw.gui.stdtextpopup.TextPopupMenu;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ViewLogsSheet
extends DialogWidget {
    public static final String PREF_KEY_LOGS_SHEET_WIDTH = "Squirrel.logsSheetWidth";
    public static final String PREF_KEY_LOGS_SHEET_HEIGHT = "Squirrel.logsSheetHeight";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ViewLogsSheet.class);
    private static final ILogger s_log = LoggerController.createLogger(ViewLogsSheet.class);
    private final IApplication _app;
    private final SquirrelPreferences _prefs;
    private final LogsComboBox _logDirCmb = new LogsComboBox();
    private final JTextArea _logContentsTxt = new JTextArea(20, 50);
    private final JButton _refreshBtn = new JButton(s_stringMgr.getString("ViewLogsSheet.refresh"));
    private final JCheckBox _errorChkbox = new JCheckBox("Errors");
    private final JCheckBox _warnChkbox = new JCheckBox("Warnings");
    private final JCheckBox _debugChkbox = new JCheckBox("Debug");
    private final JCheckBox _infoChkbox = new JCheckBox("Info");
    private final File _logDir;
    private boolean _closing = false;
    private boolean _refreshing = false;

    private ViewLogsSheet(IApplication app) {
        super(s_stringMgr.getString("ViewLogsSheet.title"), true, true, true, true);
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        this._app = app;
        this._prefs = this._app.getSquirrelPreferences();
        this._logDir = new ApplicationFiles().getExecutionLogFile().getParentFile();
        this.createUserInterface();
        this.setSize(this.getDimension());
    }

    private Dimension getDimension() {
        return new Dimension(Props.getInt(PREF_KEY_LOGS_SHEET_WIDTH, 500), Props.getInt(PREF_KEY_LOGS_SHEET_HEIGHT, 400));
    }

    public static synchronized void showSheet(IApplication app) {
        ViewLogsSheet logsSheet = new ViewLogsSheet(app);
        app.getMainFrame().addWidget(logsSheet);
        ViewLogsSheet.centerWithinDesktop(logsSheet);
        logsSheet.setVisible(true);
        logsSheet.moveToFront();
        logsSheet.startRefreshingLog();
    }

    @Override
    public void dispose() {
        this._closing = true;
        Dimension size = this.getSize();
        Props.putInt(PREF_KEY_LOGS_SHEET_WIDTH, size.width);
        Props.putInt(PREF_KEY_LOGS_SHEET_HEIGHT, size.height);
        super.dispose();
    }

    private void performClose() {
        this.dispose();
    }

    private synchronized void startRefreshingLog() {
        if (!this._refreshing) {
            this._app.getThreadPool().addTask(new Refresher());
        }
    }

    private void enableComponents(final boolean enabled) {
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                ViewLogsSheet.this._refreshBtn.setEnabled(enabled);
                ViewLogsSheet.this._logDirCmb.setEnabled(enabled);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void refreshLog() {
        block25: {
            block24: {
                block27: {
                    this.enableComponents(false);
                    cursorChg = new CursorChanger(this.getAwtContainer());
                    cursorChg.show();
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                ViewLogsSheet.this._logContentsTxt.setText("");
                            }
                        });
                    }
                    catch (Exception ex) {
                        ViewLogsSheet.s_log.error(ViewLogsSheet.s_stringMgr.getString("ViewLogsSheet.error.clearlogcontents"), ex);
                    }
                    logFile = (File)this._logDirCmb.getSelectedItem();
                    if (logFile == null) break block24;
                    try {
                        block26: {
                            if (!logFile.exists() || !logFile.canRead()) break block25;
                            rdr = new BufferedReader(new FileReader(logFile));
                            viewLogSheetAppendState = new ViewLogSheetAppendState();
                            line = null;
                            chunk = new StringBuilder(16384);
lbl19:
                            // 4 sources

                            while ((line = rdr.readLine()) != null) {
                                if (this._closing) {
                                    break block26;
                                }
                                ** GOTO lbl-1000
                            }
                            ** GOTO lbl48
                        }
                        rdr.close();
                        this.enableComponents(true);
                        this._refreshing = false;
                        cursorChg.restore();
                        return;
                    }
                    catch (Exception ex) {
                        msg = ViewLogsSheet.s_stringMgr.getString("ViewLogsSheet.error.processinglogfile");
                        ViewLogsSheet.s_log.error(msg, ex);
                    }
lbl-1000:
                    // 1 sources

                    {
                        block28: {
                            if (chunk.length() <= 16000) break block28;
                            finalLine = chunk.toString();
                            SwingUtilities.invokeAndWait((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$refreshLog$0(java.lang.String ), ()V)((ViewLogsSheet)this, (String)finalLine));
                            chunk = new StringBuilder(16384);
                            ** GOTO lbl19
                        }
                        if (!this.shouldAppendLineToChunk(line, viewLogSheetAppendState)) ** GOTO lbl19
                        chunk.append(line).append('\n');
                        ** GOTO lbl19
lbl48:
                        // 1 sources

                        if (!this._closing) break block27;
                    }
                    rdr.close();
                    this.enableComponents(true);
                    this._refreshing = false;
                    cursorChg.restore();
                    return;
                }
                ** try [egrp 8[TRYBLOCK] [3 : 255->275)] { 
lbl56:
                // 1 sources

                finalLine = chunk.toString();
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (!ViewLogsSheet.this._closing) {
                            ViewLogsSheet.this._logContentsTxt.append(finalLine);
                        }
                    }
                });
                break block25;
lbl59:
                // 1 sources

                finally {
                    rdr.close();
                }
            }
            if (ViewLogsSheet.s_log.isDebugEnabled()) {
                ViewLogsSheet.s_log.debug(ViewLogsSheet.s_stringMgr.getString("ViewLogsSheet.info.nulllogfile"));
            }
        }
        if (this._closing) {
            return;
        }
        try {
            pos = Math.max(0, this._logContentsTxt.getText().length() - 1);
            line = this._logContentsTxt.getLineOfOffset(pos);
            finalpos = this._logContentsTxt.getLineStartOffset(line);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ViewLogsSheet.this._logContentsTxt.setCaretPosition(finalpos);
                }
            });
            return;
        }
        catch (Exception ex) {
            ViewLogsSheet.s_log.error(ViewLogsSheet.s_stringMgr.getString("ViewLogsSheet.error.setcaret"), ex);
            return;
        }
    }

    private boolean shouldAppendLineToChunk(String line, ViewLogSheetAppendState state) {
        boolean result = false;
        if (line == null || line.length() == 0) {
            return false;
        }
        if (this._errorChkbox.isSelected() && this._warnChkbox.isSelected() && this._infoChkbox.isSelected() && this._debugChkbox.isSelected()) {
            return true;
        }
        int threadNameEndIdx = line.indexOf("]");
        if (threadNameEndIdx > -1 && line.length() > threadNameEndIdx + 2) {
            state.setLevelChar(line.charAt(threadNameEndIdx + 2));
        }
        if (this._errorChkbox.isSelected() && state.isError()) {
            result = true;
        } else if (this._warnChkbox.isSelected() && state.isWarn()) {
            result = true;
        } else if (this._infoChkbox.isSelected() && state.isInfo()) {
            result = true;
        } else if (this._debugChkbox.isSelected() && state.isDebug()) {
            result = true;
        } else if (state.isUnknown()) {
            result = true;
        }
        return result;
    }

    private void createUserInterface() {
        this.setDefaultCloseOperation(2);
        this.makeToolWindow(true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.createToolBar(), "North");
        contentPane.add((Component)this.createMainPanel(), "Center");
        contentPane.add((Component)this.createButtonsPanel(), "South");
        this.pack();
        GUIUtils.enableCloseByEscape(this);
    }

    private ToolBar createToolBar() {
        ToolBar tb = new ToolBar();
        tb.setUseRolloverButtons(true);
        tb.setFloatable(false);
        Object[] args = new Object[]{this.getTitle(), this._logDir.getAbsolutePath()};
        String lblTitle = s_stringMgr.getString("ViewLogsSheet.storedin", args);
        JLabel lbl = new JLabel(lblTitle);
        lbl.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        tb.add(lbl);
        return tb;
    }

    private JPanel createMainPanel() {
        final TextPopupMenu pop = new TextPopupMenu();
        pop.setTextComponent(this._logContentsTxt);
        this._logContentsTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    pop.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    pop.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        File appLogFile = new ApplicationFiles().getExecutionLogFile();
        this._logDirCmb.load(appLogFile.getParentFile());
        if (this._logDirCmb.getModel().getSize() > 0) {
            LogFile logFile = new LogFile(appLogFile);
            this._logDirCmb.setSelectedItem(logFile);
        }
        this._logDirCmb.addActionListener(new ChangeLogListener());
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this._logDirCmb, "North");
        this._logContentsTxt.setEditable(false);
        this._logContentsTxt.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 0));
        pnl.add((Component)new JScrollPane(this._logContentsTxt), "Center");
        return pnl;
    }

    private JPanel createButtonsPanel() {
        JPanel pnl = new JPanel();
        pnl.add(this._refreshBtn);
        this._refreshBtn.addActionListener(evt -> this.startRefreshingLog());
        JButton closeBtn = new JButton(s_stringMgr.getString("ViewLogsSheet.close"));
        closeBtn.addActionListener(evt -> this.performClose());
        pnl.add(closeBtn);
        this._errorChkbox.setSelected(this._prefs.getShowErrorLogMessages());
        this._errorChkbox.addActionListener(e -> this._prefs.setShowErrorLogMessages(this._errorChkbox.isSelected()));
        this._warnChkbox.setSelected(this._prefs.getShowWarnLogMessages());
        this._warnChkbox.addActionListener(e -> this._prefs.setShowWarnLogMessages(this._errorChkbox.isSelected()));
        this._infoChkbox.setSelected(this._prefs.getShowInfoLogMessages());
        this._infoChkbox.addActionListener(e -> this._prefs.setShowInfoLogMessages(this._infoChkbox.isSelected()));
        this._debugChkbox.setSelected(this._prefs.getShowDebugLogMessage());
        this._debugChkbox.addActionListener(e -> this._prefs.setShowDebugLogMessages(this._debugChkbox.isSelected()));
        pnl.add(this._errorChkbox);
        pnl.add(this._warnChkbox);
        pnl.add(this._infoChkbox);
        pnl.add(this._debugChkbox);
        GUIUtils.setJButtonSizesTheSame(closeBtn, this._refreshBtn);
        this.getRootPane().setDefaultButton(closeBtn);
        return pnl;
    }

    private /* synthetic */ void lambda$refreshLog$0(String finalLine) {
        if (!this._closing) {
            this._logContentsTxt.append(finalLine);
        }
    }

    private static final class LogsComboBox
    extends DirectoryListComboBox {
        private File _dir;

        private LogsComboBox() {
        }

        @Override
        public void load(File dir, FilenameFilter filter) {
            this._dir = dir;
            super.load(dir, filter);
        }

        public void addItem(Object anObject) {
            super.addItem(new LogFile(this._dir, anObject.toString()));
        }
    }

    private final class Refresher
    implements Runnable {
        private Refresher() {
        }

        @Override
        public void run() {
            ViewLogsSheet.this.refreshLog();
        }
    }

    private final class ChangeLogListener
    implements ActionListener {
        private ChangeLogListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ViewLogsSheet.this.startRefreshingLog();
        }
    }
}

