/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.aboutdialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.aboutdialog.AboutPanel;
import net.sourceforge.squirrel_sql.client.gui.aboutdialog.CommandlinePanel;
import net.sourceforge.squirrel_sql.client.gui.aboutdialog.CreditsPanel;
import net.sourceforge.squirrel_sql.client.gui.aboutdialog.MorePanel;
import net.sourceforge.squirrel_sql.client.gui.aboutdialog.SystemPanel;
import net.sourceforge.squirrel_sql.client.gui.aboutdialog.ThreadPanel;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class AboutBoxDialog
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AboutBoxDialog.class);
    private final JButton _closeBtn = new JButton(s_stringMgr.getString("AboutBoxDialog.close"));

    private AboutBoxDialog() {
        super(Main.getApplication().getMainFrame(), s_stringMgr.getString("AboutBoxDialog.about"), true);
        super.setDefaultCloseOperation(2);
        this.createGUI();
        GUIUtils.enableCloseByEscape(this);
    }

    public static void showAboutBox() {
        new AboutBoxDialog().setVisible(true);
    }

    private void createGUI() {
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        contentPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        final JTabbedPane tabPnl = UIFactory.getInstance().createTabbedPane();
        tabPnl.add(s_stringMgr.getString("AboutBoxDialog.about"), new AboutPanel(Main.getApplication()));
        tabPnl.add(s_stringMgr.getString("AboutBoxDialog.credits"), new CreditsPanel(Main.getApplication()));
        final SystemPanel systemPnl = new SystemPanel();
        tabPnl.add(s_stringMgr.getString("AboutBoxDialog.system"), systemPnl);
        tabPnl.add(s_stringMgr.getString("AboutBoxDialog.threads"), new ThreadPanel());
        tabPnl.add(s_stringMgr.getString("AboutBoxDialog.command.line"), new CommandlinePanel());
        tabPnl.add(s_stringMgr.getString("AboutBoxDialog.more"), new MorePanel());
        tabPnl.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                String title = tabPnl.getTitleAt(tabPnl.getSelectedIndex());
                if (title.equals(s_stringMgr.getString("AboutBoxDialog.system"))) {
                    systemPnl.getMemoryPanel().startTimer();
                } else {
                    systemPnl.getMemoryPanel().stopTimer();
                }
            }
        });
        contentPane.add((Component)tabPnl, "Center");
        contentPane.add((Component)this.createButtonBar(), "South");
        this.getRootPane().setDefaultButton(this._closeBtn);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent evt) {
                String title = tabPnl.getTitleAt(tabPnl.getSelectedIndex());
                if (title.equals(s_stringMgr.getString("AboutBoxDialog.system"))) {
                    systemPnl.getMemoryPanel().startTimer();
                }
            }

            @Override
            public void windowDeactivated(WindowEvent evt) {
                String title = tabPnl.getTitleAt(tabPnl.getSelectedIndex());
                if (title.equals(s_stringMgr.getString("AboutBoxDialog.system"))) {
                    systemPnl.getMemoryPanel().stopTimer();
                }
            }
        });
        this.pack();
        GUIUtils.centerWithinParent(this);
        this.setResizable(true);
    }

    private JPanel createButtonBar() {
        this._closeBtn.addActionListener(evt -> this.dispose());
        return GUIUtils.createButtonBar(this._closeBtn);
    }
}

