/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.aboutdialog;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.plugin.PluginInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

final class CreditsPanel
extends JScrollPane {
    private static final ILogger s_log = LoggerController.createLogger(CreditsPanel.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CreditsPanel.class);

    CreditsPanel(IApplication app) {
        this.setBorder(BorderFactory.createEmptyBorder());
        JEditorPane credits = new JEditorPane();
        credits.setEditable(false);
        credits.putClientProperty("JEditorPane.honorDisplayProperties", true);
        credits.setContentType("text/html");
        credits.setPreferredSize(new Dimension(200, 200));
        String creditsHtml = this.readCreditsHtml(app);
        StringBuffer pluginHtml = new StringBuffer();
        PluginInfo[] pi = app.getPluginManager().getPluginInformation();
        for (int i = 0; i < pi.length; ++i) {
            pluginHtml.append("<br><b>").append(pi[i].getDescriptiveName()).append(":</b>");
            String authors = pi[i].getAuthor();
            StringTokenizer strok = new StringTokenizer(authors, ",");
            while (strok.hasMoreTokens()) {
                pluginHtml.append("<br>").append(strok.nextToken().trim());
            }
            String contribs = pi[i].getContributors();
            strok = new StringTokenizer(contribs, ",");
            while (strok.hasMoreTokens()) {
                pluginHtml.append("<br>").append(strok.nextToken().trim());
            }
            pluginHtml.append("<br>");
        }
        creditsHtml = creditsHtml.replaceAll("@@replace", pluginHtml.toString());
        credits.setText(creditsHtml);
        this.setViewportView(credits);
        credits.setCaretPosition(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readCreditsHtml(IApplication app) {
        URL url = app.getResources().getCreditsURL();
        StringBuffer buf = new StringBuffer(2048);
        if (url != null) {
            try (BufferedReader rdr = new BufferedReader(new InputStreamReader(url.openStream()));){
                String line = null;
                while ((line = rdr.readLine()) != null) {
                    String internationalizedLine = Utilities.replaceI18NSpanLine(line, s_stringMgr);
                    buf.append(internationalizedLine);
                }
            }
            catch (IOException ex) {
                String errorMsg = s_stringMgr.getString("AboutBoxDialog.error.creditsfile");
                s_log.error(errorMsg, ex);
                buf.append(errorMsg + ": " + ex.toString());
            }
        } else {
            String errorMsg = s_stringMgr.getString("AboutBoxDialog.error.creditsfileurl");
            s_log.error(errorMsg);
            buf.append(errorMsg);
        }
        return buf.toString();
    }
}

