/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.aboutdialog;

import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import net.sourceforge.squirrel_sql.client.gui.aboutdialog.AboutBoxDialog;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class MorePanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AboutBoxDialog.class);
    private static final ILogger s_log = LoggerController.createLogger(MorePanel.class);

    public MorePanel() {
        super(new GridLayout(1, 1));
        JTextArea textArea = new JTextArea();
        textArea.setTabSize(3);
        JScrollPane scrollPane = new JScrollPane(textArea);
        this.add(scrollPane);
        textArea.setEditable(false);
        String text = this.getLookAndFeelInfo();
        textArea.setText(text);
        GUIUtils.setPreferredWidth(scrollPane, 100);
        GUIUtils.forceScrollToBegin(scrollPane);
    }

    private String getLookAndFeelInfo() {
        String text;
        try {
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            text = null == lookAndFeel ? s_stringMgr.getString("MorePanel.no.installed.laf.info") : s_stringMgr.getString("MorePanel.installed.laf.info", lookAndFeel.getName(), lookAndFeel.getDescription(), lookAndFeel.toString(), lookAndFeel);
        }
        catch (Exception e) {
            s_log.error("Failed to read installed Look and feel", e);
            text = s_stringMgr.getString("MorePanel.failed.to.read.laf.info", e);
        }
        return text;
    }
}

