/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.aboutdialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

final class ThreadPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ThreadPanel.class);
    private final JScrollPane scrollPane;
    private JTextArea content;

    ThreadPanel() {
        this.setLayout(new BorderLayout());
        this.content = new JTextArea(5, 20);
        this.content.setEditable(false);
        this.content.setLineWrap(false);
        this.scrollPane = new JScrollPane(this.content);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.createButtons(), "South");
        this.doThreadDump();
    }

    private JPanel createButtons() {
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JButton refreshButton = new JButton(s_stringMgr.getString("ThreadPanel.refresh"));
        buttonPanel.add((Component)refreshButton, "West");
        refreshButton.addActionListener(e -> this.doThreadDump());
        return buttonPanel;
    }

    private void doThreadDump() {
        ThreadInfo[] threadInfos;
        StringBuilder sb = new StringBuilder();
        for (ThreadInfo threadInfo : threadInfos = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
            sb.append(threadInfo.toString());
            sb.append(StringUtilities.getEolStr());
        }
        this.content.setText(sb.toString());
        GUIUtils.forceScrollToBegin(this.scrollPane);
    }
}

