/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.AliasMaintenanceType;
import net.sourceforge.squirrel_sql.client.gui.db.AliasSheetOkListener;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesAndDriversManager;
import net.sourceforge.squirrel_sql.client.gui.db.ConnectToAliasCallBack;
import net.sourceforge.squirrel_sql.client.gui.db.DriverListCellRenderer;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.AliasPropertiesController;
import net.sourceforge.squirrel_sql.client.gui.db.encryption.AliasPasswordHandler;
import net.sourceforge.squirrel_sql.client.gui.db.modifyaliases.SQLAliasPropType;
import net.sourceforge.squirrel_sql.client.gui.db.passwordaccess.PasswordInAliasCtrl;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.mainframe.action.ConnectToAliasCommand;
import net.sourceforge.squirrel_sql.client.preferences.PreferenceType;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.util.IdentifierFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.buttontabcomponent.SmallToolTipInfoButton;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifierFactory;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriver;
import net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener;
import net.sourceforge.squirrel_sql.fw.util.ObjectCacheChangeEvent;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class AliasInternalFrame
extends DialogWidget {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasInternalFrame.class);
    private static final ILogger s_log = LoggerController.createLogger(AliasInternalFrame.class);
    private static final int COLUMN_COUNT = 25;
    private final SQLAlias _sqlAlias;
    private final JLabel _titleLbl = new JLabel();
    private final AliasMaintenanceType _maintType;
    private final Window _parentWindow;
    private DriversCacheListener _driversCacheLis;
    private final JTextField _txtAliasName = new JTextField();
    private DriversCombo _drivers;
    private final JTextField _txtUrl = new JTextField();
    private final JTextField _txtUserName = new JTextField();
    private PasswordInAliasCtrl _passwordInAliasCtrl = new PasswordInAliasCtrl();
    private final JCheckBox _chkAutoLogon = new JCheckBox(SQLAliasPropType.autoLogon.getI18nString());
    private final JCheckBox _chkConnectAtStartup = new JCheckBox(SQLAliasPropType.connectAtStartup.getI18nString());
    private JCheckBox _chkSavePasswordEncrypted = new JCheckBox(SQLAliasPropType.encryptPassword.getI18nString());
    private final JButton _btnAliasProps = new JButton(s_stringMgr.getString("AliasInternalFrame.props"));
    private AliasSheetOkListener _aliasSheetOkListener;

    AliasInternalFrame(SQLAlias sqlAlias, AliasMaintenanceType maintType) {
        this(sqlAlias, maintType, Main.getApplication().getMainFrame());
    }

    AliasInternalFrame(SQLAlias sqlAlias, AliasMaintenanceType maintType, Window parent) {
        super("", true, true, true, true, null != parent ? parent : Main.getApplication().getMainFrame());
        this._parentWindow = parent;
        if (sqlAlias == null) {
            throw new IllegalArgumentException("SQLAlias == null");
        }
        this._sqlAlias = sqlAlias;
        this._maintType = maintType;
        this.createUserInterface();
        this.loadData();
        this.pack();
    }

    @Override
    public void dispose() {
        if (this._driversCacheLis != null) {
            Main.getApplication().getAliasesAndDriversManager().removeDriversListener(this._driversCacheLis);
            this._driversCacheLis = null;
        }
        super.dispose();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this._titleLbl.setText(title);
    }

    SQLAlias getSQLAlias() {
        return this._sqlAlias;
    }

    private void loadData() {
        this._txtAliasName.setText(this._sqlAlias.getName());
        this._txtUserName.setText(this._sqlAlias.getUserName());
        this._passwordInAliasCtrl.setPassword(AliasPasswordHandler.getPassword(this._sqlAlias));
        this._chkAutoLogon.setSelected(this._sqlAlias.isAutoLogon());
        this._chkConnectAtStartup.setSelected(this._sqlAlias.isConnectAtStartup());
        this._chkSavePasswordEncrypted.setSelected(this._sqlAlias.isEncryptPassword());
        if (this._maintType != AliasMaintenanceType.NEW) {
            this._drivers.setSelectedItem(this._sqlAlias.getDriverIdentifier());
            this._txtUrl.setText(this._sqlAlias.getUrl());
        } else {
            ISQLDriver driver = this._drivers.getSelectedDriver();
            if (driver != null) {
                this._txtUrl.setText(driver.getUrl());
            }
        }
    }

    private void performClose() {
        this.setVisible(false);
        this.dispose();
    }

    private void performOk() {
        try {
            this.applyFromDialog(this._sqlAlias);
            if (this._maintType == AliasMaintenanceType.NEW || this._maintType == AliasMaintenanceType.COPY) {
                Main.getApplication().getAliasesAndDriversManager().addAlias(this._sqlAlias);
            }
            Main.getApplication().savePreferences(PreferenceType.ALIAS_DEFINITIONS);
            this.dispose();
            if (null != this._aliasSheetOkListener) {
                this._aliasSheetOkListener.aliasSheetClosedByOkButton();
            }
        }
        catch (ValidationException ex) {
            Main.getApplication().showErrorDialog(ex);
        }
    }

    private void applyFromDialog(SQLAlias alias) throws ValidationException {
        ISQLDriver driver = this._drivers.getSelectedDriver();
        if (driver == null) {
            throw new ValidationException(s_stringMgr.getString("AliasInternalFrame.error.nodriver"));
        }
        alias.setName(this._txtAliasName.getText().trim());
        alias.setDriverIdentifier(this._drivers.getSelectedDriver().getIdentifier());
        alias.setUrl(this._txtUrl.getText().trim());
        alias.setUserName(this._txtUserName.getText().trim());
        StringBuffer buf = new StringBuffer();
        buf.append(this._passwordInAliasCtrl.getPassword());
        alias.setEncryptPassword(this._chkSavePasswordEncrypted.isSelected());
        String unencryptedPassword = buf.toString();
        AliasPasswordHandler.setPassword(alias, unencryptedPassword);
        alias.setAutoLogon(this._chkAutoLogon.isSelected());
        alias.setConnectAtStartup(this._chkConnectAtStartup.isSelected());
    }

    private void showNewDriverDialog() {
        Main.getApplication().getWindowManager().showNewDriverInternalFrame();
    }

    private void showDriverPropertiesDialog() {
        try {
            this.applyFromDialog(this._sqlAlias);
            AliasPropertiesController.showAliasProperties(this._sqlAlias, this.getDelegate().getParentWindow());
        }
        catch (Exception ex) {
            Main.getApplication().showErrorDialog(ex);
        }
    }

    private void createUserInterface() {
        this.setDefaultCloseOperation(2);
        this.makeToolWindow(true);
        String winTitle = this._maintType == AliasMaintenanceType.MODIFY ? s_stringMgr.getString("AliasInternalFrame.changealias", this._sqlAlias.getName()) : s_stringMgr.getString("AliasInternalFrame.addalias");
        this.setTitle(winTitle);
        this._txtAliasName.setColumns(25);
        this._txtUrl.setColumns(25);
        this._txtUserName.setColumns(25);
        this._passwordInAliasCtrl.setColumns(25);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        super.setContentPane(contentPane);
        GridBagConstraints gbc = new GridBagConstraints();
        contentPane.setLayout(new GridBagLayout());
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 10, 5, 10);
        gbc.fill = 2;
        contentPane.add((Component)this._titleLbl, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 10, 5, 10);
        contentPane.add((Component)new JSeparator(), gbc);
        contentPane.add((Component)this.createDataEntryPanel(), gbc);
        gbc.weighty = 0.0;
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 10, 5, 10);
        contentPane.add((Component)new JSeparator(), gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        ++gbc.gridy;
        contentPane.add((Component)this.createButtonsPanel(), gbc);
        this._driversCacheLis = new DriversCacheListener();
        Main.getApplication().getAliasesAndDriversManager().addDriversListener(this._driversCacheLis);
        GUIUtils.enableCloseByEscape(this);
    }

    private JPanel createDataEntryPanel() {
        this._btnAliasProps.addActionListener(evt -> this.showDriverPropertiesDialog());
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)new JLabel(SQLAliasPropType.aliasName.getI18nString(), 4), gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)this._txtAliasName, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)new JLabel(SQLAliasPropType.driverIdentifier.getI18nString(), 4), gbc);
        this._drivers = new DriversCombo();
        this._drivers.addItemListener(new DriversComboItemListener());
        Box driverPnl = Box.createHorizontalBox();
        driverPnl.add(this._drivers);
        driverPnl.add(Box.createHorizontalStrut(5));
        JButton newDriverBtn = new JButton(s_stringMgr.getString("AliasInternalFrame.new"));
        newDriverBtn.addActionListener(evt -> this.showNewDriverDialog());
        driverPnl.add(newDriverBtn);
        gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)driverPnl, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)new JLabel(SQLAliasPropType.jdbcUrl.getI18nString(), 4), gbc);
        gbc = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)this._txtUrl, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)new JLabel(SQLAliasPropType.userName.getI18nString(), 4), gbc);
        gbc = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)this._txtUserName, gbc);
        gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)new JLabel(SQLAliasPropType.password.getI18nString(), 4), gbc);
        gbc = new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)this._passwordInAliasCtrl.getPanel(), gbc);
        gbc = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)this.createAutoLogonPanel(), gbc);
        gbc = new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)this._chkConnectAtStartup, gbc);
        gbc = new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)this._chkSavePasswordEncrypted, gbc);
        gbc = new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0);
        this._btnAliasProps.setIcon(Main.getApplication().getResources().getIcon("aliasProperties"));
        pnl.add((Component)this._btnAliasProps, gbc);
        gbc = new GridBagConstraints(0, 8, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)new JPanel(), gbc);
        return pnl;
    }

    private JPanel createAutoLogonPanel() {
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this._chkAutoLogon.setToolTipText(s_stringMgr.getString("AliasInternalFrame.autologon.security.tooltip"));
        ret.add((Component)this._chkAutoLogon, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        ret.add((Component)new SmallToolTipInfoButton(s_stringMgr.getString("AliasInternalFrame.autologon.security.tooltip.long.html"), 10000).getButton(), gbc);
        return ret;
    }

    private JPanel createButtonsPanel() {
        JPanel pnl = new JPanel();
        JButton okBtn = new JButton(s_stringMgr.getString("AliasInternalFrame.ok"));
        okBtn.addActionListener(evt -> this.performOk());
        JButton closeBtn = new JButton(s_stringMgr.getString("AliasInternalFrame.close"));
        closeBtn.addActionListener(evt -> this.performClose());
        JButton testBtn = new JButton(s_stringMgr.getString("AliasInternalFrame.test"));
        testBtn.addActionListener(evt -> this.performConnect(false));
        JButton connectBtn = new JButton(s_stringMgr.getString("AliasInternalFrame.connect"));
        connectBtn.addActionListener(evt -> this.performConnect(true));
        pnl.add(okBtn);
        pnl.add(closeBtn);
        pnl.add(testBtn);
        pnl.add(connectBtn);
        GUIUtils.setJButtonSizesTheSame(okBtn, closeBtn, testBtn, connectBtn);
        this.getRootPane().setDefaultButton(okBtn);
        return pnl;
    }

    private void performConnect(boolean createSession) {
        if (createSession) {
            try {
                this.applyFromDialog(this._sqlAlias);
            }
            catch (ValidationException e) {
                Main.getApplication().showErrorDialog(e);
                return;
            }
            ConnectToAliasCallBack connectToAliasCallBack = new ConnectToAliasCallBack(this._sqlAlias){

                @Override
                public void sessionCreated(ISession session) {
                    AliasInternalFrame.this.performOk();
                }
            };
            new ConnectToAliasCommand(this._sqlAlias, true, connectToAliasCallBack).executeConnect();
        } else {
            AliasesAndDriversManager cache = Main.getApplication().getAliasesAndDriversManager();
            IIdentifierFactory factory = IdentifierFactory.getInstance();
            SQLAlias alias = cache.createAlias(factory.createIdentifier());
            try {
                alias.assignFromWithValidationException(this._sqlAlias, false);
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
            try {
                this.applyFromDialog(alias);
            }
            catch (ValidationException e) {
                Main.getApplication().showErrorDialog(e);
                return;
            }
            new ConnectToAliasCommand(alias, false, new ConnectionTestCallBack(Main.getApplication(), alias)).executeConnect();
        }
    }

    public void setOkListener(AliasSheetOkListener aliasSheetOkListener) {
        this._aliasSheetOkListener = aliasSheetOkListener;
    }

    private final class DriversCacheListener
    implements IObjectCacheChangeListener {
        private DriversCacheListener() {
        }

        @Override
        public void objectAdded(ObjectCacheChangeEvent evt) {
            AliasInternalFrame.this._drivers.addItem(evt.getObject());
        }

        @Override
        public void objectRemoved(ObjectCacheChangeEvent evt) {
            AliasInternalFrame.this._drivers.removeItem(evt.getObject());
        }
    }

    private final class ConnectionTestCallBack
    extends ConnectToAliasCallBack {
        private ConnectionTestCallBack(IApplication app, SQLAlias alias) {
            super(alias);
        }

        @Override
        public void connected(ISQLConnection conn) {
            try {
                conn.close();
            }
            catch (Throwable th) {
                String msg = s_stringMgr.getString("AliasInternalFrame.error.errorclosingconn");
                s_log.error(msg, th);
                Main.getApplication().showErrorDialog(msg + ": " + th.toString());
            }
            AliasInternalFrame.this.showOk(s_stringMgr.getString("AliasInternalFrame.connsuccess"));
            if (this.getAlias().isAutoLogon()) {
                AliasInternalFrame.this._txtUserName.setText(this.getAlias().getUserName());
                AliasInternalFrame.this._passwordInAliasCtrl.setPassword(AliasPasswordHandler.getPassword(this.getAlias()));
            }
        }

        @Override
        public void sessionCreated(ISession session) {
            s_log.error(s_stringMgr.getString("AliasInternalFrame.error.sessioncreation"));
        }
    }

    private final class DriversCombo
    extends JComboBox {
        private Map<IIdentifier, ISQLDriver> _map = new HashMap<IIdentifier, ISQLDriver>();
        SquirrelPreferences prefs = Main.getApplication().getSquirrelPreferences();

        DriversCombo() {
            SquirrelResources res = Main.getApplication().getResources();
            this.setRenderer(new DriverListCellRenderer((Icon)res.getIcon("list.driver.found"), res.getIcon("list.driver.notfound")));
            ArrayList<ISQLDriver> list = new ArrayList<ISQLDriver>();
            Iterator<SQLDriver> it = Main.getApplication().getAliasesAndDriversManager().drivers();
            while (it.hasNext()) {
                ISQLDriver sqlDriver = it.next();
                if (this.prefs.getShowLoadedDriversOnly() && !sqlDriver.isJDBCDriverClassLoaded()) continue;
                this._map.put(sqlDriver.getIdentifier(), sqlDriver);
                list.add(sqlDriver);
            }
            Collections.sort(list, new DriverComparator());
            it = list.iterator();
            while (it.hasNext()) {
                this.addItem(it.next());
            }
        }

        void setSelectedItem(IIdentifier id) {
            super.setSelectedItem(this._map.get(id));
        }

        ISQLDriver getSelectedDriver() {
            return (ISQLDriver)this.getSelectedItem();
        }

        private class DriverComparator
        implements Comparator<ISQLDriver>,
        Serializable {
            private DriverComparator() {
            }

            @Override
            public int compare(ISQLDriver leftDriver, ISQLDriver rightDriver) {
                if (leftDriver.isJDBCDriverClassLoaded() && !rightDriver.isJDBCDriverClassLoaded()) {
                    return -1;
                }
                if (!leftDriver.isJDBCDriverClassLoaded() && rightDriver.isJDBCDriverClassLoaded()) {
                    return 1;
                }
                return leftDriver.toString().compareToIgnoreCase(rightDriver.toString());
            }
        }
    }

    private final class DriversComboItemListener
    implements ItemListener {
        private DriversComboItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            ISQLDriver driver = (ISQLDriver)evt.getItem();
            if (driver != null) {
                AliasInternalFrame.this._txtUrl.setText(driver.getUrl());
            }
        }
    }
}

