/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import net.sourceforge.squirrel_sql.client.gui.db.aliascolor.AliasColor;

public class AliasListCellRenderer
extends DefaultListCellRenderer {
    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component renderer = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        Color bg = AliasColor.getItemColor(value);
        if (bg != null) {
            if (isSelected) {
                renderer.setBackground(AliasListCellRenderer.blendColor(bg, renderer.getBackground(), 0.7));
            } else {
                renderer.setBackground(bg);
            }
        }
        return renderer;
    }

    static Color blendColor(Color front, Color back, double factor) {
        double weightSum;
        double weightFront = (double)front.getAlpha() * factor;
        double weightBack = (double)back.getAlpha() * (1.0 - factor);
        double a = weightSum = weightFront + weightBack;
        double r = (weightFront * (double)front.getRed() + weightBack * (double)back.getRed()) / weightSum;
        double g = (weightFront * (double)front.getGreen() + weightBack * (double)back.getGreen()) / weightSum;
        double b = (weightFront * (double)front.getBlue() + weightBack * (double)back.getBlue()) / weightSum;
        return AliasColor.colorOf((int)a << 24 | (int)r << 16 | (int)g << 8 | (int)b);
    }
}

