/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.gui.db.AliasDragState;
import net.sourceforge.squirrel_sql.client.gui.db.AliasTreePasteMode;
import net.sourceforge.squirrel_sql.client.gui.db.AliasTreePasteState;
import net.sourceforge.squirrel_sql.client.gui.db.aliascolor.AliasColor;

public class AliasTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final AliasTreePasteState _aliasPasteState;
    private AliasDragState _aliasDragState;

    public AliasTreeCellRenderer(AliasTreePasteState aliasPasteState, AliasDragState aliasDragState) {
        this._aliasPasteState = aliasPasteState;
        this._aliasDragState = aliasDragState;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component renderer = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        Color itemColor = AliasColor.getItemColor(value);
        if (itemColor == null) {
            renderer.setBackground(null);
            ((JComponent)renderer).setOpaque(false);
        } else {
            if (sel) {
                itemColor = AliasTreeCellRenderer.colorWithAlpha(itemColor, 178);
            }
            renderer.setBackground(itemColor);
            ((JComponent)renderer).setOpaque(true);
        }
        return this.modifyRenderer(renderer, value);
    }

    static Color colorWithAlpha(Color color, int alpha) {
        return AliasColor.colorOf(color.getRGB() & 0xFFFFFF | alpha << 24);
    }

    private Component modifyRenderer(Component component, Object node) {
        JLabel ret = (JLabel)component;
        ret.setEnabled(true);
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)node;
        if (null != this._aliasPasteState.getPathsToPaste() && AliasTreePasteMode.CUT.equals((Object)this._aliasPasteState.getPasteMode())) {
            boolean found = false;
            for (TreePath treePath : this._aliasPasteState.getPathsToPaste()) {
                if (treePath.getLastPathComponent() != dmtn) continue;
                found = true;
                break;
            }
            ret.setEnabled(!found);
            ret.setDisabledIcon(ret.getIcon());
        }
        this.initDropPositionIndicator(ret, dmtn);
        return ret;
    }

    private void initDropPositionIndicator(JLabel ret, DefaultMutableTreeNode dmtn) {
        ret.setBorder(BorderFactory.createEmptyBorder());
        if (dmtn != this._aliasDragState.getTreeDndDropPositionData().getNode()) {
            return;
        }
        switch (this._aliasDragState.getTreeDndDropPositionData().getPos()) {
            case ABOVE: {
                ret.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, Color.blue));
                break;
            }
            case BELOW: {
                ret.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, Color.blue));
                break;
            }
            case INTO: {
                ret.setBorder(BorderFactory.createLineBorder(Color.blue));
            }
        }
    }
}

