/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.AliasFolder;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class AliasTreeUtil {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasTreeUtil.class);

    public static void throwUnknownUserObjectException(DefaultMutableTreeNode aliasTreeNode) {
        throw AliasTreeUtil.createUnknownUserObjectException(aliasTreeNode);
    }

    public static IllegalStateException createUnknownUserObjectException(DefaultMutableTreeNode aliasTreeNode) {
        return new IllegalStateException("Unknown Alias tree object typ: " + (null == aliasTreeNode.getUserObject() ? "null" : aliasTreeNode.getUserObject().getClass().getName()));
    }

    public static void expandRecursively(TreePath treePath, JTree tree) {
        if (null == treePath || !(((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject() instanceof AliasFolder)) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("JTreeAliasesListImpl.noFolderSelected"));
            return;
        }
        AliasTreeUtil.recurseChildNodes(treePath, p -> tree.expandPath((TreePath)p));
    }

    public static void collapseRecursively(TreePath treePath, JTree tree) {
        if (null == treePath || !(((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject() instanceof AliasFolder)) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("JTreeAliasesListImpl.noFolderSelected"));
            return;
        }
        AliasTreeUtil.recurseChildNodes(treePath, p -> tree.collapsePath(p.getParentPath()));
    }

    private static void recurseChildNodes(TreePath treePath, Consumer<TreePath> treePathConsumer) {
        treePathConsumer.accept(treePath);
        DefaultMutableTreeNode dtm = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        for (int i = 0; i < dtm.getChildCount(); ++i) {
            Object[] buf = ((DefaultMutableTreeNode)dtm.getChildAt(i)).getPath();
            AliasTreeUtil.recurseChildNodes(new TreePath(buf), treePathConsumer);
        }
    }

    public static List<AliasFolder> getAllAliasFolders(JTree tree) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        ArrayList<AliasFolder> ret = new ArrayList<AliasFolder>();
        AliasTreeUtil.recurseChildNodes(new TreePath(root.getPath()), p -> AliasTreeUtil.fillFolder(p, ret));
        return ret;
    }

    private static void fillFolder(TreePath treePath, ArrayList<AliasFolder> toFill) {
        if (((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject() instanceof AliasFolder) {
            toFill.add((AliasFolder)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject());
        }
    }

    public static DefaultMutableTreeNode findAliasNode(SQLAlias sqlAlias, DefaultMutableTreeNode tn) {
        return AliasTreeUtil._findNode(sqlAlias, tn);
    }

    public static DefaultMutableTreeNode findAliasFolderNode(AliasFolder aliasFolder, DefaultMutableTreeNode tn) {
        return AliasTreeUtil._findNode(aliasFolder, tn);
    }

    private static DefaultMutableTreeNode _findNode(Object aliasOrAliasFolder, DefaultMutableTreeNode tn) {
        if (aliasOrAliasFolder.equals(tn.getUserObject())) {
            return tn;
        }
        for (int i = 0; i < tn.getChildCount(); ++i) {
            DefaultMutableTreeNode ret = AliasTreeUtil._findNode(aliasOrAliasFolder, (DefaultMutableTreeNode)tn.getChildAt(i));
            if (null == ret) continue;
            return ret;
        }
        return null;
    }
}

