/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesList;
import net.sourceforge.squirrel_sql.client.gui.db.IUserInterfaceFactory;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.mainframe.action.AliasFileOpenAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.AliasPropertiesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CollapseAllAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CollapseSelectedAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ColorAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ConnectToAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ConnectToAliasCommand;
import net.sourceforge.squirrel_sql.client.mainframe.action.CopyAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CopyToPasteAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CreateAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CutAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.DeleteAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ExpandAllAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ExpandSelectedAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ModifyAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ModifyMultipleAliasesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.NewAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.PasteAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.SortAliasesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ToggleTreeViewAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.TransferAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.findaliases.FindAliasAction;
import net.sourceforge.squirrel_sql.fw.gui.BasePopupMenu;
import net.sourceforge.squirrel_sql.fw.gui.IToggleAction;
import net.sourceforge.squirrel_sql.fw.gui.ToolBar;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.resources.Resources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

final class AliasUserInterfaceFactory
implements IUserInterfaceFactory<AliasesList> {
    private static final String PREF_KEY_VIEW_ALIASES_AS_TREE = "Squirrel.viewAliasesAsTree";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasUserInterfaceFactory.class);
    private IApplication _app;
    private final AliasesList _aliasesList;
    private ToolBar _toolBar;
    private BasePopupMenu _pm = new BasePopupMenu();

    AliasUserInterfaceFactory(AliasesList list) {
        if (list == null) {
            throw new IllegalArgumentException("AliasesList == null");
        }
        this._app = Main.getApplication();
        this._aliasesList = list;
        if (this._app.getSquirrelPreferences().getShowAliasesToolBar()) {
            this.createToolBar();
        }
        final ActionCollection actions = this._app.getActionCollection();
        this._pm.add(actions.get(ConnectToAliasAction.class));
        this._pm.addSeparator();
        this._pm.add(actions.get(CreateAliasAction.class));
        this._pm.add(actions.get(ModifyAliasAction.class));
        this._pm.add(actions.get(CopyAliasAction.class));
        this._pm.add(actions.get(DeleteAliasAction.class));
        this._pm.addSeparator();
        this._pm.add(actions.get(AliasPropertiesAction.class));
        this._pm.addSeparator();
        this._pm.add(actions.get(AliasFileOpenAction.class));
        this._pm.addSeparator();
        this._pm.add(actions.get(FindAliasAction.class));
        this._pm.add(actions.get(SortAliasesAction.class));
        this._pm.add(actions.get(ColorAliasAction.class));
        this._pm.addSeparator();
        this.addToMenuAsCheckBoxMenuItem(this._app.getResources(), actions.get(ToggleTreeViewAction.class), this._pm);
        this._pm.add(actions.get(NewAliasFolderAction.class));
        this._pm.add(actions.get(CopyToPasteAliasFolderAction.class));
        this._pm.add(actions.get(CutAliasFolderAction.class));
        this._pm.add(actions.get(PasteAliasFolderAction.class));
        this._pm.add(actions.get(CollapseAllAliasFolderAction.class));
        this._pm.add(actions.get(ExpandAllAliasFolderAction.class));
        this._pm.add(actions.get(CollapseSelectedAliasFolderAction.class));
        this._pm.add(actions.get(ExpandSelectedAliasFolderAction.class));
        this._pm.addSeparator();
        this._pm.add(actions.get(TransferAliasAction.class));
        this._pm.addSeparator();
        this._pm.add(actions.get(ModifyMultipleAliasesAction.class));
        this._app.addApplicationListener(() -> this.onSaveApplicationState());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ToggleTreeViewAction actViewAsTree = (ToggleTreeViewAction)actions.get(ToggleTreeViewAction.class);
                actViewAsTree.getToggleComponentHolder().setSelected(Props.getBoolean(AliasUserInterfaceFactory.PREF_KEY_VIEW_ALIASES_AS_TREE, false));
                actViewAsTree.actionPerformed(new ActionEvent(this, 1, "actionPerformed"));
                AliasUserInterfaceFactory.this.enableDisableActions();
            }
        });
    }

    private void onSaveApplicationState() {
        IToggleAction actViewAsTree = (IToggleAction)this._app.getActionCollection().get(ToggleTreeViewAction.class);
        Props.putBoolean(PREF_KEY_VIEW_ALIASES_AS_TREE, actViewAsTree.getToggleComponentHolder().isSelected());
    }

    private JCheckBoxMenuItem addToMenuAsCheckBoxMenuItem(Resources rsrc, Action action, JPopupMenu menu) {
        JCheckBoxMenuItem mnu = rsrc.addToMenuAsCheckBoxMenuItem(action, menu);
        if (action instanceof IToggleAction) {
            ((IToggleAction)action).getToggleComponentHolder().addToggleableComponent(mnu);
        }
        return mnu;
    }

    @Override
    public String getWindowTitle() {
        return s_stringMgr.getString("AliasesListInternalFrame.windowtitle");
    }

    @Override
    public void execDoubleClickCommand(MouseEvent evt) {
        SQLAlias alias = this._aliasesList.getSelectedAlias(evt);
        if (alias != null) {
            new ConnectToAliasCommand(alias).executeConnect();
        }
    }

    public void enableDisableActions() {
        ActionCollection actions = this._app.getActionCollection();
        ToggleTreeViewAction actViewAsTree = (ToggleTreeViewAction)actions.get(ToggleTreeViewAction.class);
        boolean viewAsTree = actViewAsTree.getToggleComponentHolder().isSelected();
        actions.get(NewAliasFolderAction.class).setEnabled(viewAsTree);
        actions.get(CopyToPasteAliasFolderAction.class).setEnabled(viewAsTree);
        actions.get(CutAliasFolderAction.class).setEnabled(viewAsTree);
        actions.get(PasteAliasFolderAction.class).setEnabled(viewAsTree);
        actions.get(CollapseAllAliasFolderAction.class).setEnabled(viewAsTree);
        actions.get(ExpandAllAliasFolderAction.class).setEnabled(viewAsTree);
    }

    void createToolBar() {
        this._toolBar = new ToolBar();
        this._toolBar.setUseRolloverButtons(true);
        this._toolBar.setFloatable(false);
        if (this._app.getDesktopStyle().isInternalFrameStyle()) {
            JLabel lbl = new JLabel(this.getWindowTitle(), 0);
            lbl.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this._toolBar.add((Component)lbl, 0);
        }
        ActionCollection actions = this._app.getActionCollection();
        this._toolBar.add(actions.get(ConnectToAliasAction.class));
        this._toolBar.addSeparator();
        this._toolBar.add(actions.get(CreateAliasAction.class));
        this._toolBar.add(actions.get(ModifyAliasAction.class));
        this._toolBar.add(actions.get(CopyAliasAction.class));
        this._toolBar.add(actions.get(DeleteAliasAction.class));
        this._toolBar.addSeparator();
        this._toolBar.add(actions.get(AliasPropertiesAction.class));
        this._toolBar.addSeparator();
        this._toolBar.add(actions.get(AliasFileOpenAction.class));
        this._toolBar.addSeparator();
        this._toolBar.add(actions.get(FindAliasAction.class));
        this._toolBar.add(actions.get(SortAliasesAction.class));
        this._toolBar.add(actions.get(ColorAliasAction.class));
        this._toolBar.addSeparator();
        this._toolBar.addToggleAction((IToggleAction)actions.get(ToggleTreeViewAction.class));
        this._toolBar.add(actions.get(NewAliasFolderAction.class));
        this._toolBar.add(actions.get(CopyToPasteAliasFolderAction.class));
        this._toolBar.add(actions.get(CutAliasFolderAction.class));
        this._toolBar.add(actions.get(PasteAliasFolderAction.class));
        this._toolBar.add(actions.get(CollapseAllAliasFolderAction.class));
        this._toolBar.add(actions.get(ExpandAllAliasFolderAction.class));
        this._toolBar.add(actions.get(CollapseSelectedAliasFolderAction.class));
        this._toolBar.add(actions.get(ExpandSelectedAliasFolderAction.class));
        this._toolBar.addSeparator();
        this._toolBar.add(actions.get(TransferAliasAction.class));
        this._toolBar.addSeparator();
        this._toolBar.add(actions.get(ModifyMultipleAliasesAction.class));
    }

    public void removeToolbar() {
        this._toolBar = null;
    }

    public AliasesList getAliasesList() {
        return this._aliasesList;
    }

    @Override
    public ToolBar getToolBar() {
        return this._toolBar;
    }

    @Override
    public BasePopupMenu getPopupMenu() {
        return this._pm;
    }

    @Override
    public AliasesList getList() {
        return this._aliasesList;
    }
}

