/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.AliasInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.AliasMaintenanceType;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesAndDriversManager;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.util.IdentifierFactory;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifierFactory;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class AliasWindowFactory {
    private static final ILogger s_log = LoggerController.createLogger(AliasWindowFactory.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasWindowFactory.class);
    private static Map<IIdentifier, AliasInternalFrame> _modifySheets = new HashMap<IIdentifier, AliasInternalFrame>();

    public static AliasInternalFrame getModifySheet(SQLAlias alias) {
        return AliasWindowFactory._getModifySheet(alias, AliasMaintenanceType.MODIFY, Main.getApplication().getMainFrame());
    }

    public static AliasInternalFrame getModifyMultipleSheet(SQLAlias alias, Window parent) {
        return AliasWindowFactory._getModifySheet(alias, AliasMaintenanceType.MODIFY_MULTIPLE, parent);
    }

    private static AliasInternalFrame _getModifySheet(SQLAlias alias, AliasMaintenanceType aliasMaintenanceType, Window parent) {
        AliasInternalFrame sheet = _modifySheets.get(alias.getIdentifier());
        if (sheet == null) {
            sheet = new AliasInternalFrame(alias, aliasMaintenanceType, parent);
            _modifySheets.put(alias.getIdentifier(), sheet);
            Main.getApplication().getMainFrame().addWidget(sheet);
            sheet.addWidgetListener(new WidgetAdapter(){

                @Override
                public void widgetClosed(WidgetEvent evt) {
                    AliasInternalFrame frame = (AliasInternalFrame)evt.getWidget();
                    _modifySheets.remove(frame.getSQLAlias().getIdentifier());
                }
            });
            AliasWindowFactory.initAliasWidgetListener(sheet);
            DialogWidget.centerWithinDesktop(sheet);
        }
        return sheet;
    }

    private static void initAliasWidgetListener(final AliasInternalFrame sheet) {
        sheet.addWidgetListener(new WidgetAdapter(){

            @Override
            public void widgetClosed(WidgetEvent evt) {
                Main.getApplication().getWindowManager().getAliasesListInternalFrame().getAliasesList().aliasChanged(sheet.getSQLAlias());
                Main.getApplication().getWindowManager().getRecentAliasesListCtrl().aliasChanged(sheet.getSQLAlias());
            }
        });
    }

    public static AliasInternalFrame getCreateSheet() {
        AliasesAndDriversManager cache = Main.getApplication().getAliasesAndDriversManager();
        IIdentifierFactory factory = IdentifierFactory.getInstance();
        SQLAlias alias = cache.createAlias(factory.createIdentifier());
        AliasInternalFrame sheet = new AliasInternalFrame(alias, AliasMaintenanceType.NEW);
        Main.getApplication().getMainFrame().addWidget(sheet);
        DialogWidget.centerWithinDesktop(sheet);
        AliasWindowFactory.initAliasWidgetListener(sheet);
        return sheet;
    }

    public static AliasInternalFrame getCopySheet(SQLAlias alias) {
        AliasesAndDriversManager cache = Main.getApplication().getAliasesAndDriversManager();
        IIdentifierFactory factory = IdentifierFactory.getInstance();
        SQLAlias newAlias = cache.createAlias(factory.createIdentifier());
        newAlias.assignFrom(alias, false);
        if (2 == newAlias.getSchemaProperties().getGlobalState()) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("AliasWindowFactory.schemaPropsCopiedWarning"));
        }
        Main.getApplication().getPluginManager().aliasCopied(alias, newAlias);
        AliasInternalFrame sheet = new AliasInternalFrame(newAlias, AliasMaintenanceType.COPY);
        Main.getApplication().getMainFrame().addWidget(sheet);
        DialogWidget.centerWithinDesktop(sheet);
        AliasWindowFactory.initAliasWidgetListener(sheet);
        return sheet;
    }
}

