/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.Java8CloseableFix;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.listholder.AliasListHolder;
import net.sourceforge.squirrel_sql.client.gui.db.listholder.DriverListHolder;
import net.sourceforge.squirrel_sql.client.gui.db.listholder.ListHolder;
import net.sourceforge.squirrel_sql.client.session.schemainfo.SchemaInfoCacheSerializer;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener;
import net.sourceforge.squirrel_sql.fw.util.NullMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;

public class AliasesAndDriversManager {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasesAndDriversManager.class);
    private static final ILogger s_log = LoggerController.createLogger(AliasesAndDriversManager.class);
    private final SQLDriverManager _driverMgr;
    private AliasListHolder _aliasListHolder = new AliasListHolder();
    private DriverListHolder _driverListHolder = new DriverListHolder();

    public AliasesAndDriversManager(SQLDriverManager driverMgr, File driversFile, File aliasesFile, URL dftDriversURL) {
        if (driverMgr == null) {
            throw new IllegalArgumentException("SQLDriverManager == null");
        }
        if (driversFile == null) {
            throw new IllegalArgumentException("driversFile == null");
        }
        if (aliasesFile == null) {
            throw new IllegalArgumentException("aliasesFile == null");
        }
        if (dftDriversURL == null) {
            throw new IllegalArgumentException("dftDriversURL == null");
        }
        this._driverMgr = driverMgr;
        this.loadDrivers(driversFile, dftDriversURL, NullMessageHandler.getInstance());
        this.loadAliases(aliasesFile, NullMessageHandler.getInstance());
    }

    public void saveDrivers(File file) throws IOException, XMLException {
        if (file == null) {
            throw new IllegalArgumentException("File == null");
        }
        this.saveSecure(file, this._driverListHolder);
    }

    public void saveAliases(File file) throws IOException, XMLException {
        if (file == null) {
            throw new IllegalArgumentException("File == null");
        }
        this.saveSecure(file, this._aliasListHolder);
    }

    private void saveSecure(File file, ListHolder listHolder) {
        File tempFile = new File(file.getPath() + "~");
        try {
            tempFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        listHolder.save(tempFile.getPath());
        if (!tempFile.renameTo(file)) {
            File doubleTemp = new File(file.getPath() + "~~");
            try {
                doubleTemp.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            File buf = new File(file.getPath());
            if (!buf.renameTo(doubleTemp)) {
                throw new IllegalStateException("Cannot rename file " + buf.getPath() + " to " + doubleTemp.getPath() + ". New File will not be saved.");
            }
            try {
                tempFile.renameTo(file);
                doubleTemp.delete();
            }
            catch (Exception e) {
                doubleTemp.renameTo(file);
            }
        }
    }

    public ISQLDriver getDriver(IIdentifier id) {
        if (id == null) {
            throw new IllegalArgumentException("ISQLDriver == null");
        }
        return this._driverListHolder.get(id);
    }

    public void addDriver(ISQLDriver sqlDriver, IMessageHandler messageHandler) {
        if (sqlDriver == null) {
            throw new IllegalArgumentException("ISQLDriver == null");
        }
        if (messageHandler != null) {
            this.registerDriver(sqlDriver, messageHandler, true);
        }
        this._driverListHolder.add(sqlDriver);
    }

    public void removeDriver(ISQLDriver sqlDriver) {
        this._driverListHolder.remove(sqlDriver.getIdentifier());
        this._driverMgr.unregisterSQLDriver(sqlDriver);
    }

    public Iterator<SQLDriver> drivers() {
        return this._driverListHolder.getAll().iterator();
    }

    public void addDriversListener(IObjectCacheChangeListener lis) {
        this._driverListHolder.addChangesListener(lis);
    }

    public void removeDriversListener(IObjectCacheChangeListener lis) {
        this._driverListHolder.removeChangesListener(lis);
    }

    public SQLAlias getAlias(IIdentifier id) {
        return this._aliasListHolder.get(id);
    }

    public Iterator<? extends SQLAlias> aliases() {
        return this._aliasListHolder.getAll().iterator();
    }

    public List<? extends SQLAlias> getAliasList() {
        return this._aliasListHolder.getAll();
    }

    public List<SQLDriver> getDriverList() {
        return this._driverListHolder.getAll();
    }

    public void addAlias(SQLAlias alias) {
        this._aliasListHolder.add(alias);
    }

    public void removeAlias(SQLAlias alias) {
        SchemaInfoCacheSerializer.aliasRemoved(alias);
        Main.getApplication().getPluginManager().aliasRemoved(alias);
        this._aliasListHolder.remove(alias.getIdentifier());
    }

    public Iterator<SQLAlias> getAliasesForDriver(ISQLDriver driver) {
        ArrayList<SQLAlias> data = new ArrayList<SQLAlias>();
        Iterator<? extends SQLAlias> it = this.aliases();
        while (it.hasNext()) {
            SQLAlias alias = it.next();
            if (!driver.equals(this.getDriver(alias.getDriverIdentifier()))) continue;
            data.add(alias);
        }
        return data.iterator();
    }

    public void addAliasesListener(IObjectCacheChangeListener lis) {
        this._aliasListHolder.addChangesListener(lis);
    }

    public void removeAliasesListener(IObjectCacheChangeListener lis) {
        this._aliasListHolder.removeChangesListener(lis);
    }

    private void loadDrivers(File driversFile, URL dftDriversURL, IMessageHandler msgHandler) {
        block10: {
            if (driversFile == null) {
                throw new IllegalArgumentException("driversFile == null");
            }
            if (dftDriversURL == null) {
                throw new IllegalArgumentException("dftDriversURL == null");
            }
            if (msgHandler == null) {
                throw new IllegalArgumentException("msgHandler == null");
            }
            try {
                try {
                    this._driverListHolder.load(driversFile);
                    if (!this.drivers().hasNext()) {
                        this.loadDefaultDrivers(dftDriversURL);
                        break block10;
                    }
                    this.fixupDrivers();
                    this.mergeDefaultWebsites(dftDriversURL);
                }
                catch (FileNotFoundException ex) {
                    this.loadDefaultDrivers(dftDriversURL);
                }
                catch (Exception ex) {
                    String msg = s_stringMgr.getString("DataCache.error.loadingdrivers", driversFile.getPath());
                    s_log.error(msg, ex);
                    msgHandler.showErrorMessage(msg);
                    msgHandler.showErrorMessage(ex, null);
                    this.loadDefaultDrivers(dftDriversURL);
                }
            }
            catch (IOException ex) {
                s_log.error("Error loading drivers", ex);
            }
        }
        Iterator<SQLDriver> it = this.drivers();
        while (it.hasNext()) {
            this.registerDriver(it.next(), msgHandler, false);
        }
    }

    public SQLAlias createAlias(IIdentifier id) {
        return new SQLAlias(id);
    }

    public ISQLDriver createDriver(IIdentifier id) {
        return new SQLDriver(id);
    }

    public ISQLDriver[] findMissingDefaultDrivers(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            ISQLDriver[] result = null;
            ArrayList<ISQLDriver> missingDrivers = new ArrayList<ISQLDriver>();
            DriverListHolder tmp = new DriverListHolder();
            tmp.load(is);
            for (ISQLDriver iSQLDriver : tmp.getAll()) {
                if (this.containsDriver(iSQLDriver)) continue;
                missingDrivers.add(iSQLDriver);
            }
            if (missingDrivers.size() > 0) {
                result = missingDrivers.toArray(new ISQLDriver[missingDrivers.size()]);
            }
            ISQLDriver[] iSQLDriverArray = result;
            return iSQLDriverArray;
        }
    }

    public boolean containsDriver(ISQLDriver driver) {
        boolean result = false;
        for (ISQLDriver iSQLDriver : this._driverListHolder.getAll()) {
            if (!iSQLDriver.equals(driver)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void loadDefaultDrivers(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            this._driverListHolder.load(is);
        }
    }

    private void registerDriver(ISQLDriver sqlDriver, IMessageHandler msgHandler, boolean extendedMessaging) {
        String msg;
        boolean registrationSucessfully = false;
        try {
            this._driverMgr.registerSQLDriver(sqlDriver);
            registrationSucessfully = true;
        }
        catch (ClassNotFoundException cnfe) {
            if (extendedMessaging) {
                Object[] params = new Object[]{sqlDriver.getDriverClassName(), sqlDriver.getName(), cnfe};
                String msg2 = s_stringMgr.getString("DataCache.error.driverClassNotFound", params);
                s_log.error(msg2, cnfe);
                msgHandler.showErrorMessage(msg2);
            }
        }
        catch (Throwable th) {
            msg = s_stringMgr.getString("DataCache.error.registerdriver", sqlDriver.getName());
            s_log.error(msg, th);
            msgHandler.showErrorMessage(msg);
            msgHandler.showErrorMessage(th, null);
        }
        if (extendedMessaging && registrationSucessfully) {
            Object[] params = new Object[]{sqlDriver.getDriverClassName(), sqlDriver.getName()};
            msg = s_stringMgr.getString("DataCache.msg.driverRegisteredSucessfully", params);
            msgHandler.showMessage(msg);
        }
    }

    private void loadAliases(File aliasesFile, IMessageHandler msgHandler) {
        try (Java8CloseableFix java8Dum = Main.getApplication().getGlobalSQLAliasVersioner().switchOff();){
            this._aliasListHolder.load(aliasesFile);
        }
        catch (Exception ex) {
            String msg = s_stringMgr.getString("DataCache.error.loadingaliases", aliasesFile.getPath());
            s_log.error(msg, ex);
            msgHandler.showErrorMessage(msg);
            msgHandler.showErrorMessage(ex, null);
        }
    }

    private void fixupDrivers() {
        Iterator<SQLDriver> it = this.drivers();
        while (it.hasNext()) {
            String fileName;
            ISQLDriver driver = it.next();
            String[] fileNames = driver.getJarFileNames();
            if (fileNames != null && fileNames.length != 0 || (fileName = driver.getJarFileName()) == null || fileName.length() <= 0) continue;
            driver.setJarFileNames(new String[]{fileName});
            try {
                driver.setJarFileName(null);
            }
            catch (ValidationException validationException) {}
        }
    }

    private void mergeDefaultWebsites(URL defaultDriversUrl) {
        try (InputStream is = defaultDriversUrl.openStream();){
            DriverListHolder tmp = new DriverListHolder();
            tmp.load(is);
            for (ISQLDriver iSQLDriver : tmp.getAll()) {
                ISQLDriver cachedDriver = this.getDriver(iSQLDriver.getIdentifier());
                if (cachedDriver == null || cachedDriver.getWebSiteUrl() != null && !"".equals(cachedDriver.getWebSiteUrl()) || iSQLDriver.getWebSiteUrl() == null) continue;
                cachedDriver.setWebSiteUrl(iSQLDriver.getWebSiteUrl());
            }
        }
        catch (Exception ex) {
            s_log.error("Received an unexpected Exception", ex);
        }
    }

    public void refreshDriver(ISQLDriver driver, IMessageHandler messageHandler) {
        this.registerDriver(driver, messageHandler, true);
    }
}

