/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.AliasFolder;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesListModel;
import net.sourceforge.squirrel_sql.client.gui.db.IAliasTreeInterface;
import net.sourceforge.squirrel_sql.client.gui.db.IAliasesList;
import net.sourceforge.squirrel_sql.client.gui.db.IToogleableAliasesList;
import net.sourceforge.squirrel_sql.client.gui.db.JListAliasesListImpl;
import net.sourceforge.squirrel_sql.client.gui.db.JTreeAliasesListImpl;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class AliasesList
implements IToogleableAliasesList {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasesList.class);
    private JPanel _pnlContainer = new JPanel(new GridLayout(1, 1));
    private JListAliasesListImpl _jListImpl;
    private JTreeAliasesListImpl _jTreeImpl;
    private boolean _viewAsTree;

    public AliasesList(IApplication app) {
        AliasesListModel listModel = new AliasesListModel(app);
        this._jListImpl = new JListAliasesListImpl(app, listModel, item -> this.onAliasSelected(item));
        this._jTreeImpl = new JTreeAliasesListImpl(app, listModel, item -> this.onAliasSelected(item));
    }

    private void onAliasSelected(SQLAlias item) {
        String label = null;
        if (item != null) {
            label = item.getUrl();
        }
        Main.getApplication().getMainFrame().setStatusText(label);
    }

    public void nowVisible(boolean b) {
        if (b) {
            this.onAliasSelected(this.getLeadSelectionValue());
        } else {
            this.onAliasSelected(null);
        }
    }

    private IAliasesList getCurrentImpl() {
        if (this._viewAsTree) {
            return this._jTreeImpl;
        }
        return this._jListImpl;
    }

    @Override
    public void setViewAsTree(boolean b) {
        this._viewAsTree = b;
        if (this._viewAsTree) {
            this._pnlContainer.remove(this._jListImpl.getComponent());
            this._pnlContainer.add(this._jTreeImpl.getComponent());
        } else {
            this._pnlContainer.remove(this._jTreeImpl.getComponent());
            this._pnlContainer.add(this._jListImpl.getComponent());
        }
        this._pnlContainer.validate();
        this._pnlContainer.repaint();
    }

    @Override
    public boolean isViewAsTree() {
        return this._viewAsTree;
    }

    @Override
    public IAliasTreeInterface getAliasTreeInterface() {
        return this._jTreeImpl;
    }

    @Override
    public void deleteSelected() {
        this.getCurrentImpl().deleteSelected();
    }

    @Override
    public void colorSelected() {
        this.getCurrentImpl().colorSelected();
    }

    @Override
    public void modifySelected() {
        this.getCurrentImpl().modifySelected();
    }

    @Override
    public boolean isEmpty() {
        return this.getCurrentImpl().isEmpty();
    }

    @Override
    public void goToAlias(SQLAlias aliasToGoTo) {
        this.getCurrentImpl().goToAlias(aliasToGoTo);
    }

    @Override
    public SQLAlias getSelectedAlias(MouseEvent evt) {
        return this.getCurrentImpl().getSelectedAlias(evt);
    }

    @Override
    public SQLAlias getLeadSelectionValue() {
        return this.getCurrentImpl().getLeadSelectionValue();
    }

    @Override
    public void sortAliases() {
        this.getCurrentImpl().sortAliases();
    }

    @Override
    public void requestFocus() {
        this.getCurrentImpl().requestFocus();
    }

    @Override
    public JComponent getComponent() {
        return this._pnlContainer;
    }

    @Override
    public void selectListEntryAtPoint(Point point) {
        this.getCurrentImpl().selectListEntryAtPoint(point);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this._jListImpl.addMouseListener(mouseListener);
        this._jTreeImpl.addMouseListener(mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this._jListImpl.removeMouseListener(mouseListener);
        this._jTreeImpl.removeMouseListener(mouseListener);
    }

    @Override
    public void aliasChanged(SQLAlias sqlAlias) {
        this._jListImpl.aliasChanged(sqlAlias);
        this._jTreeImpl.aliasChanged(sqlAlias);
    }

    @Override
    public List<SQLAlias> updateAliasesByImport(List<SQLAlias> importSqlAliases, boolean respectAliasVersionTimeMills) {
        ArrayList<SQLAlias> ret = new ArrayList<SQLAlias>();
        for (SQLAlias sQLAlias : Main.getApplication().getAliasesAndDriversManager().getAliasList()) {
            for (SQLAlias importSqlAlias : importSqlAliases) {
                if (!StringUtilities.equalsRespectNullModuloEmptyAndWhiteSpace(sQLAlias.getName(), importSqlAlias.getName())) continue;
                SQLAlias sqlAlias = sQLAlias;
                if (respectAliasVersionTimeMills && importSqlAlias.getAliasVersionTimeMills() <= sqlAlias.getAliasVersionTimeMills()) continue;
                sqlAlias.assignFrom(importSqlAlias, false);
                this.aliasChanged(sqlAlias);
                Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("AliasesList.alias.updated", sqlAlias.getName()));
                ret.add(importSqlAlias);
            }
        }
        return ret;
    }

    @Override
    public void goToAliasFolder(AliasFolder aliasFolder) {
        this.getCurrentImpl().goToAliasFolder(aliasFolder);
    }
}

