/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.AliasUserInterfaceFactory;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesList;
import net.sourceforge.squirrel_sql.client.gui.db.BaseListInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class AliasesListInternalFrame
extends BaseListInternalFrame<AliasesList> {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasesListInternalFrame.class);
    private IApplication _app;
    private AliasUserInterfaceFactory _uiFactory;

    public AliasesListInternalFrame(IApplication app, AliasesList list) {
        super(new AliasUserInterfaceFactory(list));
        this._app = app;
        this._uiFactory = (AliasUserInterfaceFactory)this.getUserInterfaceFactory();
        this.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if ("closed".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
                    AliasesListInternalFrame.this.nowVisible(true);
                    throw new PropertyVetoException(s_stringMgr.getString("AliasesListInternalFrame.error.ctrlF4key"), evt);
                }
            }
        });
        this.addWidgetListener(new WidgetAdapter(){

            @Override
            public void widgetOpened(WidgetEvent evt) {
                AliasesListInternalFrame.this.nowVisible(true);
            }

            @Override
            public boolean widgetClosing(WidgetEvent evt) {
                AliasesListInternalFrame.this.nowVisible(false);
                return true;
            }

            @Override
            public void widgetClosed(WidgetEvent evt) {
                AliasesListInternalFrame.this.nowVisible(false);
            }
        });
        this._app.getSquirrelPreferences().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName;
                String string = propName = evt != null ? evt.getPropertyName() : null;
                if (propName == null || propName.equals("showAliasesToolBar")) {
                    boolean show = AliasesListInternalFrame.this._app.getSquirrelPreferences().getShowAliasesToolBar();
                    if (show) {
                        AliasesListInternalFrame.this._uiFactory.createToolBar();
                    } else {
                        AliasesListInternalFrame.this._uiFactory.removeToolbar();
                    }
                    AliasesListInternalFrame.this.setToolBar(AliasesListInternalFrame.this._uiFactory.getToolBar());
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AliasesListInternalFrame.this._uiFactory.getAliasesList().requestFocus();
            }
        });
    }

    public AliasesList getAliasesList() {
        return this._uiFactory.getAliasesList();
    }

    public void nowVisible(boolean b) {
        SwingUtilities.invokeLater(() -> this._nowVisible(b));
    }

    private void _nowVisible(boolean b) {
        this._app.getMainFrame().setEnabledAliasesMenu(b);
        this._uiFactory.getAliasesList().requestFocus();
        this._uiFactory.getAliasesList().nowVisible(b);
    }

    public void enableDisableActions() {
        this._uiFactory.enableDisableActions();
    }

    public boolean isEmpty() {
        return this._uiFactory.getAliasesList().isEmpty();
    }
}

