/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.IBaseList;
import net.sourceforge.squirrel_sql.client.gui.db.IUserInterfaceFactory;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DockWidget;
import net.sourceforge.squirrel_sql.fw.gui.BasePopupMenu;
import net.sourceforge.squirrel_sql.fw.gui.ToolBar;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

abstract class BaseListInternalFrame<T extends IBaseList>
extends DockWidget {
    private static final ILogger s_log = LoggerController.createLogger(BaseListInternalFrame.class);
    private IUserInterfaceFactory<T> _uiFactory;
    private BasePopupMenu _popupMenu;
    private ToolBar _toolBar;
    private boolean _hasBeenSized = false;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(BaseListInternalFrame.class);

    public BaseListInternalFrame(IUserInterfaceFactory<T> uiFactory) {
        super(uiFactory.getWindowTitle(), true, true, Main.getApplication());
        this._uiFactory = uiFactory;
        this.createUserInterface();
    }

    protected IUserInterfaceFactory<T> getUserInterfaceFactory() {
        return this._uiFactory;
    }

    protected void setToolBar(ToolBar tb) {
        Container content = this.getContentPane();
        if (this._toolBar != null) {
            content.remove(this._toolBar);
        }
        if (tb != null) {
            content.add((Component)tb, "North");
        }
        this._toolBar = tb;
    }

    private void onMousePress(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            if (Main.getApplication().getSquirrelPreferences().getSelectOnRightMouseClick()) {
                this._uiFactory.getList().selectListEntryAtPoint(evt.getPoint());
            }
            if (this._popupMenu == null) {
                this._popupMenu = this._uiFactory.getPopupMenu();
            }
            this._popupMenu.show(evt);
        }
    }

    private void onMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            try {
                this._uiFactory.execDoubleClickCommand(evt);
            }
            catch (Exception e) {
                s_log.error(s_stringMgr.getString("BaseListInternalFrame.error.execdoubleclick"), e);
            }
        }
    }

    private void privateResize() {
        if (!this._hasBeenSized && this._toolBar != null) {
            this._hasBeenSized = true;
            Dimension windowSize = this.getSize();
            int rqdWidth = this._toolBar.getPreferredSize().width + 15;
            if (rqdWidth > windowSize.width) {
                windowSize.width = rqdWidth;
                this.setSize(windowSize);
            }
        }
    }

    private void createUserInterface() {
        this.makeToolWindow(true);
        this.setDefaultCloseOperation(1);
        Container content = this.getContentPane();
        content.setLayout(new BorderLayout());
        String winTitle = this._uiFactory.getWindowTitle();
        if (winTitle != null) {
            this.setTitle(winTitle);
        }
        this.setToolBar(this._uiFactory.getToolBar());
        T list = this._uiFactory.getList();
        content.add((Component)list.getComponent(), "Center");
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                BaseListInternalFrame.this.onMousePress(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                BaseListInternalFrame.this.onMousePress(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                BaseListInternalFrame.this.onMouseClicked(evt);
            }
        });
    }
}

