/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.squirrel_sql.client.gui.db.IDisposableDialog;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ColumnListDialog
extends JDialog
implements IDisposableDialog {
    private JLabel tableNameLabel = null;
    private JLabel primaryKeyNameLabel = null;
    private JTextField tableNameTextField = null;
    private JLabel columnListLabel = null;
    private JList columnList = null;
    private JButton executeButton = null;
    private JButton editSQLButton = null;
    private JButton showSQLButton = null;
    private JButton cancelButton = null;
    private JTextField primaryKeyNameTF = null;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ColumnListDialog.class);
    public static final int DROP_COLUMN_MODE = 0;
    public static final int MODIFY_COLUMN_MODE = 1;
    public static final int ADD_PRIMARY_KEY_MODE = 2;
    public static final int DROP_PRIMARY_KEY_MODE = 3;
    private int _mode = 0;
    private TableColumnInfo[] colInfos = null;

    public ColumnListDialog(TableColumnInfo[] columnInfos, int mode) {
        this._mode = mode;
        this.setColumnList(columnInfos);
    }

    private void setColumnList(TableColumnInfo[] columnInfos) {
        this.colInfos = columnInfos;
        ArrayList<String> tmp = new ArrayList<String>();
        for (TableColumnInfo info : this.colInfos) {
            tmp.add(info.getColumnName());
        }
        String[] cols = tmp.toArray(new String[tmp.size()]);
        if (this.columnList != null) {
            this.columnList.setListData(cols);
        } else {
            this.init(cols);
        }
        if (this._mode == 3) {
            this.columnList.setEnabled(false);
        }
    }

    public void setTableName(String tableName) {
        this.tableNameTextField.setText(tableName);
    }

    public String getTableName() {
        return this.tableNameTextField.getText();
    }

    public void setPrimaryKeyName(String primaryKeyName) {
        this.primaryKeyNameTF.setText(primaryKeyName);
    }

    public String getPrimaryKeyName() {
        return this.primaryKeyNameTF.getText();
    }

    public TableColumnInfo[] getSelectedColumnList() {
        ArrayList<TableColumnInfo> result = new ArrayList<TableColumnInfo>();
        List selectedColNames = this.columnList.getSelectedValuesList();
        for (int i = 0; i < selectedColNames.size(); ++i) {
            String columnName = (String)selectedColNames.get(i);
            result.add(this.getColInfoByName(columnName));
        }
        return result.toArray(new TableColumnInfo[result.size()]);
    }

    private TableColumnInfo getColInfoByName(String columnName) {
        for (TableColumnInfo colInfo : this.colInfos) {
            if (!colInfo.getColumnName().equals(columnName)) continue;
            return colInfo;
        }
        return null;
    }

    public void addColumnSelectionListener(ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.executeButton.addActionListener(listener);
    }

    public void addShowSQLListener(ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.showSQLButton.addActionListener(listener);
    }

    public void addEditSQLListener(ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.editSQLButton.addActionListener(listener);
    }

    public void setMultiSelection() {
        this.columnList.setSelectionMode(2);
    }

    public void setSingleSelection() {
        this.columnList.setSelectionMode(0);
    }

    private GridBagConstraints getLabelConstraints(GridBagConstraints c) {
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 12;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        return c;
    }

    private GridBagConstraints getFieldConstraints(GridBagConstraints c) {
        ++c.gridx;
        c.anchor = 18;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        return c;
    }

    private JLabel getBorderedLabel(String text, Border border) {
        JLabel result = new JLabel(text);
        result.setBorder(border);
        result.setPreferredSize(new Dimension(115, 20));
        result.setHorizontalAlignment(4);
        return result;
    }

    private void init(String[] columnNames) {
        super.setModal(true);
        if (this._mode == 0) {
            this.setTitle(i18n.DROP_TITLE);
        }
        if (this._mode == 1) {
            this.setTitle(i18n.MODIFY_TITLE);
        }
        if (this._mode == 2) {
            this.setTitle(i18n.PRIMARY_KEY_TITLE);
        }
        if (this._mode == 3) {
            this.setTitle(i18n.DROP_PRIMARY_KEY_TITLE);
        }
        this.setSize(425, 250);
        EmptyBorder border = new EmptyBorder(new Insets(5, 5, 5, 5));
        Dimension mediumField = new Dimension(126, 20);
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        pane.setBorder(new EmptyBorder(10, 0, 0, 30));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = -1;
        this.tableNameLabel = this.getBorderedLabel(i18n.TABLE_NAME_LABEL, border);
        pane.add((Component)this.tableNameLabel, this.getLabelConstraints(c));
        this.tableNameTextField = new JTextField();
        this.tableNameTextField.setPreferredSize(mediumField);
        this.tableNameTextField.setEditable(false);
        pane.add((Component)this.tableNameTextField, this.getFieldConstraints(c));
        if (this._mode == 2 || this._mode == 3) {
            this.primaryKeyNameLabel = new JLabel(i18n.PRIMARY_KEY_NAME_LABEL);
            pane.add((Component)this.primaryKeyNameLabel, this.getLabelConstraints(c));
            this.primaryKeyNameTF = new JTextField();
            this.primaryKeyNameTF.setPreferredSize(mediumField);
            if (this._mode == 2) {
                this.primaryKeyNameTF.setEditable(true);
            } else {
                this.primaryKeyNameTF.setEditable(false);
            }
            pane.add((Component)this.primaryKeyNameTF, this.getFieldConstraints(c));
        }
        this.columnListLabel = this.getBorderedLabel(i18n.COLUMN_NAME_LABEL, border);
        this.columnListLabel.setVerticalAlignment(1);
        pane.add((Component)this.columnListLabel, this.getLabelConstraints(c));
        this.columnList = new JList<String>(columnNames);
        this.columnList.addListSelectionListener(new ColumnListSelectionListener());
        JScrollPane sp = new JScrollPane(this.columnList);
        c = this.getFieldConstraints(c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        pane.add((Component)sp, c);
        Container contentPane = super.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)pane, "Center");
        contentPane.add((Component)this.getButtonPanel(), "South");
    }

    private JPanel getButtonPanel() {
        JPanel result = new JPanel();
        this.executeButton = this._mode == 1 ? new JButton(i18n.MODIFY_BUTTON_LABEL) : new JButton(i18n.EXECUTE_BUTTON_LABEL);
        result.add(this.executeButton);
        if (this._mode != 1) {
            this.editSQLButton = new JButton(i18n.EDIT_BUTTON_LABEL);
            result.add(this.editSQLButton);
            this.showSQLButton = new JButton(i18n.SHOWSQL_BUTTON_LABEL);
            result.add(this.showSQLButton);
        }
        this.cancelButton = new JButton(i18n.CANCEL_BUTTON_LABEL);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnListDialog.this.setVisible(false);
                ColumnListDialog.this.dispose();
            }
        });
        result.add(this.cancelButton);
        if (this._mode != 3) {
            this.executeButton.setEnabled(false);
            if (this._mode != 1) {
                this.editSQLButton.setEnabled(false);
                this.showSQLButton.setEnabled(false);
            }
        }
        return result;
    }

    private void enable(JButton button) {
        if (button != null) {
            button.setEnabled(true);
        }
    }

    private void disable(JButton button) {
        if (button != null) {
            button.setEnabled(false);
        }
    }

    private class ColumnListSelectionListener
    implements ListSelectionListener {
        private ColumnListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int[] selected = ColumnListDialog.this.columnList.getSelectedIndices();
            if (ColumnListDialog.this._mode != 3 && (selected == null || selected.length == 0)) {
                ColumnListDialog.this.disable(ColumnListDialog.this.executeButton);
                ColumnListDialog.this.disable(ColumnListDialog.this.editSQLButton);
                ColumnListDialog.this.disable(ColumnListDialog.this.showSQLButton);
                return;
            }
            if (ColumnListDialog.this._mode == 0 && selected.length == ColumnListDialog.this.columnList.getModel().getSize()) {
                JOptionPane.showMessageDialog(ColumnListDialog.this, i18n.DROP_ERROR_MESSAGE, i18n.DROP_ERROR_TITLE, 0);
                ColumnListDialog.this.columnList.clearSelection();
                ColumnListDialog.this.disable(ColumnListDialog.this.executeButton);
                ColumnListDialog.this.disable(ColumnListDialog.this.editSQLButton);
                ColumnListDialog.this.disable(ColumnListDialog.this.showSQLButton);
                return;
            }
            ColumnListDialog.this.enable(ColumnListDialog.this.executeButton);
            ColumnListDialog.this.enable(ColumnListDialog.this.editSQLButton);
            ColumnListDialog.this.enable(ColumnListDialog.this.showSQLButton);
        }
    }

    private static interface i18n {
        public static final String EXECUTE_BUTTON_LABEL = s_stringMgr.getString("ColumnListDialog.executeButtonLabel");
        public static final String CANCEL_BUTTON_LABEL = s_stringMgr.getString("ColumnListDialog.cancelButtonLabel");
        public static final String COLUMN_NAME_LABEL = s_stringMgr.getString("ColumnListDialog.columnNameLabel");
        public static final String DROP_ERROR_MESSAGE = s_stringMgr.getString("ColumnListDialog.dropErrorMessage");
        public static final String DROP_ERROR_TITLE = s_stringMgr.getString("ColumnListDialog.dropErrorTitle");
        public static final String DROP_PRIMARY_KEY_TITLE = s_stringMgr.getString("ColumnListDialog.dropPrimaryKeyTitle");
        public static final String DROP_TITLE = s_stringMgr.getString("ColumnListDialog.dropTitle");
        public static final String MODIFY_BUTTON_LABEL = s_stringMgr.getString("ColumnDetailsDialog.modifyButtonLabel");
        public static final String MODIFY_TITLE = s_stringMgr.getString("ColumnListDialog.modifyTitle");
        public static final String PRIMARY_KEY_TITLE = s_stringMgr.getString("ColumnListDialog.primaryKeyTitle");
        public static final String PRIMARY_KEY_NAME_LABEL = s_stringMgr.getString("ColumnListDialog.primaryKeyNameLabel");
        public static final String SHOWSQL_BUTTON_LABEL = s_stringMgr.getString("ColumnListDialog.showSQLButtonLabel");
        public static final String TABLE_NAME_LABEL = s_stringMgr.getString("ColumnListDialog.tableNameLabel");
        public static final String EDIT_BUTTON_LABEL = s_stringMgr.getString("ColumnListDialog.editSQLButtonLabel");
    }
}

