/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.Frame;
import java.sql.SQLException;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.ConnectCompletionCallback;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.ErrorDialog;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.WrappedSQLException;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ConnectToAliasCallBack
implements ConnectCompletionCallback {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ConnectToAliasCallBack.class);
    private static final ILogger s_log = LoggerController.createLogger(ConnectToAliasCallBack.class);
    private final SQLAlias _sqlAlias;

    public ConnectToAliasCallBack(SQLAlias alias) {
        if (alias == null) {
            throw new IllegalArgumentException("SQLAlias == null");
        }
        this._sqlAlias = alias;
    }

    @Override
    public void connected(ISQLConnection conn) {
    }

    @Override
    public void sessionCreated(ISession session) {
    }

    @Override
    public void sessionInternalFrameCreated(SessionInternalFrame sessionInternalFrame) {
    }

    @Override
    public void errorOccurred(Throwable th, boolean connectingHasBeenCanceledByUser) {
        if ((th = Utilities.getDeepestThrowable(th)) instanceof WrappedSQLException) {
            th = ((WrappedSQLException)th).getSQLExeption();
        }
        if (th instanceof SQLException) {
            Object msg = th.getMessage();
            if (msg == null || ((String)msg).length() == 0) {
                msg = s_stringMgr.getString("ConnectToAliasCommand.error.cantopen");
            }
            msg = this._sqlAlias.getName() + ": " + (String)msg;
            if (!connectingHasBeenCanceledByUser) {
                this.showErrorDialog(this.getMsg((String)msg, th), th);
            } else {
                s_log.error(msg, th);
            }
        } else if (th instanceof ClassNotFoundException) {
            String msg = s_stringMgr.getString("ConnectToAliasCommand.error.driver", this._sqlAlias.getName());
            if (!connectingHasBeenCanceledByUser) {
                this.showErrorDialog(this.getMsg(msg, th), th);
            }
        } else if (th instanceof NoClassDefFoundError) {
            String msg = s_stringMgr.getString("ConnectToAliasCommand.error.driver", this._sqlAlias.getName());
            s_log.error(msg, th);
            if (!connectingHasBeenCanceledByUser) {
                this.showErrorDialog(this.getMsg(msg, th), th);
            }
        } else {
            String msg = s_stringMgr.getString("ConnectToAliasCommand.error.unexpected", this._sqlAlias.getName());
            s_log.debug(th.getClass().getName());
            s_log.error(msg, th);
            if (!connectingHasBeenCanceledByUser) {
                this.showErrorDialog(this.getMsg(msg, th), th);
            }
        }
    }

    private String getMsg(String msg, Throwable th) {
        return msg + "\n" + th.getClass() + ": " + th.getMessage();
    }

    private void showErrorDialog(String msg, Throwable th) {
        SwingUtilities.invokeLater(() -> new ErrorDialog((Frame)Main.getApplication().getMainFrame(), msg, th).setVisible(true));
    }

    public SQLAlias getAlias() {
        return this._sqlAlias;
    }
}

