/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.IOkClosePanelListener;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanel;
import net.sourceforge.squirrel_sql.client.gui.OkClosePanelEvent;
import net.sourceforge.squirrel_sql.client.gui.db.ConnectCompletionCallback;
import net.sourceforge.squirrel_sql.client.gui.db.ConnectionInternalFrameHandler;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.encryption.AliasPasswordHandler;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.mainframe.action.AliasPropertiesCommand;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class ConnectionInternalFrame
extends DialogWidget {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ConnectionInternalFrame.class);
    private static final ILogger s_log = LoggerController.createLogger(ConnectionInternalFrame.class);
    private SQLAlias _alias;
    private ISQLDriver _sqlDriver;
    private volatile boolean _connecting;
    private ConnectionInternalFrameHandler _handler;
    private JLabel _aliasName = new JLabel();
    private JLabel _driverName = new JLabel();
    private JLabel _url = new JLabel();
    private JTextField _user = new JTextField();
    private JPasswordField _password = new JPasswordField();
    private OkClosePanel _btnsPnl = new OkClosePanel(s_stringMgr.getString("ConnectionInternalFrame.connect"));
    private boolean _driverPropertiesLoaded = false;
    private final JButton _aliasPropsBtn = new JButton(s_stringMgr.getString("ConnectionInternalFrame.props"));
    private JTextField _statusBar = new JTextField();

    public ConnectionInternalFrame(SQLAlias sqlAlias, boolean createSession, ConnectCompletionCallback completionCallback) {
        super("", true);
        if (sqlAlias == null) {
            throw new IllegalArgumentException("Null SQLAlias passed");
        }
        this._alias = sqlAlias;
        this._handler = new ConnectionInternalFrameHandler(sqlAlias, createSession, completionCallback);
        this._sqlDriver = Main.getApplication().getAliasesAndDriversManager().getDriver(this._alias.getDriverIdentifier());
        if (this._sqlDriver == null) {
            throw new IllegalStateException(s_stringMgr.getString("ConnectionInternalFrame.error.nodriver", this._alias.getName()));
        }
        this.createGUI();
        this.loadData();
        this.pack();
        if (StringUtilities.isEmpty(this._user.getText())) {
            GUIUtils.forceFocus(this._user);
        } else if (null == this._password.getPassword() || 0 == this._password.getPassword().length) {
            GUIUtils.forceFocus(this._password);
        }
    }

    public void finishedCreatingConnection(final boolean connected) {
        this._connecting = false;
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                if (connected) {
                    ConnectionInternalFrame.this.close();
                } else {
                    ConnectionInternalFrame.this.setStatusText(null);
                    ConnectionInternalFrame.this._user.setEnabled(true);
                    ConnectionInternalFrame.this._password.setEnabled(true);
                    ConnectionInternalFrame.this._btnsPnl.setExecuting(false);
                }
            }
        });
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this._alias.isAutoLogon()) {
            SwingUtilities.invokeLater(() -> this.connect());
        }
    }

    public void setStatusText(String text) {
        this._statusBar.setText(text);
    }

    private void initKeyListeners() {
        ActionListener escapeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionInternalFrame.this.dispose();
            }
        };
        ActionListener enterListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionInternalFrame.this.connect();
            }
        };
        JRootPane pane = this.getRootPane();
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        pane.registerKeyboardAction(escapeListener, ks, 2);
        ks = KeyStroke.getKeyStroke(10, 0);
        pane.registerKeyboardAction(enterListener, ks, 2);
    }

    private void loadData() {
        if (SwingUtilities.isEventDispatchThread()) {
            this._loadData();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConnectionInternalFrame.this._loadData();
                }
            });
        }
    }

    private void _loadData() {
        String userName = this._alias.getUserName();
        String password = AliasPasswordHandler.getPassword(this._alias);
        this._aliasName.setText(this._alias.getName());
        this._driverName.setText(this._sqlDriver.getName());
        this._url.setText(this._alias.getUrl());
        this._user.setText(userName);
        this._password.setText(password);
        this._aliasName.setToolTipText(this._aliasName.getText());
        this._driverName.setToolTipText(this._driverName.getText());
        this._url.setToolTipText(this._url.getText());
    }

    private void connect() {
        if (!this._connecting) {
            this._connecting = true;
            this._btnsPnl.setExecuting(true);
            this.setStatusText(s_stringMgr.getString("ConnectionInternalFrame.connecting"));
            this._user.setEnabled(false);
            this._password.setEnabled(false);
            SQLDriverPropertyCollection driverProperties = this._alias.getDriverPropertiesClone();
            if (!this._alias.getUseDriverProperties()) {
                driverProperties.clear();
            }
            this._handler.performConnect(this, this._user.getText(), this._password.getText(), driverProperties);
        }
    }

    private void cancelConnect() {
        if (this._connecting) {
            this.setStatusText(s_stringMgr.getString("ConnectionInternalFrame.cancelling"));
            this._btnsPnl.enableCloseButton(false);
            this._handler.performCancelConnect(this);
            this._connecting = false;
            this.close();
        }
    }

    private void createGUI() {
        this.setDefaultCloseOperation(2);
        this.makeToolWindow(true);
        String winTitle = s_stringMgr.getString("ConnectionInternalFrame.title", this._alias.getName());
        this.setTitle(winTitle);
        this._statusBar.setEditable(false);
        GUIUtils.inheritBackground(this._statusBar);
        Main.getApplication().getFontInfoStore().setUpStatusBarFont(this._statusBar);
        JPanel content = new JPanel(new BorderLayout());
        content.add(this.createMainPanel(), "Center");
        content.add((Component)this._statusBar, "South");
        this.setContentPane(content);
        this.initKeyListeners();
    }

    private Component createMainPanel() {
        this._user.setColumns(20);
        this._password.setColumns(20);
        this._aliasPropsBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectionInternalFrame.this.showDriverPropertiesDialog();
            }
        });
        this._btnsPnl.addListener(new MyOkClosePanelListener());
        JPanel ret = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 5), 0, 0);
        ret.add((Component)GUIUtils.createHorizontalSeparatorPanel(this.getTitle()), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("ConnectionInternalFrame.alias")), gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 5), 0, 0);
        ret.add((Component)this._aliasName, gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("ConnectionInternalFrame.driver")), gbc);
        gbc = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 5), 0, 0);
        ret.add((Component)this._driverName, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("ConnectionInternalFrame.url")), gbc);
        gbc = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 5), 0, 0);
        ret.add((Component)this._url, gbc);
        gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("ConnectionInternalFrame.user")), gbc);
        gbc = new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 5), 0, 0);
        ret.add((Component)this._user, gbc);
        gbc = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("ConnectionInternalFrame.password")), gbc);
        gbc = new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 5), 0, 0);
        ret.add((Component)this._password, gbc);
        gbc = new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 5), 0, 0);
        this._aliasPropsBtn.setIcon(Main.getApplication().getResources().getIcon("aliasProperties"));
        ret.add((Component)this._aliasPropsBtn, gbc);
        gbc = new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 5), 0, 0);
        ret.add((Component)new JLabel(s_stringMgr.getString("ConnectionInternalFrame.warningcapslock")), gbc);
        gbc = new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 5), 0, 0);
        ret.add((Component)GUIUtils.createHorizontalSeparatorPanel(), gbc);
        gbc = new GridBagConstraints(0, 9, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 0, 5), 0, 0);
        ret.add((Component)this._btnsPnl, gbc);
        this.addWidgetListener(new WidgetAdapter(){
            private WidgetAdapter _this;

            @Override
            public void widgetActivated(WidgetEvent evt) {
                this._this = this;
                String userName = ConnectionInternalFrame.this._user.getText();
                if (userName != null && userName.length() > 0) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String pw = ConnectionInternalFrame.this._password.getText();
                            if (pw != null && pw.length() > 0) {
                                ConnectionInternalFrame.this._btnsPnl.getOKButton().requestFocus();
                            } else {
                                ConnectionInternalFrame.this._password.requestFocus();
                            }
                            ConnectionInternalFrame.this.removeWidgetListener(_this);
                        }
                    });
                }
            }
        });
        return ret;
    }

    private void showDriverPropertiesDialog() {
        new AliasPropertiesCommand(this._alias).execute();
    }

    private final class MyOkClosePanelListener
    implements IOkClosePanelListener {
        private MyOkClosePanelListener() {
        }

        @Override
        public void okPressed(OkClosePanelEvent evt) {
            ConnectionInternalFrame.this.connect();
        }

        @Override
        public void closePressed(OkClosePanelEvent evt) {
            ConnectionInternalFrame.this.close();
        }

        @Override
        public void cancelPressed(OkClosePanelEvent evt) {
            ConnectionInternalFrame.this.cancelConnect();
        }
    }
}

