/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.ConnectCompletionCallback;
import net.sourceforge.squirrel_sql.client.gui.db.ConnectionInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.encryption.AliasPasswordHandler;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.mainframe.action.ConnectToAliasCommand;
import net.sourceforge.squirrel_sql.client.mainframe.action.openconnection.OpenConnectionCommand;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SessionManager;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

class ConnectionInternalFrameHandler {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ConnectionInternalFrameHandler.class);
    private static final ILogger s_log = LoggerController.createLogger(ConnectToAliasCommand.class);
    private ConnectionInternalFrame _connectionInternalFrame;
    private IApplication _app;
    private SQLAlias _alias;
    private boolean _createSession;
    private String _user;
    private String _password;
    private SQLDriverPropertyCollection _props;
    private volatile boolean _connectWasCanceled;
    private ConnectCompletionCallback _callback;

    ConnectionInternalFrameHandler(SQLAlias alias, boolean createSession, ConnectCompletionCallback callback) {
        if (alias == null) {
            throw new IllegalArgumentException("SQLAlias == null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("ICompletionCallback == null");
        }
        this._app = Main.getApplication();
        this._alias = alias;
        this._createSession = createSession;
        this._callback = callback;
    }

    public void performConnect(ConnectionInternalFrame connSheet, String user, String password, SQLDriverPropertyCollection props) {
        this._connectWasCanceled = false;
        this._connectionInternalFrame = connSheet;
        this._user = user;
        this._password = password;
        this._props = props;
        this.doConnect();
    }

    public void performCancelConnect(ConnectionInternalFrame connSheet) {
        this._connectWasCanceled = true;
    }

    public void doConnect() {
        IIdentifier driverID = this._alias.getDriverIdentifier();
        ISQLDriver sqlDriver = this._app.getAliasesAndDriversManager().getDriver(driverID);
        try {
            OpenConnectionCommand cmd = new OpenConnectionCommand(this._alias, this._user, this._password, this._props);
            cmd.executeConnectAndWaitForResultInBackground(t -> this.afterExecuteFinished(sqlDriver, cmd, t));
        }
        catch (Throwable ex) {
            this._connectionInternalFrame.finishedCreatingConnection(false);
            this._callback.errorOccurred(ex, this._connectWasCanceled);
        }
    }

    private void afterExecuteFinished(ISQLDriver sqlDriver, OpenConnectionCommand cmd, Throwable t) {
        try {
            if (null != t) {
                if (this._connectWasCanceled) {
                    String aliasName = "<failedToReadAliasName>";
                    try {
                        aliasName = this._alias.getName();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    s_log.warn("Connecting to Alias \"" + aliasName + "\" failed after it was already canceled", t);
                    return;
                }
                throw t;
            }
            if (this._alias.isAutoLogon()) {
                this._alias.setUserName(this._user);
                AliasPasswordHandler.setPassword(this._alias, this._password);
            }
            SQLConnection conn = cmd.getSQLConnection();
            if (this._connectWasCanceled) {
                this.closeCanceledConnection(conn);
            } else {
                this._callback.connected(conn);
                if (this._createSession) {
                    this.createSession(sqlDriver, conn);
                } else {
                    this._connectionInternalFrame.finishedCreatingConnection(true);
                }
            }
        }
        catch (Throwable th) {
            this._connectionInternalFrame.finishedCreatingConnection(false);
            this._callback.errorOccurred(th, this._connectWasCanceled);
        }
    }

    private void closeCanceledConnection(ISQLConnection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (Exception ex) {
                s_log.warn("Error occurred closing already canceled connection", ex);
            }
        }
    }

    private ISession createSession(ISQLDriver sqlDriver, SQLConnection conn) {
        SessionManager sm = this._app.getSessionManager();
        ISession session = sm.createSession(this._app, sqlDriver, this._alias, conn, this._user, this._password);
        this._callback.sessionCreated(session);
        SwingUtilities.invokeLater(() -> this.createSessionFrame(session));
        return session;
    }

    private void createSessionFrame(ISession session) {
        try {
            Main.getApplication().getPluginManager().sessionCreated(session);
            SessionInternalFrame sessionInternalFrame = Main.getApplication().getWindowManager().createInternalFrame(session);
            this._connectionInternalFrame.finishedCreatingConnection(true);
            this._callback.sessionInternalFrameCreated(sessionInternalFrame);
        }
        catch (Throwable th) {
            Main.getApplication().showErrorDialog(s_stringMgr.getString("ConnectionInternalFrameHandler.error.opensession"), th);
        }
    }
}

