/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.DriverMaintenanceType;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.preferences.PreferenceType;
import net.sourceforge.squirrel_sql.fw.gui.DefaultFileListBoxModel;
import net.sourceforge.squirrel_sql.fw.gui.FileListBox;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.IFileListBoxModel;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverClassLoader;
import net.sourceforge.squirrel_sql.fw.util.FileExtensionFilter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DriverInternalFrame
extends DialogWidget {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DriverInternalFrame.class);
    private static final ILogger s_log = LoggerController.createLogger(DriverInternalFrame.class);
    public static final String PREF_KEY_LAST_DRIVER_DIR = "DriverInternalFrame.PREF_KEY_LAST_DRIVER_DIR";
    private static final int COLUMN_COUNT = 25;
    private static final int LIST_WIDTH = 400;
    private final IApplication _app;
    private final ISQLDriver _sqlDriver;
    private final DriverMaintenanceType _maintType;
    private final JLabel _titleLbl = new JLabel();
    private final JTextField _driverName = new JTextField();
    private final JComboBox _driverClassCmb = new JComboBox();
    private final JTextField _url = new JTextField();
    private final JTextField _weburl = new JTextField();
    private final FileListBox _javaClassPathList = new FileListBox();
    private final FileListBox _extraClassPathList = new FileListBox(new DefaultFileListBoxModel());
    private ListDriversButton _javaClasspathListDriversBtn;
    private ListDriversButton _extraClasspathListDriversBtn;
    private JButton _extraClasspathDeleteBtn;
    private JButton _extraClasspathUpBtn;
    private JButton _extraClasspathDownBtn;

    DriverInternalFrame(IApplication app, ISQLDriver sqlDriver, DriverMaintenanceType maintType) {
        super("", true);
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        if (sqlDriver == null) {
            throw new IllegalArgumentException("Null ISQLDriver passed");
        }
        this._app = app;
        this._sqlDriver = sqlDriver;
        this._maintType = maintType;
        this.createGUI();
        this.loadData();
        this.pack();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this._titleLbl.setText(title);
    }

    ISQLDriver getSQLDriver() {
        return this._sqlDriver;
    }

    private void loadData() {
        this._driverName.setText(this._sqlDriver.getName());
        this._driverClassCmb.setSelectedItem(this._sqlDriver.getDriverClassName());
        this._url.setText(this._sqlDriver.getUrl());
        this._weburl.setText(this._sqlDriver.getWebSiteUrl());
        this._extraClassPathList.removeAll();
        String[] fileNames = this._sqlDriver.getJarFileNames();
        IFileListBoxModel model = this._extraClassPathList.getTypedModel();
        for (int i = 0; i < fileNames.length; ++i) {
            model.addFile(new File(fileNames[i]));
        }
        if (model.getSize() > 0) {
            this._extraClassPathList.setSelectedIndex(0);
        }
    }

    private void performClose() {
        this.dispose();
    }

    private void performOk() {
        try {
            this.applyFromDialog();
            if (this._maintType == DriverMaintenanceType.NEW || this._maintType == DriverMaintenanceType.COPY) {
                this._app.getAliasesAndDriversManager().addDriver(this._sqlDriver, this._app.getMessageHandler());
            } else {
                this._app.getAliasesAndDriversManager().refreshDriver(this._sqlDriver, this._app.getMessageHandler());
            }
            this._app.savePreferences(PreferenceType.DRIVER_DEFINITIONS);
            this.dispose();
        }
        catch (Throwable th) {
            this.displayErrorMessage(th);
        }
    }

    private void applyFromDialog() throws ValidationException {
        this._sqlDriver.setName(this._driverName.getText().trim());
        this._sqlDriver.setJarFileNames(this._extraClassPathList.getTypedModel().getFileNames());
        String driverClassName = (String)this._driverClassCmb.getSelectedItem();
        this._sqlDriver.setDriverClassName(driverClassName != null ? driverClassName.trim() : null);
        this._sqlDriver.setUrl(this._url.getText().trim());
        this._sqlDriver.setWebSiteUrl(this._weburl.getText().trim());
    }

    private void displayErrorMessage(final Throwable th) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DriverInternalFrame.this._app.showErrorDialog(th);
            }
        });
    }

    private void createGUI() {
        this.setDefaultCloseOperation(2);
        this.makeToolWindow(true);
        String winTitle = this._maintType == DriverMaintenanceType.MODIFY ? s_stringMgr.getString("DriverInternalFrame.changedriver", this._sqlDriver.getName()) : s_stringMgr.getString("DriverInternalFrame.adddriver");
        this.setTitle(winTitle);
        this._driverName.setColumns(25);
        this._url.setColumns(25);
        Container contentPane = this.getContentPane();
        Color color = UIManager.getDefaults().getColor("Panel.background");
        if (color != null) {
            contentPane.setBackground(color);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        contentPane.setLayout(new GridBagLayout());
        gbc.anchor = 18;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 10, 5, 10);
        gbc.fill = 2;
        contentPane.add((Component)this._titleLbl, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 10, 5, 10);
        contentPane.add((Component)new JSeparator(), gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.createDriverPanel(), gbc);
        JTabbedPane tabPnl = new JTabbedPane();
        tabPnl.addTab(s_stringMgr.getString("DriverInternalFrame.jdbc.driver.classpath"), this.createJDBCDriverClasspathPanel());
        tabPnl.addTab(s_stringMgr.getString("DriverInternalFrame.squirrel.java.classpath"), this.createJavaClassPathPanel());
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        contentPane.add((Component)tabPnl, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        contentPane.add(this.createDriverClassPanel(), gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 10, 5, 10);
        contentPane.add((Component)new JSeparator(), gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.createButtonsPanel(), gbc);
        GUIUtils.enableCloseByEscape(this);
    }

    private JPanel createButtonsPanel() {
        JPanel pnl = new JPanel();
        JButton okBtn = new JButton(s_stringMgr.getString("DriverInternalFrame.ok"));
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverInternalFrame.this.performOk();
            }
        });
        JButton closeBtn = new JButton(s_stringMgr.getString("DriverInternalFrame.close"));
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverInternalFrame.this.performClose();
            }
        });
        pnl.add(okBtn);
        pnl.add(closeBtn);
        GUIUtils.setJButtonSizesTheSame(okBtn, closeBtn);
        this.getRootPane().setDefaultButton(okBtn);
        return pnl;
    }

    private JPanel createDriverPanel() {
        this._driverName.setColumns(25);
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("DriverInternalFrame.driver")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        pnl.add((Component)new JLabel(s_stringMgr.getString("DriverInternalFrame.name"), 4), gbc);
        ++gbc.gridy;
        pnl.add((Component)new JLabel(s_stringMgr.getString("DriverInternalFrame.example.jdbc.url"), 4), gbc);
        ++gbc.gridy;
        pnl.add((Component)new JLabel(s_stringMgr.getString("DriverInternalFrame.weburl"), 4), gbc);
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        ++gbc.gridx;
        pnl.add((Component)this._driverName, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._url, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._weburl, gbc);
        return pnl;
    }

    private Component createDriverClassPanel() {
        this._driverClassCmb.setEditable(true);
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        pnl.add((Component)new JLabel(s_stringMgr.getString("DriverInternalFrame.classname"), 4), gbc);
        gbc.weightx = 1.0;
        ++gbc.gridx;
        pnl.add((Component)this._driverClassCmb, gbc);
        return pnl;
    }

    private JPanel createJavaClassPathPanel() {
        this._javaClasspathListDriversBtn = new ListDriversButton(this._javaClassPathList);
        this._javaClasspathListDriversBtn.setEnabled(this._javaClassPathList.getModel().getSize() > 0);
        IFileListBoxModel model = this._javaClassPathList.getTypedModel();
        if (model.getSize() > 0) {
            this._javaClassPathList.setSelectedIndex(0);
        }
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.anchor = 17;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        JScrollPane sp = new JScrollPane(this._javaClassPathList, 22, 32);
        Dimension dm = sp.getPreferredSize();
        dm.width = 400;
        sp.setPreferredSize(dm);
        pnl.add((Component)sp, gbc);
        ++gbc.gridx;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.weightx = 0.0;
        pnl.add((Component)this._javaClasspathListDriversBtn, gbc);
        return pnl;
    }

    private JPanel createJDBCDriverClasspathPanel() {
        this._extraClasspathListDriversBtn = new ListDriversButton(this._extraClassPathList);
        this._extraClassPathList.addListSelectionListener(new ExtraClassPathListBoxListener());
        this._extraClassPathList.getModel().addListDataListener(new ExtraClassPathListDataListener());
        this._extraClasspathUpBtn = new JButton(s_stringMgr.getString("DriverInternalFrame.up"));
        this._extraClasspathUpBtn.setEnabled(false);
        this._extraClasspathUpBtn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent evt) {
                FileListBox fileListBox = DriverInternalFrame.this._extraClassPathList;
                synchronized (fileListBox) {
                    int idx = DriverInternalFrame.this._extraClassPathList.getSelectedIndex();
                    if (idx > 0) {
                        IFileListBoxModel model = DriverInternalFrame.this._extraClassPathList.getTypedModel();
                        File file = model.removeFile(idx);
                        model.insertFileAt(file, --idx);
                        DriverInternalFrame.this._extraClassPathList.setSelectedIndex(idx);
                    }
                }
            }
        });
        this._extraClasspathDownBtn = new JButton(s_stringMgr.getString("DriverInternalFrame.down"));
        this._extraClasspathDownBtn.setEnabled(false);
        this._extraClasspathDownBtn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent evt) {
                FileListBox fileListBox = DriverInternalFrame.this._extraClassPathList;
                synchronized (fileListBox) {
                    int idx = DriverInternalFrame.this._extraClassPathList.getSelectedIndex();
                    IFileListBoxModel model = DriverInternalFrame.this._extraClassPathList.getTypedModel();
                    if (idx > -1 && idx < model.getSize() - 1) {
                        File file = model.removeFile(idx);
                        model.insertFileAt(file, ++idx);
                        DriverInternalFrame.this._extraClassPathList.setSelectedIndex(idx);
                    }
                }
            }
        });
        AddListEntryButton newBtn = new AddListEntryButton();
        this._extraClasspathDeleteBtn = new JButton(s_stringMgr.getString("DriverInternalFrame.delete"));
        this._extraClasspathDeleteBtn.setEnabled(false);
        this._extraClasspathDeleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int idx = DriverInternalFrame.this._extraClassPathList.getSelectedIndex();
                if (idx != -1) {
                    IFileListBoxModel model = DriverInternalFrame.this._extraClassPathList.getTypedModel();
                    model.removeFile(idx);
                    int size = model.getSize();
                    if (idx < size) {
                        DriverInternalFrame.this._extraClassPathList.setSelectedIndex(idx);
                    } else if (size > 0) {
                        DriverInternalFrame.this._extraClassPathList.setSelectedIndex(size - 1);
                    }
                }
            }
        });
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        pnl.add((Component)new MultipleLineLabel(s_stringMgr.getString("DriverInternalFrame.jdbc.driver.classpath.description")), gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 5, 0), 0, 0);
        JScrollPane sp = new JScrollPane(this._extraClassPathList, 22, 32);
        GUIUtils.setPreferredWidth(sp, 400);
        pnl.add((Component)sp, gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0);
        pnl.add((Component)this.createJDBCDiverClassPathButtonPanel(newBtn), gbc);
        return pnl;
    }

    private JPanel createJDBCDiverClassPathButtonPanel(JButton newBtn) {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0);
        pnl.add((Component)newBtn, gbc);
        gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0);
        pnl.add((Component)new JSeparator(), gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0);
        pnl.add((Component)this._extraClasspathListDriversBtn, gbc);
        gbc = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0);
        pnl.add((Component)new JSeparator(), gbc);
        gbc = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0);
        pnl.add((Component)this._extraClasspathUpBtn, gbc);
        gbc = new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0);
        pnl.add((Component)this._extraClasspathDownBtn, gbc);
        gbc = new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0);
        pnl.add((Component)new JSeparator(), gbc);
        gbc = new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0);
        pnl.add((Component)this._extraClasspathDeleteBtn, gbc);
        return pnl;
    }

    private void addDriverClassToCombo(final String driverClassName) {
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                DriverInternalFrame.this._driverClassCmb.addItem(driverClassName);
            }
        });
    }

    private class ExtraClassPathListBoxListener
    implements ListSelectionListener {
        private ExtraClassPathListBoxListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            int selIdx = DriverInternalFrame.this._extraClassPathList.getSelectedIndex();
            ListModel model = DriverInternalFrame.this._extraClassPathList.getModel();
            DriverInternalFrame.this._extraClasspathDeleteBtn.setEnabled(selIdx != -1);
            DriverInternalFrame.this._extraClasspathUpBtn.setEnabled(selIdx > 0 && model.getSize() > 1);
            DriverInternalFrame.this._extraClasspathDownBtn.setEnabled(selIdx > -1 && selIdx < model.getSize() - 1);
        }
    }

    private class ExtraClassPathListDataListener
    implements ListDataListener {
        private ExtraClassPathListDataListener() {
        }

        @Override
        public void contentsChanged(ListDataEvent evt) {
            boolean enable = DriverInternalFrame.this._extraClassPathList.getModel().getSize() > 0;
            DriverInternalFrame.this._extraClasspathListDriversBtn.setEnabled(enable);
        }

        @Override
        public void intervalAdded(ListDataEvent evt) {
            boolean enable = DriverInternalFrame.this._extraClassPathList.getModel().getSize() > 0;
            DriverInternalFrame.this._extraClasspathListDriversBtn.setEnabled(enable);
        }

        @Override
        public void intervalRemoved(ListDataEvent evt) {
            boolean enable = DriverInternalFrame.this._extraClassPathList.getModel().getSize() > 0;
            DriverInternalFrame.this._extraClasspathListDriversBtn.setEnabled(enable);
        }
    }

    private final class ListDriversButton
    extends JButton
    implements ActionListener {
        private FileListBox _listBox;

        ListDriversButton(FileListBox listBox) {
            super(s_stringMgr.getString("DriverInternalFrame.listdrivers"));
            this.setEnabled(false);
            this._listBox = listBox;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DriverInternalFrame.this._driverClassCmb.removeAllItems();
            final String[] fileNames = this._listBox.getTypedModel().getFileNames();
            if (fileNames.length > 0) {
                DriverInternalFrame.this._app.getThreadPool().addTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            URL[] urls = new URL[fileNames.length];
                            for (int i = 0; i < fileNames.length; ++i) {
                                urls[i] = new File(fileNames[i]).toURI().toURL();
                            }
                            SQLDriverClassLoader cl = new SQLDriverClassLoader(urls);
                            Class<?>[] classes = cl.getDriverClasses(s_log);
                            for (int i = 0; i < classes.length; ++i) {
                                DriverInternalFrame.this.addDriverClassToCombo(classes[i].getName());
                            }
                        }
                        catch (MalformedURLException ex) {
                            DriverInternalFrame.this.displayErrorMessage(ex);
                        }
                    }
                });
            }
            if (DriverInternalFrame.this._driverClassCmb.getItemCount() > 0) {
                DriverInternalFrame.this._driverClassCmb.setSelectedIndex(0);
            }
        }
    }

    private final class AddListEntryButton
    extends JButton
    implements ActionListener {
        private JFileChooser _chooser;

        AddListEntryButton() {
            super(s_stringMgr.getString("DriverInternalFrame.add"));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            File[] selFiles;
            if (this._chooser == null) {
                this._chooser = new JFileChooser();
                this._chooser.setFileHidingEnabled(false);
                this._chooser.setMultiSelectionEnabled(true);
                this._chooser.setFileSelectionMode(2);
                this._chooser.addChoosableFileFilter(new FileExtensionFilter(s_stringMgr.getString("DriverInternalFrame.jarfiles"), new String[]{".jar", ".zip"}));
            }
            String lastDirString = Props.getString(DriverInternalFrame.PREF_KEY_LAST_DRIVER_DIR, System.getProperty("user.home"));
            File lastDir = new File(lastDirString);
            this._chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
            if (lastDir.exists() && lastDir.isDirectory()) {
                this._chooser.setCurrentDirectory(lastDir);
            } else if (lastDir.exists() && lastDir.isFile() && null != lastDir.getParentFile()) {
                this._chooser.setCurrentDirectory(lastDir.getParentFile());
            }
            int returnVal = this._chooser.showOpenDialog(this.getParent());
            if (returnVal == 0 && (selFiles = this._chooser.getSelectedFiles()) != null) {
                if (0 < selFiles.length) {
                    Props.putString(DriverInternalFrame.PREF_KEY_LAST_DRIVER_DIR, selFiles[0].getParentFile().getPath());
                }
                IFileListBoxModel myModel = DriverInternalFrame.this._extraClassPathList.getTypedModel();
                for (int i = 0; i < selFiles.length; ++i) {
                    myModel.addFile(selFiles[i]);
                }
                DriverInternalFrame.this._extraClassPathList.setSelectedIndex(myModel.getSize() - 1);
            }
        }
    }
}

