/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.db.DriversList;
import net.sourceforge.squirrel_sql.client.gui.db.DriversListInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.IUserInterfaceFactory;
import net.sourceforge.squirrel_sql.client.mainframe.action.CopyDriverAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CreateDriverAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.DeleteDriverAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.InstallDefaultDriversAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ModifyDriverAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ModifyDriverCommand;
import net.sourceforge.squirrel_sql.client.mainframe.action.ShowDriverWebsiteAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ShowLoadedDriversOnlyAction;
import net.sourceforge.squirrel_sql.fw.gui.BasePopupMenu;
import net.sourceforge.squirrel_sql.fw.gui.ToolBar;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

final class DriverUserInterfaceFactory
implements IUserInterfaceFactory<DriversList> {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DriverUserInterfaceFactory.class);
    private IApplication _app;
    private DriversList _driversList;
    private ToolBar _tb;
    private BasePopupMenu _pm = new BasePopupMenu();
    private DriversListInternalFrame _tw;

    DriverUserInterfaceFactory(DriversList list) {
        if (list == null) {
            throw new IllegalArgumentException("DriversList == null");
        }
        this._app = Main.getApplication();
        this._driversList = list;
        ActionCollection actions = this._app.getActionCollection();
        this.addToPopup(actions.get(CreateDriverAction.class), this._pm);
        this._pm.addSeparator();
        this.addToPopup(actions.get(ModifyDriverAction.class), this._pm);
        this.addToPopup(actions.get(CopyDriverAction.class), this._pm);
        this.addToPopup(actions.get(ShowDriverWebsiteAction.class), this._pm);
        this._pm.addSeparator();
        this.addToPopup(actions.get(DeleteDriverAction.class), this._pm);
        this._pm.addSeparator();
    }

    private void addToPopup(Action action, BasePopupMenu popup) {
        this._app.getResources().configureMenuItem(action, popup.add(action));
    }

    @Override
    public void execDoubleClickCommand(MouseEvent evt) {
        ISQLDriver driver = this._driversList.getSelectedDriver();
        if (driver != null) {
            new ModifyDriverCommand(this._app, driver).execute();
        }
    }

    void setDriversListInternalFrame(DriversListInternalFrame tw) {
        this._tw = tw;
        this.propertiesChanged(null);
    }

    public void propertiesChanged(String propName) {
        if (propName == null || propName.equals("showDriversToolBar")) {
            boolean show = this._app.getSquirrelPreferences().getShowDriversToolBar();
            if (show) {
                this.createToolBar();
            } else {
                this._tb = null;
            }
            this._tw.setToolBar(this.getToolBar());
        }
    }

    private void createToolBar() {
        this._tb = new ToolBar();
        this._tb.setUseRolloverButtons(true);
        this._tb.setFloatable(false);
        if (this._app.getDesktopStyle().isInternalFrameStyle()) {
            JLabel lbl = new JLabel(this.getWindowTitle(), 0);
            lbl.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this._tb.add((Component)lbl, 0);
        }
        ActionCollection actions = this._app.getActionCollection();
        this._tb.add(actions.get(CreateDriverAction.class));
        this._tb.add(actions.get(ModifyDriverAction.class));
        this._tb.add(actions.get(CopyDriverAction.class));
        this._tb.add(actions.get(ShowDriverWebsiteAction.class));
        this._tb.add(actions.get(DeleteDriverAction.class));
        this._tb.addSeparator();
        this._tb.add(actions.get(InstallDefaultDriversAction.class));
        this._tb.addSeparator();
        Action act = actions.get(ShowLoadedDriversOnlyAction.class);
        JToggleButton btn = new JToggleButton(act);
        boolean show = this._app.getSquirrelPreferences().getShowLoadedDriversOnly();
        btn.setSelected(show);
        btn.setText(null);
        this._tb.add(btn);
        Main.getApplication().getSquirrelPreferences().addPropertyChangeListener(evt -> this.onPreferencesChanged(evt, btn));
    }

    private void onPreferencesChanged(PropertyChangeEvent evt, JToggleButton btnShowLoadedDriversOnlyToggle) {
        String propName;
        String string = propName = evt != null ? evt.getPropertyName() : null;
        if (propName == null || propName.equals("showLoadedDriversOnly")) {
            boolean show = this._app.getSquirrelPreferences().getShowLoadedDriversOnly();
            btnShowLoadedDriversOnlyToggle.setSelected(show);
        }
    }

    @Override
    public ToolBar getToolBar() {
        return this._tb;
    }

    @Override
    public BasePopupMenu getPopupMenu() {
        return this._pm;
    }

    @Override
    public DriversList getList() {
        return this._driversList;
    }

    @Override
    public String getWindowTitle() {
        return s_stringMgr.getString("DriversListInternalFrame.windowtitle");
    }

    public DriversList getDriversList() {
        return this._driversList;
    }
}

