/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesAndDriversManager;
import net.sourceforge.squirrel_sql.client.gui.db.DriverInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.DriverMaintenanceType;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.util.IdentifierFactory;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifierFactory;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

class DriverWindowFactory {
    private static ILogger s_log = LoggerController.createLogger(DriverWindowFactory.class);
    private IApplication _app;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DriverWindowFactory.class);
    private final Map<IIdentifier, DriverInternalFrame> _modifySheets = new HashMap<IIdentifier, DriverInternalFrame>();

    public DriverWindowFactory(IApplication app) {
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        this._app = app;
    }

    public synchronized DriverInternalFrame getModifySheet(ISQLDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("ISQLDriver == null");
        }
        DriverInternalFrame sheet = this.get(driver);
        if (sheet == null) {
            sheet = new DriverInternalFrame(this._app, driver, DriverMaintenanceType.MODIFY);
            this._modifySheets.put(driver.getIdentifier(), sheet);
            this._app.getMainFrame().addWidget(sheet);
            sheet.addWidgetListener(new WidgetAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void widgetClosed(WidgetEvent evt) {
                    DriverWindowFactory driverWindowFactory = DriverWindowFactory.this;
                    synchronized (driverWindowFactory) {
                        DriverInternalFrame frame = (DriverInternalFrame)evt.getWidget();
                        DriverWindowFactory.this._modifySheets.remove(frame.getSQLDriver().getIdentifier());
                    }
                }
            });
            DialogWidget.centerWithinDesktop(sheet);
        }
        return sheet;
    }

    public DriverInternalFrame getCreateSheet() {
        AliasesAndDriversManager cache = this._app.getAliasesAndDriversManager();
        IIdentifierFactory factory = IdentifierFactory.getInstance();
        ISQLDriver driver = cache.createDriver(factory.createIdentifier());
        DriverInternalFrame sheet = new DriverInternalFrame(this._app, driver, DriverMaintenanceType.NEW);
        this._app.getMainFrame().addWidget(sheet);
        DialogWidget.centerWithinDesktop(sheet);
        return sheet;
    }

    public DriverInternalFrame showCopySheet(ISQLDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("ISQLDriver == null");
        }
        AliasesAndDriversManager cache = this._app.getAliasesAndDriversManager();
        IIdentifierFactory factory = IdentifierFactory.getInstance();
        ISQLDriver newDriver = cache.createDriver(factory.createIdentifier());
        try {
            newDriver.assignFrom(driver);
        }
        catch (ValidationException ex) {
            s_log.error(s_stringMgr.getString("DriverWindowFactory.error.copyingdriver"), ex);
        }
        DriverInternalFrame sheet = new DriverInternalFrame(this._app, newDriver, DriverMaintenanceType.COPY);
        this._app.getMainFrame().addWidget(sheet);
        DialogWidget.centerWithinDesktop(sheet);
        return sheet;
    }

    private DriverInternalFrame get(ISQLDriver driver) {
        return this._modifySheets.get(driver.getIdentifier());
    }
}

