/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.BaseListInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.DriverUserInterfaceFactory;
import net.sourceforge.squirrel_sql.client.gui.db.DriversList;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriver;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DriversListInternalFrame
extends BaseListInternalFrame<DriversList> {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DriversListInternalFrame.class);
    private IApplication _app = Main.getApplication();
    private DriverUserInterfaceFactory _uiFactory = (DriverUserInterfaceFactory)this.getUserInterfaceFactory();

    public DriversListInternalFrame(DriversList list) {
        super(new DriverUserInterfaceFactory(list));
        this._uiFactory.setDriversListInternalFrame(this);
        this.addVetoableChangeListener(new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if ("closed".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
                    throw new PropertyVetoException(s_stringMgr.getString("DriversListInternalFrame.error.ctrlF4key"), evt);
                }
            }
        });
        this.addWidgetListener(new WidgetAdapter(){

            @Override
            public void widgetOpened(WidgetEvent evt) {
                DriversListInternalFrame.this.nowVisible(true);
            }

            @Override
            public boolean widgetClosing(WidgetEvent evt) {
                DriversListInternalFrame.this.nowVisible(false);
                return true;
            }

            @Override
            public void widgetClosed(WidgetEvent evt) {
                DriversListInternalFrame.this.nowVisible(false);
            }
        });
        this._app.getSquirrelPreferences().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt != null ? evt.getPropertyName() : null;
                DriversListInternalFrame.this._uiFactory.propertiesChanged(propName);
            }
        });
    }

    public void nowVisible(final boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DriversListInternalFrame.this._app.getMainFrame().setEnabledDriversMenu(b);
                DriversListInternalFrame.this._uiFactory.getDriversList().requestFocus();
            }
        });
    }

    public void updateDriverList(List<SQLDriver> driverList) {
        DriversList list = (DriversList)this.getUserInterfaceFactory().getList();
        list.getTypedModel().replaceAllAndSort(driverList);
    }
}

