/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.util.Iterator;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.gui.SortedListModel;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriver;
import net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener;
import net.sourceforge.squirrel_sql.fw.util.ObjectCacheChangeEvent;

class DriversListModel
extends SortedListModel<SQLDriver> {
    private boolean _showLoadedDriversOnly;

    public DriversListModel() {
        this.load();
        Main.getApplication().getAliasesAndDriversManager().addDriversListener(new MyDriversListener());
    }

    public void setShowLoadedDriversOnly(boolean show) {
        if (show != this._showLoadedDriversOnly) {
            this._showLoadedDriversOnly = show;
            this.load();
        }
    }

    private void load() {
        this.clear();
        Iterator<SQLDriver> it = Main.getApplication().getAliasesAndDriversManager().drivers();
        while (it.hasNext()) {
            this.addDriver(it.next());
        }
    }

    private void addDriver(SQLDriver driver) {
        if (!this._showLoadedDriversOnly || driver.isJDBCDriverClassLoaded()) {
            this.addElement(driver);
        }
    }

    private void removeDriver(ISQLDriver driver) {
        this.removeElement(driver);
    }

    private class MyDriversListener
    implements IObjectCacheChangeListener {
        private MyDriversListener() {
        }

        @Override
        public void objectAdded(ObjectCacheChangeEvent evt) {
            IHasIdentifier obj = evt.getObject();
            if (obj instanceof SQLDriver) {
                DriversListModel.this.addDriver((SQLDriver)obj);
            }
        }

        @Override
        public void objectRemoved(ObjectCacheChangeEvent evt) {
            IHasIdentifier obj = evt.getObject();
            if (obj instanceof ISQLDriver) {
                DriversListModel.this.removeDriver((ISQLDriver)obj);
            }
        }
    }
}

