/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.awt.BorderLayout;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.AliasFolder;
import net.sourceforge.squirrel_sql.client.gui.db.AliasListCellRenderer;
import net.sourceforge.squirrel_sql.client.gui.db.AliasListSelectionListener;
import net.sourceforge.squirrel_sql.client.gui.db.AliasWindowManager;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesList;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesListModel;
import net.sourceforge.squirrel_sql.client.gui.db.BaseList;
import net.sourceforge.squirrel_sql.client.gui.db.IAliasesList;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.aliascolor.ListAliasColorSelectionHandler;
import net.sourceforge.squirrel_sql.fw.gui.Dialogs;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class JListAliasesListImpl
extends BaseList
implements IAliasesList {
    private static final String PREF_KEY_SELECTED_ALIAS_INDEX = "Squirrel.selAliasIndex";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasesList.class);
    private final AliasesListModel _model;

    public JListAliasesListImpl(IApplication app, AliasesListModel aliasesListModel, AliasListSelectionListener selectionListener) {
        super(aliasesListModel, app);
        this._model = aliasesListModel;
        this.getList().setLayout(new BorderLayout());
        this.getList().setCellRenderer(new AliasListCellRenderer());
        this._model.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent evt) {
            }

            @Override
            public void intervalAdded(ListDataEvent evt) {
                JListAliasesListImpl.this.onIntervalAdded(evt);
            }

            @Override
            public void intervalRemoved(ListDataEvent evt) {
                JListAliasesListImpl.this.onIntervalRemoved(evt);
            }
        });
        if (selectionListener != null) {
            this.getList().addListSelectionListener(evt -> selectionListener.selectionChanged(this.getLeadSelectionValue()));
        }
    }

    @Override
    public SQLAlias getLeadSelectionValue() {
        JList list = this.getList();
        int selectedIndex = list.getLeadSelectionIndex();
        Object selectedValue = null;
        if (selectedIndex >= 0 && selectedIndex < list.getModel().getSize()) {
            selectedValue = list.getModel().getElementAt(selectedIndex);
        }
        return selectedValue instanceof SQLAlias ? (SQLAlias)selectedValue : null;
    }

    private void onIntervalRemoved(ListDataEvent evt) {
        final int idx = evt.getIndex0();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JListAliasesListImpl.this.getList().clearSelection();
                int modelSize = JListAliasesListImpl.this.getList().getModel().getSize();
                if (idx < modelSize) {
                    JListAliasesListImpl.this.getList().setSelectedIndex(idx);
                } else if (modelSize > 0) {
                    JListAliasesListImpl.this.getList().setSelectedIndex(modelSize - 1);
                }
            }
        });
    }

    private void onIntervalAdded(ListDataEvent evt) {
        final int idx = evt.getIndex0();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JListAliasesListImpl.this.getList().clearSelection();
                JListAliasesListImpl.this.getList().setSelectedIndex(idx);
            }
        });
    }

    @Override
    public SQLAlias getSelectedAlias(MouseEvent evt) {
        return (SQLAlias)this.getList().getSelectedValue();
    }

    @Override
    public void sortAliases() {
        final SQLAlias selectedAlias = this.getSelectedAlias(null);
        this._model.sortAliasesForListImpl();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (null != selectedAlias) {
                    JListAliasesListImpl.this.getList().setSelectedValue(selectedAlias, true);
                }
            }
        });
    }

    @Override
    public void requestFocus() {
        this.getList().requestFocus();
    }

    @Override
    public void deleteSelected() {
        SQLAlias toDel = (SQLAlias)this.getList().getSelectedValue();
        if (null != toDel && Dialogs.showYesNo(Main.getApplication().getMainFrame(), s_stringMgr.getString("JListAliasesListImpl.confirmDelete", toDel.getName()))) {
            this._model.remove(this.getList().getSelectedIndex());
            Main.getApplication().getAliasesAndDriversManager().removeAlias(toDel);
        }
    }

    @Override
    public void colorSelected() {
        ListAliasColorSelectionHandler.selectColor(this.getList());
    }

    @Override
    public void modifySelected() {
        if (null != this.getList().getSelectedValue()) {
            AliasWindowManager.showModifyAliasInternalFrame((SQLAlias)this.getList().getSelectedValue());
        }
    }

    @Override
    public boolean isEmpty() {
        return 0 == this._model.getSize();
    }

    @Override
    public void goToAlias(SQLAlias aliasToGoTo) {
        SQLAlias alias = this._model.getAlias(aliasToGoTo.getIdentifier());
        this.getList().setSelectedValue(alias, true);
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        int idx = this.getList().locationToIndex(evt.getPoint());
        String tip = idx != -1 ? ((SQLAlias)this.getList().getModel().getElementAt(idx)).getName() : this.getToolTipText();
        return tip;
    }

    public String getToolTipText() {
        return s_stringMgr.getString("AliasesList.tooltip");
    }

    @Override
    public String getSelIndexPrefKey() {
        return PREF_KEY_SELECTED_ALIAS_INDEX;
    }

    @Override
    public void aliasChanged(SQLAlias sqlAlias) {
    }

    @Override
    public void goToAliasFolder(AliasFolder alias) {
    }
}

