/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db;

import java.io.Serializable;
import net.sourceforge.squirrel_sql.client.gui.db.Java8CloseableFix;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAliasColorProperties;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAliasConnectionProperties;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAliasProp;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAliasSchemaProperties;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAliasVersioner;
import net.sourceforge.squirrel_sql.client.gui.db.modifyaliases.SQLAliasPropType;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.persist.IValidatable;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverProperty;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class SQLAlias
implements Serializable,
Comparable<SQLAlias>,
IHasIdentifier,
IValidatable {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SQLAlias.class);
    private IIdentifier _id;
    private String _name;
    private IIdentifier _driverId;
    private String _url;
    private String _userName;
    private String _password;
    private boolean _encryptPassword;
    private boolean _autoLogon;
    private boolean _connectAtStartup;
    private boolean _useDriverProperties = false;
    private SQLDriverPropertyCollection _driverProps = new SQLDriverPropertyCollection();
    private SQLAliasSchemaProperties _schemaProperties = new SQLAliasSchemaProperties();
    private SQLAliasColorProperties _colorProperties = new SQLAliasColorProperties();
    private SQLAliasConnectionProperties _connectionProperties = new SQLAliasConnectionProperties();
    private SQLAliasVersioner _versioner = new SQLAliasVersioner(this);
    private long _aliasVersionTimeMills = 0L;

    public SQLAlias() {
        this.distributeVersioner();
    }

    public SQLAlias(IIdentifier id) {
        this();
        this._id = id;
        this._name = "";
        this._driverId = null;
        this._url = "";
        this._userName = "";
        this._password = "";
    }

    private void distributeVersioner() {
        this._schemaProperties.acceptAliasVersioner(this._versioner);
        this._colorProperties.acceptAliasVersioner(this._versioner);
        this._connectionProperties.acceptAliasVersioner(this._versioner);
    }

    public void assignFrom(SQLAlias sqlAlias, boolean withIdentifier) {
        try {
            this.assignFromWithValidationException(sqlAlias, withIdentifier);
        }
        catch (ValidationException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    public void assignFromWithValidationException(SQLAlias sqlAlias, boolean withIdentifier) throws ValidationException {
        try (Java8CloseableFix java8Dum = this._versioner.switchOff();){
            if (withIdentifier) {
                this.setIdentifier(sqlAlias.getIdentifier());
            }
            this.setName(sqlAlias.getName());
            this.setDriverIdentifier(sqlAlias.getDriverIdentifier());
            this.setUrl(sqlAlias.getUrl());
            this.setUserName(sqlAlias.getUserName());
            this.setEncryptPassword(sqlAlias.isEncryptPassword());
            this.setPassword(sqlAlias.getPassword());
            this.setAutoLogon(sqlAlias.isAutoLogon());
            this.setUseDriverProperties(sqlAlias.getUseDriverProperties());
            this.setDriverProperties(sqlAlias.getDriverPropertiesClone());
            this.setAliasVersionTimeMills(sqlAlias.getAliasVersionTimeMills());
            this._schemaProperties = Utilities.cloneObject(sqlAlias._schemaProperties, this.getClass().getClassLoader());
            this._schemaProperties.acceptAliasVersioner(this._versioner);
            this._colorProperties = Utilities.cloneObject(sqlAlias._colorProperties, this.getClass().getClassLoader());
            this._colorProperties.acceptAliasVersioner(this._versioner);
            this._connectionProperties = new SQLAliasConnectionProperties();
            this._colorProperties.acceptAliasVersioner(this._versioner);
            SQLAliasConnectionProperties rhsConnProps = sqlAlias.getConnectionProperties();
            this._connectionProperties.setEnableConnectionKeepAlive(rhsConnProps.isEnableConnectionKeepAlive());
            this._connectionProperties.setKeepAliveSleepTimeSeconds(rhsConnProps.getKeepAliveSleepTimeSeconds());
            this._connectionProperties.setKeepAliveSqlStatement(rhsConnProps.getKeepAliveSqlStatement());
        }
    }

    public boolean equals(Object rhs) {
        boolean rc = false;
        if (rhs != null && rhs.getClass().equals(this.getClass())) {
            rc = ((SQLAlias)rhs).getIdentifier().equals(this.getIdentifier());
        }
        return rc;
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(SQLAlias rhs) {
        return this._name.compareTo(rhs.getName());
    }

    @Override
    public boolean isValid() {
        return this._name != null && this._name.length() > 0 && this._driverId != null && this._url != null && this._url.length() > 0;
    }

    @Override
    public IIdentifier getIdentifier() {
        return this._id;
    }

    @SQLAliasProp(sqlAliasPropType=SQLAliasPropType.aliasName)
    public String getName() {
        return this._name;
    }

    @SQLAliasProp(sqlAliasPropType=SQLAliasPropType.driverIdentifier)
    public IIdentifier getDriverIdentifier() {
        return this._driverId;
    }

    @SQLAliasProp(sqlAliasPropType=SQLAliasPropType.jdbcUrl)
    public String getUrl() {
        return this._url;
    }

    @SQLAliasProp(sqlAliasPropType=SQLAliasPropType.userName)
    public String getUserName() {
        return this._userName;
    }

    @SQLAliasProp(sqlAliasPropType=SQLAliasPropType.password)
    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        String data = this.getString(password);
        this._versioner.trigger(this._password, data);
        this._password = data;
    }

    @SQLAliasProp(sqlAliasPropType=SQLAliasPropType.encryptPassword)
    public boolean isEncryptPassword() {
        return this._encryptPassword;
    }

    public void setEncryptPassword(boolean b) {
        this._versioner.trigger(this._encryptPassword, b);
        this._encryptPassword = b;
    }

    public long getAliasVersionTimeMills() {
        return this._aliasVersionTimeMills;
    }

    public void setAliasVersionTimeMills(long aliasVersionTimeMills) {
        this._aliasVersionTimeMills = aliasVersionTimeMills;
    }

    @SQLAliasProp(sqlAliasPropType=SQLAliasPropType.autoLogon)
    public boolean isAutoLogon() {
        return this._autoLogon;
    }

    public void setAutoLogon(boolean value) {
        this._versioner.trigger(this._autoLogon, value);
        this._autoLogon = value;
    }

    @SQLAliasProp(sqlAliasPropType=SQLAliasPropType.connectAtStartup)
    public boolean isConnectAtStartup() {
        return this._connectAtStartup;
    }

    public void setConnectAtStartup(boolean value) {
        this._versioner.trigger(this._connectAtStartup, value);
        this._connectAtStartup = value;
    }

    @SQLAliasProp(sqlAliasPropType=SQLAliasPropType.driverProp_useDriverProperties)
    public boolean getUseDriverProperties() {
        return this._useDriverProperties;
    }

    public void setIdentifier(IIdentifier id) {
        this._id = id;
    }

    public void setName(String name) throws ValidationException {
        String data = this.getString(name);
        if (data.length() == 0) {
            throw new ValidationException(IStrings.ERR_BLANK_NAME);
        }
        this._versioner.trigger(this._name, data);
        this._name = data;
    }

    public void setDriverIdentifier(IIdentifier data) throws ValidationException {
        if (data == null) {
            throw new ValidationException(IStrings.ERR_BLANK_DRIVER);
        }
        this._versioner.trigger(this._driverId, data);
        this._driverId = data;
    }

    public void setUrl(String url) throws ValidationException {
        String data = this.getString(url);
        if (data.length() == 0) {
            throw new ValidationException(IStrings.ERR_BLANK_URL);
        }
        this._versioner.trigger(this._url, data);
        this._url = data;
    }

    public void setUserName(String userName) {
        String data = this.getString(userName);
        this._versioner.trigger(this._userName, data);
        this._userName = data;
    }

    public void setUseDriverProperties(boolean value) {
        this._versioner.trigger(this._useDriverProperties, value);
        this._useDriverProperties = value;
    }

    @SQLAliasProp(sqlAliasPropType=SQLAliasPropType.driverProp_driverPropertyCollection)
    public SQLDriverPropertyCollection getDriverPropertiesClone() {
        return this.getDriverPropertiesClone(false);
    }

    public SQLDriverPropertyCollection getDriverPropertiesClone(boolean includeVersioner) {
        int count = this._driverProps.size();
        SQLDriverProperty[] newar = new SQLDriverProperty[count];
        for (int i = 0; i < count; ++i) {
            newar[i] = (SQLDriverProperty)this._driverProps.getDriverProperty(i).clone();
        }
        SQLDriverPropertyCollection coll = new SQLDriverPropertyCollection();
        coll.setDriverProperties(newar);
        if (includeVersioner) {
            coll.acceptAliasVersioner(this._versioner);
        }
        return coll;
    }

    public void setDriverProperties(SQLDriverPropertyCollection value) {
        this._driverProps.clear();
        if (value != null) {
            int count = value.size();
            SQLDriverProperty[] newar = new SQLDriverProperty[count];
            for (int i = 0; i < count; ++i) {
                newar[i] = (SQLDriverProperty)value.getDriverProperty(i).clone();
            }
            this._driverProps.setDriverProperties(newar);
        }
    }

    private String getString(String data) {
        return data != null ? data.trim() : "";
    }

    public SQLAliasSchemaProperties getSchemaProperties() {
        return this._schemaProperties;
    }

    public void setSchemaProperties(SQLAliasSchemaProperties schemaProperties) {
        this._schemaProperties = schemaProperties;
        this._schemaProperties.acceptAliasVersioner(this._versioner);
    }

    public SQLAliasColorProperties getColorProperties() {
        return this._colorProperties;
    }

    public void setColorProperties(SQLAliasColorProperties colorProperties) {
        this._colorProperties = colorProperties;
        this._colorProperties.acceptAliasVersioner(this._versioner);
    }

    public SQLAliasConnectionProperties getConnectionProperties() {
        return this._connectionProperties;
    }

    public void setConnectionProperties(SQLAliasConnectionProperties connectionProperties) {
        this._connectionProperties = connectionProperties;
        this._connectionProperties.acceptAliasVersioner(this._versioner);
    }

    private static interface IStrings {
        public static final String ERR_BLANK_NAME = s_stringMgr.getString("SQLAlias.error.blankname");
        public static final String ERR_BLANK_DRIVER = s_stringMgr.getString("SQLAlias.error.blankdriver");
        public static final String ERR_BLANK_URL = s_stringMgr.getString("SQLAlias.error.blankurl");
    }
}

