/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.aliascolor;

import java.awt.Color;
import java.awt.MouseInfo;
import java.awt.Point;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.AliasFolder;
import net.sourceforge.squirrel_sql.client.gui.db.AliasTreeUtil;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.ColorPropertiesPanel;
import net.sourceforge.squirrel_sql.fw.gui.Dialogs;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class TreeAliasColorSelectionHandler {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TreeAliasColorSelectionHandler.class);

    public static void selectColor(JTree aliasTree) {
        TreePath[] selectionPaths = aliasTree.getSelectionPaths();
        if (null == selectionPaths || 0 == selectionPaths.length) {
            Dialogs.showOk(Main.getApplication().getMainFrame(), s_stringMgr.getString("select.alias.to.color"));
            return;
        }
        Color startColor = TreeAliasColorSelectionHandler.getStartColor(selectionPaths);
        if (null != startColor) {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu.add(TreeAliasColorSelectionHandler.createChooseColorItem(aliasTree, startColor));
            popupMenu.add(TreeAliasColorSelectionHandler.createRemoveColorItem(aliasTree));
            Point p = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(p, aliasTree);
            popupMenu.show(aliasTree, p.x, p.y);
        } else {
            TreeAliasColorSelectionHandler.colorSelection(aliasTree, null, false);
        }
    }

    private static void colorSelection(JTree aliasTree, Color startColor, boolean remove) {
        TreePath[] selectionPaths;
        Color newColor = null;
        if (!remove) {
            if (null == startColor && -1 != Props.getInt("AliasColor.last.alias.color", -1)) {
                startColor = new Color(Props.getInt("AliasColor.last.alias.color", -1));
            }
            if (null == (newColor = JColorChooser.showDialog(Main.getApplication().getMainFrame(), ColorPropertiesPanel.i18n.ALIAS_BACKGROUND_COLOR_CHOOSER_DIALOG_TITLE, startColor))) {
                return;
            }
            Props.putInt("AliasColor.last.alias.color", newColor.getRGB());
        }
        for (TreePath selectionPath : selectionPaths = aliasTree.getSelectionPaths()) {
            DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            if (selNode.getUserObject() instanceof SQLAlias) {
                if (remove) {
                    ((SQLAlias)selNode.getUserObject()).getColorProperties().setOverrideAliasBackgroundColor(false);
                    continue;
                }
                ((SQLAlias)selNode.getUserObject()).getColorProperties().setOverrideAliasBackgroundColor(true);
                ((SQLAlias)selNode.getUserObject()).getColorProperties().setAliasBackgroundColorRgbValue(newColor.getRGB());
                continue;
            }
            if (selNode.getUserObject() instanceof AliasFolder) {
                if (remove) {
                    ((AliasFolder)selNode.getUserObject()).setColorRGB(-1);
                    continue;
                }
                ((AliasFolder)selNode.getUserObject()).setColorRGB(newColor.getRGB());
                continue;
            }
            AliasTreeUtil.throwUnknownUserObjectException(selNode);
        }
        aliasTree.repaint();
    }

    private static JMenuItem createRemoveColorItem(JTree aliasTree) {
        JMenuItem ret = new JMenuItem(s_stringMgr.getString("remove.color"));
        ret.addActionListener(e -> TreeAliasColorSelectionHandler.colorSelection(aliasTree, null, true));
        return ret;
    }

    private static JMenuItem createChooseColorItem(JTree aliasTree, Color startColor) {
        JMenuItem ret = new JMenuItem(s_stringMgr.getString("choose.color"));
        ret.addActionListener(e -> TreeAliasColorSelectionHandler.colorSelection(aliasTree, startColor, false));
        return ret;
    }

    private static Color getStartColor(TreePath[] selectionPaths) {
        Color ret = null;
        DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)selectionPaths[0].getLastPathComponent();
        if (selNode.getUserObject() instanceof SQLAlias) {
            SQLAlias sel = (SQLAlias)selNode.getUserObject();
            if (sel.getColorProperties().isOverrideAliasBackgroundColor()) {
                ret = new Color(sel.getColorProperties().getAliasBackgroundColorRgbValue());
            }
        } else if (selNode.getUserObject() instanceof AliasFolder) {
            Integer colorRGB = ((AliasFolder)selNode.getUserObject()).getColorRGB();
            ret = -1 == colorRGB ? null : new Color(colorRGB);
        } else {
            AliasTreeUtil.throwUnknownUserObjectException(selNode);
        }
        return ret;
    }
}

