/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.aliasdndtree;

import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.AliasFolder;
import net.sourceforge.squirrel_sql.client.gui.db.AliasFolderState;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.aliasdndtree.AliasDndExport;
import net.sourceforge.squirrel_sql.client.gui.db.aliasdndtree.AliasDndImport;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class AliasDndTreeHandler {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasDndTreeHandler.class);
    private JTree _treeDndAliases;

    public AliasDndTreeHandler(JTree treeDndAliases) {
        this._treeDndAliases = treeDndAliases;
        this._treeDndAliases.setRootVisible(false);
        DefaultMutableTreeNode rootNode = this.getRootNode();
        rootNode.removeAllChildren();
        this.getDefaultTreeModel().nodeStructureChanged(rootNode);
        rootNode.setUserObject(new AliasFolder("AliasDndTreeRootNode", -1));
        this.initAliasDrop();
        this.initAliasDrag();
        this._treeDndAliases.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AliasDndTreeHandler.this.onTriggerPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                AliasDndTreeHandler.this.onTriggerPopup(e);
            }
        });
    }

    private void onTriggerPopup(MouseEvent me) {
        if (!me.isPopupTrigger() || null == this._treeDndAliases.getSelectionPaths() || 0 == this._treeDndAliases.getSelectionPaths().length) {
            return;
        }
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem mnuRemoveSelectedNodes = new JMenuItem(s_stringMgr.getString("AliasDndTreeHandler.remove.selected.nodes"));
        mnuRemoveSelectedNodes.addActionListener(e -> this.onRemoveSelectedNodes());
        popupMenu.add(mnuRemoveSelectedNodes);
        popupMenu.show(this._treeDndAliases, me.getX(), me.getY());
    }

    private void onRemoveSelectedNodes() {
        for (TreePath selectionPath : this._treeDndAliases.getSelectionPaths()) {
            DefaultMutableTreeNode node = this.toDefaultNode(selectionPath.getLastPathComponent());
            TreeNode parent = node.getParent();
            this.getDefaultTreeModel().removeNodeFromParent(node);
            this.getDefaultTreeModel().nodeStructureChanged(parent);
        }
    }

    private void initAliasDrag() {
        TransferHandler aliasImportDndTransferHandler = new TransferHandler("aliasDnd->AliasDnd_IMPORT"){

            @Override
            protected Transferable createTransferable(JComponent c) {
                return new DataHandler((Object)AliasDndTreeHandler.this.createAliasDndImport(), "application/x-java-jvm-local-objectref");
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        };
        this._treeDndAliases.setTransferHandler(aliasImportDndTransferHandler);
    }

    private AliasDndImport createAliasDndImport() {
        return new AliasDndImport(this._treeDndAliases.getSelectionPaths());
    }

    private void initAliasDrop() {
        try {
            this._treeDndAliases.setDragEnabled(true);
            DropTarget dt = new DropTarget();
            dt.addDropTargetListener(new DropTargetAdapter(){

                @Override
                public void drop(DropTargetDropEvent dtde) {
                    AliasDndTreeHandler.this.onDrop(dtde);
                }
            });
            this._treeDndAliases.setDropTarget(dt);
        }
        catch (TooManyListenersException e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private void onDrop(DropTargetDropEvent dtde) {
        try {
            Object transferData = dtde.getTransferable().getTransferData(dtde.getTransferable().getTransferDataFlavors()[0]);
            if (!(transferData instanceof AliasDndExport)) {
                return;
            }
            AliasDndExport aliasDndExport = (AliasDndExport)transferData;
            if (null != aliasDndExport.getListSelectedAlias()) {
                if (this.isAlreadyContained(aliasDndExport.getListSelectedAlias().getIdentifier())) {
                    Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("AliasDndTreeHandler.aliasAlreadyContained", aliasDndExport.getListSelectedAlias().getName()));
                    return;
                }
                this.getRootNode().add(new DefaultMutableTreeNode(aliasDndExport.getListSelectedAlias()));
            } else if (null != aliasDndExport.getTreeSelectionPaths()) {
                List<DefaultMutableTreeNode> clonedNodes = this.cloneAndCheckAlreadyContained(aliasDndExport.getTreeSelectionPaths());
                for (DefaultMutableTreeNode clonedNode : clonedNodes) {
                    this.getRootNode().add(clonedNode);
                }
            }
            this.getDefaultTreeModel().nodeStructureChanged(this.getRootNode());
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private List<DefaultMutableTreeNode> cloneAndCheckAlreadyContained(List<TreePath> treeSelectionPaths) {
        ArrayList<DefaultMutableTreeNode> ret = new ArrayList<DefaultMutableTreeNode>();
        for (TreePath path : treeSelectionPaths) {
            DefaultMutableTreeNode node = this.toDefaultNode(path.getLastPathComponent());
            DefaultMutableTreeNode cloneNode = this.cloneNode(node);
            if (null == cloneNode) continue;
            ret.add(cloneNode);
        }
        return ret;
    }

    private DefaultMutableTreeNode cloneNode(DefaultMutableTreeNode node) {
        SQLAlias sqlAlias;
        Object userObject = node.getUserObject();
        if (userObject instanceof SQLAlias && this.isAlreadyContained((sqlAlias = (SQLAlias)userObject).getIdentifier())) {
            Main.getApplication().getMessageHandler().showWarningMessage(s_stringMgr.getString("AliasDndTreeHandler.aliasAlreadyContained", sqlAlias.getName()));
            return null;
        }
        DefaultMutableTreeNode ret = userObject instanceof AliasFolder ? GUIUtils.createFolderNode(userObject) : new DefaultMutableTreeNode(userObject);
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode clonedChild = this.cloneNode(this.toDefaultNode(node.getChildAt(i)));
            if (null == clonedChild) continue;
            ret.add(clonedChild);
        }
        return ret;
    }

    private boolean isAlreadyContained(IIdentifier aliasIdentifier) {
        DefaultMutableTreeNode node = this.getRootNode();
        return null != this.findNodeByIdentifier(aliasIdentifier, node);
    }

    private DefaultMutableTreeNode findNodeByIdentifier(IIdentifier aliasIdentifier, DefaultMutableTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = this.toDefaultNode(node.getChildAt(i));
            if (childNode.getUserObject() instanceof SQLAlias && ((SQLAlias)childNode.getUserObject()).getIdentifier().equals(aliasIdentifier)) {
                return childNode;
            }
            DefaultMutableTreeNode ret = this.findNodeByIdentifier(aliasIdentifier, childNode);
            if (null == ret) continue;
            return ret;
        }
        return null;
    }

    private DefaultTreeModel getDefaultTreeModel() {
        return (DefaultTreeModel)this._treeDndAliases.getModel();
    }

    private DefaultMutableTreeNode toDefaultNode(Object defaullMutableTreeNode) {
        return (DefaultMutableTreeNode)defaullMutableTreeNode;
    }

    public AliasFolderState getAliasFolderState() {
        return new AliasFolderState(this.getRootNode(), this._treeDndAliases);
    }

    private DefaultMutableTreeNode getRootNode() {
        return this.toDefaultNode(this.getDefaultTreeModel().getRoot());
    }

    public List<SQLAlias> getSqlAliasList() {
        ArrayList<DefaultMutableTreeNode> aliasNodes = new ArrayList<DefaultMutableTreeNode>();
        this.gatherAliasNodes(this.getRootNode(), aliasNodes);
        return aliasNodes.stream().map(n -> (SQLAlias)n.getUserObject()).collect(Collectors.toList());
    }

    private void gatherAliases(DefaultMutableTreeNode node, List<SQLAlias> toFill) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = this.toDefaultNode(node.getChildAt(i));
            if (childNode.getUserObject() instanceof SQLAlias) {
                toFill.add((SQLAlias)childNode.getUserObject());
            }
            this.gatherAliases(childNode, toFill);
        }
    }

    private void gatherAliasNodes(DefaultMutableTreeNode node, List<DefaultMutableTreeNode> toFillAliasNodes) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = this.toDefaultNode(node.getChildAt(i));
            if (childNode.getUserObject() instanceof SQLAlias) {
                toFillAliasNodes.add(childNode);
            }
            this.gatherAliasNodes(childNode, toFillAliasNodes);
        }
    }

    public boolean isEmpty() {
        return 0 == this.getRootNode().getChildCount();
    }

    public void load(List<SQLAlias> sqlAliases, AliasFolderState aliasFolderState) {
        this.getRootNode().removeAllChildren();
        DefaultMutableTreeNode node = this.getRootNode();
        this.buildTree(sqlAliases, aliasFolderState, node);
        this.getDefaultTreeModel().nodeStructureChanged(this.getRootNode());
    }

    private void buildTree(List<SQLAlias> sqlAliases, AliasFolderState aliasFolderState, DefaultMutableTreeNode node) {
        for (AliasFolderState kid : aliasFolderState.getKids()) {
            DefaultMutableTreeNode newChild = new DefaultMutableTreeNode();
            if (null != kid.getAliasIdentifier()) {
                SQLAlias sqlAlias = sqlAliases.stream().filter(a -> kid.getAliasIdentifier().equals(a.getIdentifier())).findFirst().get();
                newChild.setUserObject(sqlAlias);
            } else {
                newChild.setUserObject(new AliasFolder(kid.getFolderName(), kid.getColorRGB()));
                this.buildTree(sqlAliases, kid, newChild);
            }
            node.add(newChild);
        }
    }

    public void removeAliases(List<SQLAlias> updatedAliases) {
        ArrayList<DefaultMutableTreeNode> aliasNodes = new ArrayList<DefaultMutableTreeNode>();
        this.gatherAliasNodes(this.getRootNode(), aliasNodes);
        for (DefaultMutableTreeNode aliasNode : aliasNodes) {
            for (SQLAlias updatedAlias : updatedAliases) {
                if (!updatedAlias.equals(aliasNode.getUserObject())) continue;
                this.getDefaultTreeModel().removeNodeFromParent(aliasNode);
            }
        }
    }

    public SQLAlias getSelectedAlias() {
        TreePath selectionPath = this._treeDndAliases.getSelectionPath();
        if (null == selectionPath) {
            return null;
        }
        if (this.toDefaultNode(selectionPath.getLastPathComponent()).getUserObject() instanceof SQLAlias) {
            return (SQLAlias)this.toDefaultNode(selectionPath.getLastPathComponent()).getUserObject();
        }
        return null;
    }
}

