/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.aliasproperties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.DriverPropertiesTable;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import org.apache.commons.lang3.StringUtils;

public class AddDriverPropertyDialog
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AddDriverPropertyDialog.class);
    JLabel propertyNameLbl = new JLabel(i18n.propertyNameLabel);
    JTextField propertyNameTF = new JTextField();
    JLabel propertyValueLbl = new JLabel(i18n.propertyValueLabel);
    JTextField propertyValueTF = new JTextField();
    JLabel propertyDescriptionLbl = new JLabel(i18n.propertyDescriptionLabel);
    JTextField propertyDescriptionTF = new JTextField();
    JButton addButton = new JButton(i18n.addButtonLabel);
    DriverPropertiesTable driverPropertiesTable = null;

    public AddDriverPropertyDialog(DriverPropertiesTable table) {
        this.driverPropertiesTable = table;
        JPanel panel = new JPanel(new GridLayout(3, 2));
        JPanel buttonPanel = new JPanel(new FlowLayout());
        panel.add(this.propertyNameLbl);
        panel.add(this.propertyNameTF);
        panel.add(this.propertyValueLbl);
        panel.add(this.propertyValueTF);
        panel.add(this.propertyDescriptionLbl);
        panel.add(this.propertyDescriptionTF);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String name = AddDriverPropertyDialog.this.propertyNameTF.getText();
                if (!StringUtils.isEmpty((CharSequence)name)) {
                    String value = AddDriverPropertyDialog.this.propertyValueTF.getText();
                    String desc = AddDriverPropertyDialog.this.propertyDescriptionTF.getText();
                    AddDriverPropertyDialog.this.driverPropertiesTable.addProperty(name, value, desc);
                    AddDriverPropertyDialog.this.setVisible(false);
                } else {
                    JOptionPane.showMessageDialog(AddDriverPropertyDialog.this, i18n.invalidNameMessage, i18n.invalidNameTitle, 0);
                }
            }
        });
        buttonPanel.add(this.addButton);
        super.getContentPane().setLayout(new BorderLayout());
        super.getContentPane().add((Component)panel, "Center");
        super.getContentPane().add((Component)buttonPanel, "South");
        this.setSize(295, 120);
    }

    private static interface i18n {
        public static final String addButtonLabel = s_stringMgr.getString("AddDriverPropertyDialog.addButtonLabel");
        public static final String invalidNameMessage = s_stringMgr.getString("AddDriverPropertyDialog.invalidNameMessage");
        public static final String invalidNameTitle = s_stringMgr.getString("AddDriverPropertyDialog.invalidNameTitle");
        public static final String propertyDescriptionLabel = s_stringMgr.getString("AddDriverPropertyDialog.propertyDescriptionLabel");
        public static final String propertyNameLabel = s_stringMgr.getString("AddDriverPropertyDialog.propertyNameLabel");
        public static final String propertyValueLabel = s_stringMgr.getString("AddDriverPropertyDialog.propertyValueLabel");
    }
}

