/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.aliasproperties;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.AliasPropertiesInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.ColorPropertiesController;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.ConnectionPropertiesController;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.DriverPropertiesController;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.IAliasPropertiesPanelController;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.SchemaPropertiesController;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.AliasPropertiesDialogFindInfo;
import net.sourceforge.squirrel_sql.client.mainframe.action.findprefs.PreferencesFindSupport;
import net.sourceforge.squirrel_sql.client.preferences.PreferenceType;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;

public class AliasPropertiesController {
    private static HashMap<IIdentifier, AliasPropertiesController> s_currentlyOpenInstancesByAliasID = new HashMap();
    private AliasPropertiesInternalFrame _frame;
    private ArrayList<IAliasPropertiesPanelController> _iAliasPropertiesPanelControllers = new ArrayList();
    private SQLAlias _alias;

    public static void showAliasProperties(SQLAlias selectedAlias, Window parentWindow) {
        AliasPropertiesController openProps = s_currentlyOpenInstancesByAliasID.get(selectedAlias.getIdentifier());
        if (null == openProps) {
            s_currentlyOpenInstancesByAliasID.put(selectedAlias.getIdentifier(), new AliasPropertiesController(selectedAlias, parentWindow));
        } else {
            openProps._frame.moveToFront();
        }
    }

    public static PreferencesFindSupport<AliasPropertiesDialogFindInfo> getPreferencesFindSupport() {
        return ofOpenDialog -> AliasPropertiesController.onCreateFindInfo(ofOpenDialog);
    }

    private static AliasPropertiesDialogFindInfo onCreateFindInfo(boolean ofOpenDialog) {
        AliasPropertiesController aliasPropertiesController;
        if (Main.getApplication().getAliasesAndDriversManager().getAliasList().isEmpty()) {
            return null;
        }
        SQLAlias firstAlias = Main.getApplication().getAliasesAndDriversManager().getAliasList().get(0);
        if (ofOpenDialog) {
            AliasPropertiesController.showAliasProperties(firstAlias, Main.getApplication().getMainFrame());
        }
        if (null == (aliasPropertiesController = s_currentlyOpenInstancesByAliasID.get(firstAlias.getIdentifier()))) {
            aliasPropertiesController = new AliasPropertiesController(firstAlias, true, Main.getApplication().getMainFrame());
        }
        return new AliasPropertiesDialogFindInfo(aliasPropertiesController._frame.getTitle(), aliasPropertiesController._frame.tabPane);
    }

    private AliasPropertiesController(SQLAlias alias, Window parentWindow) {
        this(alias, false, parentWindow);
    }

    private AliasPropertiesController(SQLAlias selectedAlias, boolean toUseByPreferencesFinderOnly, Window parentWindow) {
        this._alias = selectedAlias;
        this._frame = new AliasPropertiesInternalFrame(this._alias.getName(), parentWindow);
        Main.getApplication().getMainFrame().addWidget(this._frame);
        DialogWidget.centerWithinDesktop(this._frame);
        this._frame.btnOk.addActionListener(e -> this.onOK());
        this._frame.btnClose.addActionListener(e -> this.onClose());
        this._frame.addWidgetListener(new WidgetAdapter(){

            @Override
            public void widgetClosed(WidgetEvent evt) {
                AliasPropertiesController.this.performClose();
            }
        });
        this.loadTabs();
        if (!toUseByPreferencesFinderOnly) {
            GUIUtils.enableCloseByEscape(this._frame, dw -> s_currentlyOpenInstancesByAliasID.remove(this._alias.getIdentifier()));
            this._frame.setVisible(true);
        }
    }

    private void loadTabs() {
        this._iAliasPropertiesPanelControllers.add(new SchemaPropertiesController(this._alias));
        this._iAliasPropertiesPanelControllers.add(new DriverPropertiesController(this._alias));
        this._iAliasPropertiesPanelControllers.add(new ColorPropertiesController(this._alias));
        this._iAliasPropertiesPanelControllers.add(new ConnectionPropertiesController(this._alias));
        IAliasPropertiesPanelController[] pluginAliasPropertiesPanelControllers = Main.getApplication().getPluginManager().getAliasPropertiesPanelControllers(this._alias);
        this._iAliasPropertiesPanelControllers.addAll(Arrays.asList(pluginAliasPropertiesPanelControllers));
        for (int i = 0; i < this._iAliasPropertiesPanelControllers.size(); ++i) {
            IAliasPropertiesPanelController aliasPropertiesController = this._iAliasPropertiesPanelControllers.get(i);
            int index = this._frame.tabPane.getTabCount();
            this._frame.tabPane.add(aliasPropertiesController.getTitle(), aliasPropertiesController.getPanelComponent());
            this._frame.tabPane.setToolTipTextAt(index, aliasPropertiesController.getHint());
        }
    }

    private void performClose() {
        s_currentlyOpenInstancesByAliasID.remove(this._alias.getIdentifier());
        this._frame.setVisible(false);
        this._frame.dispose();
    }

    private void onOK() {
        for (int i = 0; i < this._iAliasPropertiesPanelControllers.size(); ++i) {
            IAliasPropertiesPanelController aliasPropertiesController = this._iAliasPropertiesPanelControllers.get(i);
            aliasPropertiesController.applyChanges();
        }
        Main.getApplication().savePreferences(PreferenceType.ALIAS_DEFINITIONS);
        this.performClose();
    }

    private void onClose() {
        this.performClose();
    }
}

