/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.aliasproperties;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAliasColorProperties;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class ColorPropertiesPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ColorPropertiesPanel.class);
    private JCheckBox toolbarBackgroundColorChk = new JCheckBox("");
    private JButton toolbarBackgroundColorBtn = null;
    private JLabel toolBarBackgroundLbl = null;
    private JPanel toolbarBackgroundColorPnl = new JPanel();
    private Color toolbarBackgroundColor = null;
    private JButton syncComponentBackgroundColorBtn = null;
    private JCheckBox objectTreeBackgroundColorChk = new JCheckBox("");
    private JButton objectTreeBackgroundColorBtn = null;
    private JLabel objectTreeBackgroundLbl = null;
    private JPanel objectTreeBackgroundColorPnl = new JPanel();
    private Color objectTreeBackgroundColor = null;
    private JCheckBox statusBarBackgroundColorChk = new JCheckBox("");
    private JButton statusBarBackgroundColorBtn = null;
    private JLabel statusBarBackgroundLbl = null;
    private JPanel statusBarBackgroundColorPnl = new JPanel();
    private Color statusBarBackgroundColor = null;
    private JCheckBox aliasBackgroundColorChk = new JCheckBox("");
    private JButton aliasBackgroundColorBtn = null;
    private JLabel aliasBackgroundLbl = null;
    private JPanel aliasBackgroundColorPnl = new JPanel();
    private Color aliasBackgroundColor = null;
    private SQLAliasColorProperties _props = null;

    public ColorPropertiesPanel(SQLAliasColorProperties props) {
        Utilities.checkNull("ColorPropertiesPanel.init", "props", props);
        this._props = props;
        this.createUserInterface();
    }

    public SQLAliasColorProperties getSQLAliasColorProperties() {
        if (this.toolbarBackgroundColorChk.isSelected()) {
            if (this.toolbarBackgroundColor != null) {
                this._props.setOverrideToolbarBackgroundColor(true);
                this._props.setToolbarBackgroundColorRgbValue(this.toolbarBackgroundColor.getRGB());
            }
        } else {
            this._props.setOverrideToolbarBackgroundColor(false);
        }
        if (this.objectTreeBackgroundColorChk.isSelected()) {
            if (this.objectTreeBackgroundColor != null) {
                this._props.setOverrideObjectTreeBackgroundColor(true);
                this._props.setObjectTreeBackgroundColorRgbValue(this.objectTreeBackgroundColor.getRGB());
            }
        } else {
            this._props.setOverrideObjectTreeBackgroundColor(false);
        }
        if (this.statusBarBackgroundColorChk.isSelected()) {
            if (this.statusBarBackgroundColor != null) {
                this._props.setOverrideStatusBarBackgroundColor(true);
                this._props.setStatusBarBackgroundColorRgbValue(this.statusBarBackgroundColor.getRGB());
            }
        } else {
            this._props.setOverrideStatusBarBackgroundColor(false);
        }
        if (this.aliasBackgroundColorChk.isSelected()) {
            if (this.aliasBackgroundColor != null) {
                this._props.setOverrideAliasBackgroundColor(true);
                this._props.setAliasBackgroundColorRgbValue(this.aliasBackgroundColor.getRGB());
            }
        } else {
            this._props.setOverrideAliasBackgroundColor(false);
        }
        return this._props;
    }

    private void createUserInterface() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 0;
        this.add((Component)this.createInfoPanel(), gbc);
        this.prepareNewRow(gbc);
        this.addToolbarColorComponents(gbc);
        this.prepareNewRow(gbc);
        this.addSyncComponentColorsWithToolbarCheckBox(gbc);
        gbc.insets.top = 20;
        this.prepareNewRow(gbc);
        this.addObjectTreeColorComponents(gbc);
        gbc.insets.top = 5;
        this.prepareNewRow(gbc);
        this.addStatusBarColorComponents(gbc);
        this.prepareNewRow(gbc);
        this.addAliasColorComponents(gbc);
    }

    private void addSyncComponentColorsWithToolbarCheckBox(GridBagConstraints gbc) {
        ++gbc.gridx;
        gbc.gridwidth = 2;
        this.syncComponentBackgroundColorBtn = new JButton(s_stringMgr.getString("ColorPropertiesPanel.syncComponentBackgroundColorChkLabel"));
        this.add((Component)this.syncComponentBackgroundColorBtn, gbc);
        this.syncComponentBackgroundColorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPropertiesPanel.this.objectTreeBackgroundColorChk.setSelected(true);
                ColorPropertiesPanel.this.objectTreeBackgroundColor = ColorPropertiesPanel.this.toolbarBackgroundColor;
                ColorPropertiesPanel.this.objectTreeBackgroundColorBtn.setEnabled(true);
                ColorPropertiesPanel.this.objectTreeBackgroundColorPnl.setBackground(ColorPropertiesPanel.this.toolbarBackgroundColor);
                ColorPropertiesPanel.this.objectTreeBackgroundColorPnl.setEnabled(true);
                ColorPropertiesPanel.this.objectTreeBackgroundLbl.setEnabled(true);
                ColorPropertiesPanel.this.statusBarBackgroundColorChk.setSelected(true);
                ColorPropertiesPanel.this.statusBarBackgroundColor = ColorPropertiesPanel.this.toolbarBackgroundColor;
                ColorPropertiesPanel.this.statusBarBackgroundColorBtn.setEnabled(true);
                ColorPropertiesPanel.this.statusBarBackgroundColorPnl.setBackground(ColorPropertiesPanel.this.toolbarBackgroundColor);
                ColorPropertiesPanel.this.statusBarBackgroundColorPnl.setEnabled(true);
                ColorPropertiesPanel.this.statusBarBackgroundLbl.setEnabled(true);
                ColorPropertiesPanel.this.aliasBackgroundColorChk.setSelected(true);
                ColorPropertiesPanel.this.aliasBackgroundColor = ColorPropertiesPanel.this.toolbarBackgroundColor;
                ColorPropertiesPanel.this.aliasBackgroundColorBtn.setEnabled(true);
                ColorPropertiesPanel.this.aliasBackgroundColorPnl.setBackground(ColorPropertiesPanel.this.toolbarBackgroundColor);
                ColorPropertiesPanel.this.aliasBackgroundColorPnl.setEnabled(true);
                ColorPropertiesPanel.this.aliasBackgroundLbl.setEnabled(true);
            }
        });
    }

    private void addStatusBarColorComponents(GridBagConstraints gbc) {
        this.statusBarBackgroundColorChk.setSelected(this._props.isOverrideStatusBarBackgroundColor());
        this.add((Component)this.statusBarBackgroundColorChk, gbc);
        ++gbc.gridx;
        this.statusBarBackgroundColorBtn = new JButton(s_stringMgr.getString("ColorPropertiesPanel.statusBarBackgroundColorBtnLabel"));
        this.add((Component)this.statusBarBackgroundColorBtn, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        gbc.fill = 2;
        this.statusBarBackgroundColorChk.setSelected(this._props.isOverrideStatusBarBackgroundColor());
        this.statusBarBackgroundColorBtn.setEnabled(this._props.isOverrideStatusBarBackgroundColor());
        this.statusBarBackgroundLbl = new JLabel(i18n.BACKGROUND_COLOR_LABEL);
        this.statusBarBackgroundLbl.setEnabled(this._props.isOverrideStatusBarBackgroundColor());
        this.statusBarBackgroundColorPnl.add(this.statusBarBackgroundLbl);
        this.statusBarBackgroundColorPnl.setEnabled(this._props.isOverrideStatusBarBackgroundColor());
        if (this._props.isOverrideStatusBarBackgroundColor()) {
            this.statusBarBackgroundColor = new Color(this._props.getStatusBarBackgroundColorRgbValue());
            this.statusBarBackgroundColorPnl.setBackground(this.statusBarBackgroundColor);
        }
        this.add((Component)this.statusBarBackgroundColorPnl, gbc);
        this.statusBarBackgroundColorChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ColorPropertiesPanel.this.statusBarBackgroundColorChk.isSelected()) {
                    ColorPropertiesPanel.this.statusBarBackgroundColorBtn.setEnabled(true);
                    ColorPropertiesPanel.this.statusBarBackgroundColorPnl.setEnabled(true);
                    ColorPropertiesPanel.this.statusBarBackgroundLbl.setEnabled(true);
                } else {
                    ColorPropertiesPanel.this.statusBarBackgroundColorBtn.setEnabled(false);
                    ColorPropertiesPanel.this.statusBarBackgroundColorPnl.setEnabled(false);
                    ColorPropertiesPanel.this.statusBarBackgroundLbl.setEnabled(false);
                }
            }
        });
        this.statusBarBackgroundColorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color startColor = ColorPropertiesPanel.this.statusBarBackgroundColor == null ? Color.WHITE : ColorPropertiesPanel.this.statusBarBackgroundColor;
                Color newColor = JColorChooser.showDialog(GUIUtils.getOwningFrame(ColorPropertiesPanel.this), s_stringMgr.getString("ColorPropertiesPanel.statusBarBackgroundColorChooserDialogTitle"), startColor);
                if (newColor != null) {
                    ColorPropertiesPanel.this.statusBarBackgroundColor = newColor;
                    ColorPropertiesPanel.this.statusBarBackgroundColorPnl.setBackground(newColor);
                    ColorPropertiesPanel.this.statusBarBackgroundColorPnl.validate();
                }
            }
        });
    }

    private void addAliasColorComponents(GridBagConstraints gbc) {
        this.aliasBackgroundColorChk.setSelected(this._props.isOverrideAliasBackgroundColor());
        this.add((Component)this.aliasBackgroundColorChk, gbc);
        ++gbc.gridx;
        this.aliasBackgroundColorBtn = new JButton(s_stringMgr.getString("ColorPropertiesPanel.aliasBackgroundColorBtnLabel"));
        this.add((Component)this.aliasBackgroundColorBtn, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        gbc.fill = 2;
        this.aliasBackgroundColorChk.setSelected(this._props.isOverrideAliasBackgroundColor());
        this.aliasBackgroundColorBtn.setEnabled(this._props.isOverrideAliasBackgroundColor());
        this.aliasBackgroundLbl = new JLabel(i18n.BACKGROUND_COLOR_LABEL);
        this.aliasBackgroundLbl.setEnabled(this._props.isOverrideAliasBackgroundColor());
        this.aliasBackgroundColorPnl.add(this.aliasBackgroundLbl);
        this.aliasBackgroundColorPnl.setEnabled(this._props.isOverrideAliasBackgroundColor());
        if (this._props.isOverrideAliasBackgroundColor()) {
            this.aliasBackgroundColor = new Color(this._props.getAliasBackgroundColorRgbValue());
            this.aliasBackgroundColorPnl.setBackground(this.aliasBackgroundColor);
        }
        this.add((Component)this.aliasBackgroundColorPnl, gbc);
        this.aliasBackgroundColorChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ColorPropertiesPanel.this.aliasBackgroundColorChk.isSelected()) {
                    ColorPropertiesPanel.this.aliasBackgroundColorBtn.setEnabled(true);
                    ColorPropertiesPanel.this.aliasBackgroundColorPnl.setEnabled(true);
                    ColorPropertiesPanel.this.aliasBackgroundLbl.setEnabled(true);
                } else {
                    ColorPropertiesPanel.this.aliasBackgroundColorBtn.setEnabled(false);
                    ColorPropertiesPanel.this.aliasBackgroundColorPnl.setEnabled(false);
                    ColorPropertiesPanel.this.aliasBackgroundLbl.setEnabled(false);
                }
            }
        });
        this.aliasBackgroundColorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color startColor = ColorPropertiesPanel.this.aliasBackgroundColor == null ? Color.WHITE : ColorPropertiesPanel.this.aliasBackgroundColor;
                Color newColor = JColorChooser.showDialog(GUIUtils.getOwningFrame(ColorPropertiesPanel.this), i18n.ALIAS_BACKGROUND_COLOR_CHOOSER_DIALOG_TITLE, startColor);
                if (newColor != null) {
                    ColorPropertiesPanel.this.aliasBackgroundColor = newColor;
                    ColorPropertiesPanel.this.aliasBackgroundColorPnl.setBackground(newColor);
                    ColorPropertiesPanel.this.aliasBackgroundColorPnl.validate();
                }
            }
        });
    }

    private void prepareNewRow(GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
    }

    private void addObjectTreeColorComponents(GridBagConstraints gbc) {
        this.objectTreeBackgroundColorChk.setSelected(this._props.isOverrideObjectTreeBackgroundColor());
        this.add((Component)this.objectTreeBackgroundColorChk, gbc);
        ++gbc.gridx;
        this.objectTreeBackgroundColorBtn = new JButton(s_stringMgr.getString("ColorPropertiesPanel.objectTreeBackgroundColorButtonLabel"));
        this.add((Component)this.objectTreeBackgroundColorBtn, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        gbc.fill = 2;
        this.objectTreeBackgroundColorChk.setSelected(this._props.isOverrideObjectTreeBackgroundColor());
        this.objectTreeBackgroundColorBtn.setEnabled(this._props.isOverrideObjectTreeBackgroundColor());
        this.objectTreeBackgroundLbl = new JLabel(i18n.BACKGROUND_COLOR_LABEL);
        this.objectTreeBackgroundColorPnl.add(this.objectTreeBackgroundLbl);
        this.objectTreeBackgroundColorPnl.setEnabled(this._props.isOverrideObjectTreeBackgroundColor());
        this.objectTreeBackgroundLbl.setEnabled(this._props.isOverrideObjectTreeBackgroundColor());
        if (this._props.isOverrideObjectTreeBackgroundColor()) {
            this.objectTreeBackgroundColor = new Color(this._props.getObjectTreeBackgroundColorRgbValue());
            this.objectTreeBackgroundColorPnl.setBackground(this.objectTreeBackgroundColor);
        }
        this.add((Component)this.objectTreeBackgroundColorPnl, gbc);
        this.objectTreeBackgroundColorChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ColorPropertiesPanel.this.objectTreeBackgroundColorChk.isSelected()) {
                    ColorPropertiesPanel.this.objectTreeBackgroundColorBtn.setEnabled(true);
                    ColorPropertiesPanel.this.objectTreeBackgroundColorPnl.setEnabled(true);
                    ColorPropertiesPanel.this.objectTreeBackgroundLbl.setEnabled(true);
                } else {
                    ColorPropertiesPanel.this.objectTreeBackgroundColorBtn.setEnabled(false);
                    ColorPropertiesPanel.this.objectTreeBackgroundColorPnl.setEnabled(false);
                    ColorPropertiesPanel.this.objectTreeBackgroundLbl.setEnabled(false);
                }
            }
        });
        this.objectTreeBackgroundColorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color startColor = ColorPropertiesPanel.this.objectTreeBackgroundColor == null ? Color.WHITE : ColorPropertiesPanel.this.objectTreeBackgroundColor;
                Color newColor = JColorChooser.showDialog(GUIUtils.getOwningWindow(ColorPropertiesPanel.this), s_stringMgr.getString("ColorPropertiesPanel.objectTreeBackgroundColorChooserDialogTitle"), startColor);
                if (newColor != null) {
                    ColorPropertiesPanel.this.objectTreeBackgroundColor = newColor;
                    ColorPropertiesPanel.this.objectTreeBackgroundColorPnl.setBackground(newColor);
                    ColorPropertiesPanel.this.objectTreeBackgroundColorPnl.validate();
                }
            }
        });
    }

    private void addToolbarColorComponents(GridBagConstraints gbc) {
        this.toolbarBackgroundColorChk.setSelected(this._props.isOverrideToolbarBackgroundColor());
        this.add((Component)this.toolbarBackgroundColorChk, gbc);
        ++gbc.gridx;
        this.toolbarBackgroundColorBtn = new JButton(s_stringMgr.getString("ColorPropertiesPanel.toolbarBackgroundColorBtnLabel"));
        this.add((Component)this.toolbarBackgroundColorBtn, gbc);
        ++gbc.gridx;
        gbc.anchor = 13;
        gbc.fill = 2;
        this.toolbarBackgroundColorChk.setSelected(this._props.isOverrideToolbarBackgroundColor());
        this.toolbarBackgroundColorBtn.setEnabled(this._props.isOverrideToolbarBackgroundColor());
        this.toolBarBackgroundLbl = new JLabel(i18n.BACKGROUND_COLOR_LABEL);
        this.toolbarBackgroundColorPnl.add(this.toolBarBackgroundLbl);
        this.toolbarBackgroundColorPnl.setEnabled(this._props.isOverrideToolbarBackgroundColor());
        this.toolBarBackgroundLbl.setEnabled(this._props.isOverrideToolbarBackgroundColor());
        if (this._props.isOverrideToolbarBackgroundColor()) {
            this.toolbarBackgroundColor = new Color(this._props.getToolbarBackgroundColorRgbValue());
            this.toolbarBackgroundColorPnl.setBackground(this.toolbarBackgroundColor);
        }
        this.add((Component)this.toolbarBackgroundColorPnl, gbc);
        this.toolbarBackgroundColorChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ColorPropertiesPanel.this.toolbarBackgroundColorChk.isSelected()) {
                    ColorPropertiesPanel.this.toolbarBackgroundColorBtn.setEnabled(true);
                    ColorPropertiesPanel.this.toolbarBackgroundColorPnl.setEnabled(true);
                    ColorPropertiesPanel.this.toolBarBackgroundLbl.setEnabled(true);
                } else {
                    ColorPropertiesPanel.this.toolbarBackgroundColorBtn.setEnabled(false);
                    ColorPropertiesPanel.this.toolbarBackgroundColorPnl.setEnabled(false);
                    ColorPropertiesPanel.this.toolBarBackgroundLbl.setEnabled(false);
                }
            }
        });
        this.toolbarBackgroundColorBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color startColor = ColorPropertiesPanel.this.toolbarBackgroundColor == null ? Color.WHITE : ColorPropertiesPanel.this.toolbarBackgroundColor;
                Color newColor = JColorChooser.showDialog(GUIUtils.getOwningFrame(ColorPropertiesPanel.this), s_stringMgr.getString("ColorPropertiesPanel.toolbarBackgroundColorChooserDialogTitle"), startColor);
                if (newColor != null) {
                    ColorPropertiesPanel.this.toolbarBackgroundColor = newColor;
                    ColorPropertiesPanel.this.toolbarBackgroundColorPnl.setBackground(newColor);
                    ColorPropertiesPanel.this.toolbarBackgroundColorPnl.validate();
                }
            }
        });
    }

    private Box createInfoPanel() {
        Box pnl = new Box(0);
        pnl.add(new MultipleLineLabel(s_stringMgr.getString("ColorPropertiesPanel.instructions")));
        return pnl;
    }

    public static interface i18n {
        public static final String BACKGROUND_COLOR_LABEL = s_stringMgr.getString("ColorPropertiesPanel.backgroundColorLabel");
        public static final String ALIAS_BACKGROUND_COLOR_CHOOSER_DIALOG_TITLE = s_stringMgr.getString("ColorPropertiesPanel.aliasBackgroundColorChooserDialogTitle");
    }
}

