/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.aliasproperties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAliasConnectionProperties;
import net.sourceforge.squirrel_sql.client.gui.db.modifyaliases.SQLAliasPropType;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class ConnectionPropertiesPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ConnectionPropertiesPanel.class);
    private JCheckBox enableConnectionKeepAliveChk = null;
    private JLabel sleepForLabel = null;
    private JSpinner sleepTime = null;
    private JLabel secondsLabel = null;
    private JLabel executeLabel = null;
    private JTextArea sqlTextArea = new JTextArea();
    private SQLAliasConnectionProperties _props = null;

    public ConnectionPropertiesPanel(SQLAliasConnectionProperties props) {
        Utilities.checkNull("ConnectionPropertiesPanel.init", "props", props);
        this._props = props;
        this.createUserInterface();
        this.setSQLAliasConnectionProperties(props);
    }

    public SQLAliasConnectionProperties getSQLAliasConnectionProperties() {
        if (this.enableConnectionKeepAliveChk.isSelected()) {
            this._props.setEnableConnectionKeepAlive(true);
            int sleepTimeInt = (Integer)this.sleepTime.getValue();
            this._props.setKeepAliveSleepTimeSeconds(sleepTimeInt);
            this._props.setKeepAliveSqlStatement(this.sqlTextArea.getText());
        } else {
            this._props.setEnableConnectionKeepAlive(false);
        }
        return this._props;
    }

    public void setSQLAliasConnectionProperties(SQLAliasConnectionProperties props) {
        this._props = props;
        this.enableConnectionKeepAliveChk.setSelected(this._props.isEnableConnectionKeepAlive());
        this.sleepForLabel.setEnabled(this._props.isEnableConnectionKeepAlive());
        this.sleepTime.setEnabled(this._props.isEnableConnectionKeepAlive());
        this.sleepTime.setValue(props.getKeepAliveSleepTimeSeconds());
        this.secondsLabel.setEnabled(this._props.isEnableConnectionKeepAlive());
        this.executeLabel.setEnabled(this._props.isEnableConnectionKeepAlive());
        this.sqlTextArea.setEnabled(this._props.isEnableConnectionKeepAlive());
        this.sqlTextArea.setText(props.getKeepAliveSqlStatement());
    }

    private void createUserInterface() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.75;
        gbc.weighty = 0.3;
        this.addInfoPanel(gbc);
        this.prepareNewRow(gbc);
        this.addMiddle(gbc);
        this.prepareNewRow(gbc);
        this.addExecuteLabel(gbc);
        this.prepareNewRow(gbc);
        this.addSqlTextAreaPanel(gbc);
    }

    private void addExecuteLabel(GridBagConstraints gbc) {
        this.executeLabel = new JLabel(s_stringMgr.getString("ConnectionPropertiesPanel.executeLabel"));
        Insets orig = gbc.insets;
        gbc.insets = new Insets(0, 25, 0, 0);
        this.add((Component)this.executeLabel, gbc);
        gbc.insets = orig;
    }

    private void addInfoPanel(GridBagConstraints gbc) {
        gbc.weighty = 0.0;
        gbc.fill = 1;
        MultipleLineLabel label = new MultipleLineLabel(s_stringMgr.getString("ConnectionPropertiesPanel.instructions"));
        this.add((Component)label, gbc);
    }

    private void addMiddle(GridBagConstraints gbc) {
        JPanel middlePanel = new JPanel();
        middlePanel.setLayout(new GridLayout(2, 1));
        this.setupEnabledCheckbox();
        middlePanel.add(this.enableConnectionKeepAliveChk);
        middlePanel.add(this.getSleepTimePanel());
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.add((Component)middlePanel, gbc);
    }

    private JPanel getSleepTimePanel() {
        JPanel sleepTimePanel = new JPanel();
        sleepTimePanel.setLayout(new GridBagLayout());
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this._props.getKeepAliveSleepTimeSeconds(), 10, Integer.MAX_VALUE, 10);
        this.sleepTime = new JSpinner(spinnerNumberModel);
        this.sleepTime.setPreferredSize(new Dimension(75, 25));
        this.sleepForLabel = new JLabel(SQLAliasPropType.connectionProp_keepAliveSleepSeconds.getI18nString());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.05;
        gbc.insets = new Insets(0, 5, 0, 0);
        sleepTimePanel.add((Component)this.sleepForLabel, gbc);
        gbc.anchor = 10;
        ++gbc.gridx;
        gbc.weightx = 0.05;
        sleepTimePanel.add((Component)this.sleepTime, gbc);
        this.secondsLabel = new JLabel(s_stringMgr.getString("ConnectionPropertiesPanel.secondsLabel"));
        gbc.anchor = 17;
        ++gbc.gridx;
        gbc.weightx = 0.9;
        sleepTimePanel.add((Component)this.secondsLabel, gbc);
        return sleepTimePanel;
    }

    private void addSqlTextAreaPanel(GridBagConstraints gbc) {
        gbc.weighty = 0.7;
        gbc.fill = 1;
        gbc.insets = new Insets(10, 25, 10, 10);
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        textPanel.add((Component)new JScrollPane(this.sqlTextArea), "Center");
        this.add((Component)textPanel, gbc);
    }

    private void prepareNewRow(GridBagConstraints gbc) {
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.weighty = 0.0;
    }

    private void setupEnabledCheckbox() {
        this.enableConnectionKeepAliveChk = new JCheckBox(SQLAliasPropType.connectionProp_keepAlive.getI18nString());
        this.enableConnectionKeepAliveChk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionPropertiesPanel.this.sleepForLabel.setEnabled(ConnectionPropertiesPanel.this.enableConnectionKeepAliveChk.isSelected());
                ConnectionPropertiesPanel.this.sleepTime.setEnabled(ConnectionPropertiesPanel.this.enableConnectionKeepAliveChk.isSelected());
                ConnectionPropertiesPanel.this.secondsLabel.setEnabled(ConnectionPropertiesPanel.this.enableConnectionKeepAliveChk.isSelected());
                ConnectionPropertiesPanel.this.executeLabel.setEnabled(ConnectionPropertiesPanel.this.enableConnectionKeepAliveChk.isSelected());
                ConnectionPropertiesPanel.this.sqlTextArea.setEnabled(ConnectionPropertiesPanel.this.enableConnectionKeepAliveChk.isSelected());
            }
        });
    }
}

