/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.aliasproperties;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.util.Properties;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.DriverPropertiesPanel;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.IAliasPropertiesPanelController;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DriverPropertiesController
implements IAliasPropertiesPanelController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DriverPropertiesController.class);
    private DriverPropertiesPanel _propsPnl;
    private SQLAlias _alias;
    String _errMsg;
    private Color _origTblColor;

    public DriverPropertiesController(SQLAlias alias) {
        this._alias = alias;
        String aliasUrl = alias.getUrl();
        IIdentifier driverIdentifier = alias.getDriverIdentifier();
        if (driverIdentifier == null) {
            this._errMsg = s_stringMgr.getString("DriverPropertiesController.noDriverSelected");
            Main.getApplication().getMessageHandler().showErrorMessage(this._errMsg);
            return;
        }
        Driver jdbcDriver = Main.getApplication().getSQLDriverManager().getJDBCDriver(driverIdentifier);
        if (jdbcDriver == null) {
            this._errMsg = s_stringMgr.getString("DriverPropertiesController.loadingDriverFailed", Main.getApplication().getAliasesAndDriversManager().getDriver(driverIdentifier).getName());
            Main.getApplication().getMessageHandler().showErrorMessage(this._errMsg);
            return;
        }
        try {
            if (!jdbcDriver.acceptsURL(aliasUrl)) {
                String driverName = Main.getApplication().getAliasesAndDriversManager().getDriver(driverIdentifier).getName();
                this._errMsg = s_stringMgr.getString("DriverPropertiesController.invalidUrl", new String[]{driverName, aliasUrl});
                Main.getApplication().getMessageHandler().showErrorMessage(this._errMsg);
                return;
            }
        }
        catch (Exception e) {
            this._errMsg = s_stringMgr.getString("DriverPropertiesController.loadingDriverFailed", Main.getApplication().getAliasesAndDriversManager().getDriver(driverIdentifier).getName());
            Main.getApplication().getMessageHandler().showErrorMessage(this._errMsg);
            return;
        }
        DriverPropertyInfo[] infoAr = new DriverPropertyInfo[]{};
        try {
            infoAr = jdbcDriver.getPropertyInfo(alias.getUrl(), new Properties());
        }
        catch (Exception e) {
            this._errMsg = s_stringMgr.getString("DriverPropertiesController.gettingDriverPropetiesFailed");
            Main.getApplication().getMessageHandler().showErrorMessage(this._errMsg);
        }
        SQLDriverPropertyCollection driverPropertiesClone = alias.getDriverPropertiesClone(true);
        driverPropertiesClone.applyDriverPropertyInfo(infoAr);
        this._propsPnl = new DriverPropertiesPanel(driverPropertiesClone);
        this._propsPnl.chkUseDriverProperties.setSelected(alias.getUseDriverProperties());
        this.updateTableEnabled();
        this._propsPnl.chkUseDriverProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DriverPropertiesController.this.updateTableEnabled();
            }
        });
    }

    private void updateTableEnabled() {
        if (null == this._origTblColor) {
            this._origTblColor = this._propsPnl.tblDriverProperties.getForeground();
        }
        this._propsPnl.tblDriverProperties.setEnabled(this._propsPnl.chkUseDriverProperties.isSelected());
        if (this._propsPnl.chkUseDriverProperties.isSelected()) {
            this._propsPnl.tblDriverProperties.setForeground(this._origTblColor);
        } else {
            this._propsPnl.tblDriverProperties.setForeground(Color.lightGray);
        }
    }

    @Override
    public Component getPanelComponent() {
        if (null == this._propsPnl) {
            return new MultipleLineLabel(this._errMsg);
        }
        return this._propsPnl;
    }

    @Override
    public void applyChanges() {
        if (null != this._propsPnl) {
            this._alias.setDriverProperties(this._propsPnl.getSQLDriverProperties());
            this._alias.setUseDriverProperties(this._propsPnl.chkUseDriverProperties.isSelected());
        }
    }

    @Override
    public String getTitle() {
        return s_stringMgr.getString("DriverPropertiesController.title");
    }

    @Override
    public String getHint() {
        return s_stringMgr.getString("DriverPropertiesController.title");
    }
}

