/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.aliasproperties;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.DriverPropertiesTable;
import net.sourceforge.squirrel_sql.client.gui.db.modifyaliases.SQLAliasPropType;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DriverPropertiesPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DriverPropertiesPanel.class);
    JCheckBox chkUseDriverProperties = new JCheckBox(SQLAliasPropType.driverProp_useDriverProperties.getI18nString());
    DriverPropertiesTable tblDriverProperties;
    private final MultipleLineLabel _descriptionLbl = new MultipleLineLabel();

    public DriverPropertiesPanel(SQLDriverPropertyCollection props) {
        super(new GridBagLayout());
        if (props == null) {
            throw new IllegalArgumentException("SQLDriverPropertyCollection == null");
        }
        this.createUserInterface(props);
    }

    public SQLDriverPropertyCollection getSQLDriverProperties() {
        TableCellEditor cellEditor = this.tblDriverProperties.getCellEditor();
        if (null != cellEditor) {
            cellEditor.stopCellEditing();
        }
        return this.tblDriverProperties.getTypedModel().getSQLDriverProperties();
    }

    private void createUserInterface(SQLDriverPropertyCollection props) {
        this.tblDriverProperties = new DriverPropertiesTable(props);
        GridBagConstraints gbc = new GridBagConstraints();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)this.chkUseDriverProperties, gbc);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        ++gbc.gridy;
        JScrollPane sp = new JScrollPane(this.tblDriverProperties);
        this.add((Component)sp, gbc);
        gbc.fill = 2;
        gbc.weighty = 0.0;
        ++gbc.gridy;
        this.add((Component)this.createInfoPanel(), gbc);
        this.tblDriverProperties.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DriverPropertiesPanel.this.updateDescription(DriverPropertiesPanel.this.tblDriverProperties.getSelectedRow());
            }
        });
        if (this.tblDriverProperties.getRowCount() > 0) {
            this.tblDriverProperties.setRowSelectionInterval(0, 0);
        }
    }

    private void updateDescription(int idx) {
        if (idx != -1) {
            String desc = (String)this.tblDriverProperties.getValueAt(idx, 4);
            this._descriptionLbl.setText(desc);
        } else {
            this._descriptionLbl.setText(" ");
        }
    }

    private Box createInfoPanel() {
        Box pnl = Box.createVerticalBox();
        pnl.add(new JSeparator());
        pnl.add(this._descriptionLbl);
        pnl.add(new JSeparator());
        pnl.add(new MultipleLineLabel(i18n.INSTRUCTIONS));
        return pnl;
    }

    private static interface i18n {
        public static final String INSTRUCTIONS = s_stringMgr.getString("DriverPropertiesPanel.instructions");
    }
}

