/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.aliastransfer;

import java.util.List;
import javax.swing.JDialog;
import net.sourceforge.squirrel_sql.client.gui.db.IToogleableAliasesList;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.aliasdndtree.AliasDndTreeHandler;
import net.sourceforge.squirrel_sql.client.gui.db.aliastransfer.AliasImportUpdateDlg;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;

public class AliasImportUpdateCtrl {
    private static final String PREF_OPT_UPDATE_OLDER = "AliasImportUpdateCtrl.opt.update.older";
    private final AliasImportUpdateDlg _dlg;
    private final AliasDndTreeHandler _exportImportTreeHandler;
    private final IToogleableAliasesList _aliasesList;

    public AliasImportUpdateCtrl(JDialog parent, AliasDndTreeHandler exportImportTreeHandler, IToogleableAliasesList aliasesList) {
        this._dlg = new AliasImportUpdateDlg(parent);
        this._exportImportTreeHandler = exportImportTreeHandler;
        this._aliasesList = aliasesList;
        GUIUtils.enableCloseByEscape(this._dlg, dlg -> this.updatePrefs());
        GUIUtils.initLocation(this._dlg, 500, 180);
        boolean updateOlder = Props.getBoolean(PREF_OPT_UPDATE_OLDER, true);
        this._dlg.optUpdateOlderMatches.setSelected(updateOlder);
        this._dlg.optUpdateAllMatches.setSelected(!updateOlder);
        this._dlg.btnCancel.addActionListener(e -> this.close());
        this._dlg.btnUpdate.addActionListener(e -> this.update());
        this._dlg.setVisible(true);
    }

    private void updatePrefs() {
        Props.putBoolean(PREF_OPT_UPDATE_OLDER, this._dlg.optUpdateOlderMatches.isSelected());
    }

    private void update() {
        List<SQLAlias> sqlAliasList = this._exportImportTreeHandler.getSqlAliasList();
        List<SQLAlias> updatedAliases = this._aliasesList.updateAliasesByImport(sqlAliasList, this._dlg.optUpdateOlderMatches.isSelected());
        this._exportImportTreeHandler.removeAliases(updatedAliases);
        this.close();
    }

    private void close() {
        this.updatePrefs();
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }
}

