/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.aliastransfer;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.AliasFolderState;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesAndDriversManager;
import net.sourceforge.squirrel_sql.client.gui.db.IToogleableAliasesList;
import net.sourceforge.squirrel_sql.client.gui.db.Java8CloseableFix;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.aliasdndtree.AliasDndTreeHandler;
import net.sourceforge.squirrel_sql.client.gui.db.aliastransfer.AliasImportUpdateCtrl;
import net.sourceforge.squirrel_sql.client.gui.db.aliastransfer.AliasTransferDlg;
import net.sourceforge.squirrel_sql.client.gui.db.aliastransfer.AssignDriversCtrl;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.DesktopUtil;
import net.sourceforge.squirrel_sql.fw.util.FileExtensionFilter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;

public class AliasTransferCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasTransferCtrl.class);
    private static final String PREF_LAST_EXPORT_FILE_DIR = "AliasTransferCtrl.last.export.file.dir";
    private static final String ZIP_ENTRY_SQL_ALIASES = "export_SQLAliases23.xml";
    private static final String ZIP_ENTRY_ALIAS_TREE = "export_SQLAliases23_treeStructure.xml";
    private static final String ZIP_ENTRY_DRIVER_IDENTIFIER_TO_NAME = "export_driverIdentifierToName.props";
    private final AliasTransferDlg _dlg;
    private IToogleableAliasesList _aliasesList;

    public AliasTransferCtrl(IToogleableAliasesList aliasesList) {
        this._aliasesList = aliasesList;
        this._dlg = new AliasTransferDlg(Main.getApplication().getMainFrame());
        this.locateDialogBesidesAliases();
        AliasDndTreeHandler exportImportTreeHandler = new AliasDndTreeHandler(this._dlg.treeExportedAliases);
        this._dlg.btnExport.addActionListener(e -> this.onExport(exportImportTreeHandler));
        this._dlg.btnImport.addActionListener(e -> this.onImport(exportImportTreeHandler));
        this._dlg.btnUpdate.addActionListener(e -> this.onUpdate(exportImportTreeHandler));
        this._dlg.btnUpdate.setEnabled(false);
        GUIUtils.enableCloseByEscape(this._dlg);
        this._dlg.setVisible(true);
    }

    private void onUpdate(AliasDndTreeHandler exportImportTreeHandler) {
        new AliasImportUpdateCtrl(this._dlg, exportImportTreeHandler, this._aliasesList);
    }

    private void onImport(AliasDndTreeHandler exportImportTreeHandler) {
        JFileChooser importFC = this.createFileChooser();
        importFC.setDialogTitle(s_stringMgr.getString("AliasTransferCtrl.import.file.dialog.title"));
        if (importFC.showOpenDialog(this._dlg) != 0) {
            return;
        }
        File importFile = importFC.getSelectedFile();
        Props.putString(PREF_LAST_EXPORT_FILE_DIR, importFile.getParent());
        try (ZipFile zipIn = new ZipFile(importFile);
             Java8CloseableFix dum = Main.getApplication().getGlobalSQLAliasVersioner().switchOff();){
            Enumeration<? extends ZipEntry> entries = zipIn.entries();
            XMLBeanReader sqlAliasesReader = null;
            XMLBeanReader treeFolderStateReader = null;
            Properties driverIdentifierToName = null;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (ZIP_ENTRY_SQL_ALIASES.equals(entry.getName())) {
                    sqlAliasesReader = new XMLBeanReader();
                    sqlAliasesReader.load(zipIn.getInputStream(entry));
                    continue;
                }
                if (ZIP_ENTRY_ALIAS_TREE.equals(entry.getName())) {
                    treeFolderStateReader = new XMLBeanReader();
                    treeFolderStateReader.load(zipIn.getInputStream(entry));
                    continue;
                }
                if (ZIP_ENTRY_DRIVER_IDENTIFIER_TO_NAME.equals(entry.getName())) {
                    driverIdentifierToName = new Properties();
                    InputStreamReader rdr = new InputStreamReader(zipIn.getInputStream(entry));
                    try {
                        driverIdentifierToName.load(rdr);
                        continue;
                    }
                    finally {
                        rdr.close();
                        continue;
                    }
                }
                throw new IllegalStateException("Unexpected zip entry: " + entry.getName());
            }
            if (null == sqlAliasesReader) {
                throw new IllegalStateException("Zip did not contain: export_SQLAliases23.xml");
            }
            if (null == treeFolderStateReader) {
                throw new IllegalStateException("Zip did not contain: export_SQLAliases23_treeStructure.xml");
            }
            if (null == driverIdentifierToName) {
                throw new IllegalStateException("Zip did not contain: export_driverIdentifierToName.props");
            }
            List<SQLAlias> sqlAliases = sqlAliasesReader.getBeans();
            AssignDriversCtrl assignDriversCtrl = new AssignDriversCtrl(driverIdentifierToName, sqlAliases, this._dlg);
            if (!assignDriversCtrl.areAllDriversAssigned()) {
                return;
            }
            assignDriversCtrl.updateDriverIdentifiersInAliases(sqlAliases, assignDriversCtrl);
            AliasFolderState aliasFolderState = (AliasFolderState)treeFolderStateReader.getBeans().get(0);
            exportImportTreeHandler.load(sqlAliases, aliasFolderState);
            this._dlg.btnUpdate.setEnabled(true);
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private void onExport(AliasDndTreeHandler exportImportTreeHandler) {
        try {
            if (exportImportTreeHandler.isEmpty()) {
                JOptionPane.showMessageDialog(this._dlg, s_stringMgr.getString("AliasTransferCtrl.no.aliases.to.export"));
                return;
            }
            JFileChooser exportFC = this.createFileChooser();
            exportFC.setDialogTitle(s_stringMgr.getString("AliasTransferCtrl.export.file.dialog.title"));
            if (exportFC.showSaveDialog(this._dlg) != 0) {
                return;
            }
            File exportFile = exportFC.getSelectedFile();
            Props.putString(PREF_LAST_EXPORT_FILE_DIR, exportFile.getParent());
            if (!exportFile.getName().toLowerCase().endsWith(".zip")) {
                exportFile = new File(exportFile.getAbsolutePath() + ".zip");
            }
            List<SQLAlias> sqlAliasesToExport = exportImportTreeHandler.getSqlAliasList();
            XMLBeanWriter sqlAliasesWriter = new XMLBeanWriter();
            sqlAliasesWriter.addIteratorToRoot(sqlAliasesToExport.iterator());
            AliasFolderState state = exportImportTreeHandler.getAliasFolderState();
            XMLBeanWriter treeFolderStateWriter = new XMLBeanWriter(state);
            try (FileOutputStream fileOutputStream = new FileOutputStream(exportFile);
                 ZipOutputStream zipOut = new ZipOutputStream(fileOutputStream);){
                this.writeXMLBeanZipEntry(zipOut, sqlAliasesWriter, ZIP_ENTRY_SQL_ALIASES);
                this.writeXMLBeanZipEntry(zipOut, treeFolderStateWriter, ZIP_ENTRY_ALIAS_TREE);
                this.writeDriverIdentifierToNamePropZipEntry(sqlAliasesToExport, zipOut);
                zipOut.flush();
                fileOutputStream.flush();
            }
            Main.getApplication().getMessageHandler().showMessage(s_stringMgr.getString("AliasTransferCtrl.file.export.success.msg", exportFile.getAbsolutePath()));
            Object[] selectionValues = new String[]{s_stringMgr.getString("AliasTransferCtrl.export.completed.ok"), s_stringMgr.getString("AliasTransferCtrl.export.completed.ok.show.in.file.manager")};
            int selectIndex = JOptionPane.showOptionDialog(this._dlg, s_stringMgr.getString("AliasTransferCtrl.file.export.success.dlg.msg", exportFile.getAbsolutePath()), s_stringMgr.getString("AliasTransferCtrl.file.export.success.dlg.title"), -1, 1, null, selectionValues, selectionValues[0]);
            if (selectIndex == 1) {
                DesktopUtil.openInFileManager(exportFile);
            }
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private void writeDriverIdentifierToNamePropZipEntry(List<SQLAlias> sqlAliasesToExport, ZipOutputStream zipOut) throws IOException {
        Properties props = this.createDriverIdentifierToNameProps(sqlAliasesToExport);
        ZipEntry zipEntry = new ZipEntry(ZIP_ENTRY_DRIVER_IDENTIFIER_TO_NAME);
        zipOut.putNextEntry(zipEntry);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        props.store(bos, "JBCD-Driver identifier to driver name");
        zipOut.write(bos.toByteArray());
        zipOut.flush();
        zipOut.closeEntry();
    }

    private Properties createDriverIdentifierToNameProps(List<SQLAlias> sqlAliasesToExport) {
        Properties ret = new Properties();
        AliasesAndDriversManager aliasesAndDriversManager = Main.getApplication().getAliasesAndDriversManager();
        for (SQLAlias a : sqlAliasesToExport) {
            ISQLDriver driver = aliasesAndDriversManager.getDriver(a.getDriverIdentifier());
            String driverName = "<<undefined>>";
            if (null != driver) {
                driverName = driver.getName();
            }
            ret.put(a.getDriverIdentifier().toString(), driverName);
        }
        return ret;
    }

    private JFileChooser createFileChooser() {
        JFileChooser exportFC = new JFileChooser(Props.getString(PREF_LAST_EXPORT_FILE_DIR, System.getProperty("user.home")));
        for (FileFilter chooseableFileFilter : exportFC.getChoosableFileFilters()) {
            exportFC.removeChoosableFileFilter(chooseableFileFilter);
        }
        FileExtensionFilter zipFilter = new FileExtensionFilter("Export zip files", new String[]{".zip"});
        exportFC.addChoosableFileFilter(zipFilter);
        return exportFC;
    }

    private void writeXMLBeanZipEntry(ZipOutputStream zipOut, XMLBeanWriter xmlBeanWriter, String fileNameInZip) throws IOException {
        ZipEntry zipEntry = new ZipEntry(fileNameInZip);
        zipOut.putNextEntry(zipEntry);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        xmlBeanWriter.saveToOutputStream(bos);
        zipOut.write(bos.toByteArray());
        zipOut.flush();
        zipOut.closeEntry();
    }

    private void locateDialogBesidesAliases() {
        Point locOnScreen = GUIUtils.getScreenLocationFor(this._aliasesList.getComponent());
        int x = locOnScreen.x + this._aliasesList.getComponent().getWidth() + new JSplitPane().getDividerSize();
        Rectangle boundsOnScreen = new Rectangle(x, locOnScreen.y, Math.max(this._aliasesList.getComponent().getWidth(), 400), this._aliasesList.getComponent().getHeight());
        this._dlg.setBounds(boundsOnScreen);
    }
}

