/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.aliastransfer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.aliastransfer.AssignDriversDlg;
import net.sourceforge.squirrel_sql.client.gui.db.aliastransfer.ImportDriver;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.SimpleDataSet;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.persist.ValidationException;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriver;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class AssignDriversCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AssignDriversCtrl.class);
    private final AssignDriversDlg _dlg;
    private boolean _ok;

    public AssignDriversCtrl(Properties driverIdentifierToName, List<SQLAlias> sqlAliases, JDialog parent) {
        try {
            this._dlg = new AssignDriversDlg(parent);
            ArrayList<SQLDriver> sqlDriversSorted = new ArrayList<SQLDriver>(Main.getApplication().getAliasesAndDriversManager().getDriverList());
            sqlDriversSorted.sort(Comparator.comparing(SQLDriver::getName));
            DefaultComboBoxModel availableDriversModel = (DefaultComboBoxModel)this._dlg.cboAvailableDrivers.getModel();
            sqlDriversSorted.forEach(d -> availableDriversModel.addElement(d));
            List<ImportDriver> importDrivers = ImportDriver.create(driverIdentifierToName);
            DefaultComboBoxModel importDriversModel = (DefaultComboBoxModel)this._dlg.cboDriversToAssign.getModel();
            importDrivers.forEach(d -> importDriversModel.addElement(d));
            this.initializeTableAndSuggestAssignments(sqlDriversSorted, importDrivers, importDriversModel);
            this._dlg.btnOk.addActionListener(e -> this.onOk());
            this._dlg.btnCancel.addActionListener(e -> this.close());
            this._dlg.btnAssign.addActionListener(e -> this.onAssign());
            this._dlg.btnUnassign.addActionListener(e -> this.onUnassign());
            GUIUtils.initLocation(this._dlg, 500, 500);
            GUIUtils.enableCloseByEscape(this._dlg);
            this._dlg.setVisible(true);
        }
        catch (DataSetException e2) {
            throw Utilities.wrapRuntime(e2);
        }
    }

    private void initializeTableAndSuggestAssignments(List<SQLDriver> sqlDriversSorted, List<ImportDriver> importDrivers, DefaultComboBoxModel<ImportDriver> importDriversModel) throws DataSetException {
        ColumnDisplayDefinition[] columnDisplayDefinitions = new ColumnDisplayDefinition[]{new ColumnDisplayDefinition(50, s_stringMgr.getString("AssignDriversCtrl.tbl.column.assignment.target")), new ColumnDisplayDefinition(51, s_stringMgr.getString("AssignDriversCtrl.tbl.column.assignment.source"))};
        ArrayList<Object[]> allRows = new ArrayList<Object[]>();
        SimpleDataSet assignedDriversDataSet = new SimpleDataSet(allRows, columnDisplayDefinitions);
        for (SQLDriver sqlDriver : sqlDriversSorted) {
            for (ImportDriver importDriver : importDrivers) {
                if (!importDriver.getDriverIdentifier().equals(sqlDriver.getIdentifier().toString())) continue;
                allRows.add(this.createTableRow(sqlDriver, importDriver));
                importDriversModel.removeElement(importDriver);
            }
        }
        this._dlg.tblAssignedDrivers.show(assignedDriversDataSet);
    }

    private Object[] createTableRow(SQLDriver sqlDriver, ImportDriver importDriver) {
        return new Object[]{sqlDriver, importDriver};
    }

    private ImportDriver getImportDriver(Object[] tableRow) {
        return (ImportDriver)tableRow[1];
    }

    private SQLDriver getSqlDriver(Object[] tableRow) {
        return (SQLDriver)tableRow[0];
    }

    private void onUnassign() {
        int[] selectedModelRows;
        ArrayList<ImportDriver> allUnassignedDrivers = new ArrayList<ImportDriver>();
        DefaultComboBoxModel unassignedCboModel = (DefaultComboBoxModel)this._dlg.cboDriversToAssign.getModel();
        for (int i = 0; i < unassignedCboModel.getSize(); ++i) {
            allUnassignedDrivers.add((ImportDriver)unassignedCboModel.getElementAt(i));
        }
        ImportDriver toSelectInCbo = null;
        for (int selectedModelRow : selectedModelRows = this._dlg.tblAssignedDrivers.getSelectedModelRows()) {
            Object[] row = this._dlg.tblAssignedDrivers.getTable().getDataSetViewerTableModel().getRowAt(selectedModelRow);
            allUnassignedDrivers.add(this.getImportDriver(row));
            toSelectInCbo = this.getImportDriver(row);
        }
        allUnassignedDrivers.sort(Comparator.comparing(importDriver -> importDriver.getDriverName()));
        unassignedCboModel.removeAllElements();
        allUnassignedDrivers.forEach(importDriver -> unassignedCboModel.addElement(importDriver));
        if (null != toSelectInCbo) {
            unassignedCboModel.setSelectedItem(toSelectInCbo);
        }
        this._dlg.tblAssignedDrivers.getTable().getDataSetViewerTableModel().deleteRows(selectedModelRows);
        this._dlg.tblAssignedDrivers.getTable().getSortableTableModel().fireTableDataChanged();
    }

    private void onAssign() {
        ImportDriver selectedImportDriver = (ImportDriver)this._dlg.cboDriversToAssign.getSelectedItem();
        SQLDriver targetDriver = (SQLDriver)this._dlg.cboAvailableDrivers.getSelectedItem();
        if (null == selectedImportDriver || null == targetDriver) {
            return;
        }
        this._dlg.cboDriversToAssign.removeItem(selectedImportDriver);
        Object[] newTableRow = this.createTableRow(targetDriver, selectedImportDriver);
        this._dlg.tblAssignedDrivers.getTable().getDataSetViewerTableModel().addRow(newTableRow);
        this._dlg.tblAssignedDrivers.getTable().getDataSetViewerTableModel().allRowsAdded();
        this._dlg.tblAssignedDrivers.getTable().getSortableTableModel().fireTableDataChanged();
    }

    private void onOk() {
        int res;
        if (0 < this._dlg.cboDriversToAssign.getModel().getSize() && (res = JOptionPane.showConfirmDialog(this._dlg, s_stringMgr.getString("AssignDriversCtrl.msg.not.all.drivers.assigned.quest.cancel.import"))) != 0) {
            return;
        }
        this._ok = true;
        this.close();
    }

    private void close() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    public boolean areAllDriversAssigned() {
        return this._ok && 0 == this._dlg.cboDriversToAssign.getModel().getSize();
    }

    public void updateDriverIdentifiersInAliases(List<SQLAlias> sqlAliases, AssignDriversCtrl assignDriversCtrl) throws ValidationException {
        HashMap<String, IIdentifier> oldIdentifierStringToNewIdentifier = assignDriversCtrl.getOldIdentifierStringToNewIdentifier();
        for (SQLAlias sqlAlias : sqlAliases) {
            IIdentifier newIdentifier = oldIdentifierStringToNewIdentifier.get(sqlAlias.getDriverIdentifier().toString());
            sqlAlias.setDriverIdentifier(newIdentifier);
        }
    }

    private HashMap<String, IIdentifier> getOldIdentifierStringToNewIdentifier() {
        DataSetViewerTableModel tm = this._dlg.tblAssignedDrivers.getTable().getDataSetViewerTableModel();
        HashMap<String, IIdentifier> ret = new HashMap<String, IIdentifier>();
        for (int i = 0; i < tm.getRowCount(); ++i) {
            Object[] row = tm.getRowAt(i);
            ImportDriver importDriver = this.getImportDriver(row);
            SQLDriver sqlDriver = this.getSqlDriver(row);
            ret.put(importDriver.getDriverIdentifier(), sqlDriver.getIdentifier());
        }
        return ret;
    }
}

