/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.listholder;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.listholder.ListHolder;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener;
import net.sourceforge.squirrel_sql.fw.util.ObjectCacheChangeEvent;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;

public class AliasListHolder
implements ListHolder {
    private static ILogger s_log = LoggerController.createLogger(AliasListHolder.class);
    private List<SQLAlias> _sqlAliases = new ArrayList<SQLAlias>();
    private ArrayList<IObjectCacheChangeListener> _listeners = new ArrayList();

    public SQLAlias get(IIdentifier id) {
        return this._sqlAliases.stream().filter(a -> Utilities.equalsRespectNull(id, a.getIdentifier())).findFirst().orElse(null);
    }

    public List<SQLAlias> getAll() {
        return new ArrayList<SQLAlias>(this._sqlAliases);
    }

    public void add(SQLAlias alias) {
        if (this._sqlAliases.contains(alias)) {
            return;
        }
        this._sqlAliases.add(alias);
        new ArrayList<IObjectCacheChangeListener>(this._listeners).forEach(l -> l.objectAdded(new ObjectCacheChangeEvent(alias)));
    }

    public void remove(IIdentifier identifier) {
        SQLAlias sqlAlias = this.get(identifier);
        if (null != sqlAlias) {
            this._sqlAliases.remove(sqlAlias);
            new ArrayList<IObjectCacheChangeListener>(this._listeners).forEach(l -> l.objectRemoved(new ObjectCacheChangeEvent(sqlAlias)));
        }
    }

    public void addChangesListener(IObjectCacheChangeListener lis) {
        this._listeners.remove(lis);
        this._listeners.add(lis);
    }

    public void removeChangesListener(IObjectCacheChangeListener lis) {
        this._listeners.remove(lis);
    }

    public void load(File aliasesFile) {
        try {
            if (!aliasesFile.exists()) {
                return;
            }
            XMLBeanReader xmlBeanReader = new XMLBeanReader();
            xmlBeanReader.load(aliasesFile, this.getClass().getClassLoader());
            for (Object bean : xmlBeanReader.getBeans()) {
                SQLAlias sqlAlias = (SQLAlias)bean;
                if (this._sqlAliases.contains(sqlAlias)) continue;
                this._sqlAliases.add(sqlAlias);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            s_log.error(e);
            throw Utilities.wrapRuntime(e);
        }
    }

    @Override
    public void save(String path) {
        try {
            XMLBeanWriter xmlBeanWriter = new XMLBeanWriter();
            xmlBeanWriter.addIteratorToRoot(this._sqlAliases.iterator());
            xmlBeanWriter.save(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            s_log.error(e);
            throw Utilities.wrapRuntime(e);
        }
    }
}

