/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.listholder;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.gui.db.listholder.ListHolder;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriver;
import net.sourceforge.squirrel_sql.fw.util.IObjectCacheChangeListener;
import net.sourceforge.squirrel_sql.fw.util.ObjectCacheChangeEvent;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;

public class DriverListHolder
implements ListHolder {
    private static ILogger s_log = LoggerController.createLogger(DriverListHolder.class);
    private List<SQLDriver> _sqlDrivers = new ArrayList<SQLDriver>();
    private ArrayList<IObjectCacheChangeListener> _listeners = new ArrayList();

    public SQLDriver get(IIdentifier id) {
        return this._sqlDrivers.stream().filter(d -> Utilities.equalsRespectNull(id, d.getIdentifier())).findFirst().orElse(null);
    }

    public void add(ISQLDriver sqlDriver) {
        if (this._sqlDrivers.contains(sqlDriver)) {
            return;
        }
        this._sqlDrivers.add((SQLDriver)sqlDriver);
        new ArrayList<IObjectCacheChangeListener>(this._listeners).forEach(l -> l.objectAdded(new ObjectCacheChangeEvent(sqlDriver)));
    }

    public void remove(IIdentifier identifier) {
        SQLDriver sqlDriver = this.get(identifier);
        if (null != sqlDriver) {
            this._sqlDrivers.remove(sqlDriver);
            new ArrayList<IObjectCacheChangeListener>(this._listeners).forEach(l -> l.objectRemoved(new ObjectCacheChangeEvent(sqlDriver)));
        }
    }

    public List<SQLDriver> getAll() {
        return new ArrayList<SQLDriver>(this._sqlDrivers);
    }

    public void addChangesListener(IObjectCacheChangeListener lis) {
        this._listeners.remove(lis);
        this._listeners.add(lis);
    }

    public void removeChangesListener(IObjectCacheChangeListener lis) {
        this._listeners.remove(lis);
    }

    public void load(File driversFile) {
        if (!driversFile.exists()) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(driversFile);){
            this.load(fis);
        }
        catch (Exception e) {
            e.printStackTrace();
            s_log.error(e);
            throw Utilities.wrapRuntime(e);
        }
    }

    public void load(InputStream is) {
        try {
            XMLBeanReader xmlBeanReader = new XMLBeanReader();
            xmlBeanReader.load(is, this.getClass().getClassLoader());
            for (Object bean : xmlBeanReader.getBeans()) {
                SQLDriver sqlDriver = (SQLDriver)bean;
                if (this._sqlDrivers.contains(sqlDriver)) continue;
                this._sqlDrivers.add(sqlDriver);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            s_log.error(e);
            throw Utilities.wrapRuntime(e);
        }
    }

    @Override
    public void save(String path) {
        try {
            XMLBeanWriter xmlBeanWriter = new XMLBeanWriter();
            xmlBeanWriter.addIteratorToRoot(this._sqlDrivers.iterator());
            xmlBeanWriter.save(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            s_log.error(e);
            throw Utilities.wrapRuntime(e);
        }
    }
}

