/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.modifyaliases;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Objects;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAliasProp;
import net.sourceforge.squirrel_sql.client.gui.db.modifyaliases.AliasChangesHandler;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import org.apache.commons.lang3.StringUtils;

public class AliasChangesFinder {
    public static AliasChangesHandler findChanges(SQLAlias uneditedAlias, SQLAlias editedAlias) {
        AliasChangesHandler changesHandler = new AliasChangesHandler();
        AliasChangesFinder._findChanges(uneditedAlias, editedAlias, changesHandler);
        return changesHandler;
    }

    private static void _findChanges(Object unedited, Object edited, AliasChangesHandler changesHandler) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            if (!Objects.equals(unedited.getClass(), edited.getClass())) {
                String msg = "unedited(class=" + unedited.getClass().getName() + ") and edited(class=" + edited.getClass().getName() + ") are of different classes.";
                throw new IllegalArgumentException(msg);
            }
            BeanInfo beanInfo = Introspector.getBeanInfo(unedited.getClass());
            for (PropertyDescriptor pd : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Annotation[] annotations;
                if (!pd.getPropertyType().isPrimitive() && StringUtils.containsIgnoreCase((CharSequence)pd.getPropertyType().getTypeName(), (CharSequence)"squirrel")) {
                    AliasChangesFinder._findChanges(pd.getReadMethod().invoke(unedited, new Object[0]), pd.getReadMethod().invoke(edited, new Object[0]), changesHandler);
                }
                Method getter = pd.getReadMethod();
                for (Annotation annotation : annotations = getter.getDeclaredAnnotations()) {
                    if (!(annotation instanceof SQLAliasProp)) continue;
                    SQLAliasProp sqlAliasProp = (SQLAliasProp)annotation;
                    Object uneditedAliasPropValue = getter.invoke(unedited, new Object[0]);
                    Object editedAliasPropValue = getter.invoke(edited, new Object[0]);
                    if (sqlAliasProp.sqlAliasPropType().equals(uneditedAliasPropValue, editedAliasPropValue)) continue;
                    changesHandler.addChange(sqlAliasProp.sqlAliasPropType(), pd, uneditedAliasPropValue, editedAliasPropValue);
                }
            }
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }
}

