/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.modifyaliases;

import java.awt.Color;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAliasSchemaDetailProperties;
import net.sourceforge.squirrel_sql.client.gui.db.modifyaliases.AliasChange;
import net.sourceforge.squirrel_sql.client.gui.db.modifyaliases.AliasChangesUtil;
import net.sourceforge.squirrel_sql.client.gui.db.modifyaliases.ChangeReport;
import net.sourceforge.squirrel_sql.client.gui.db.modifyaliases.SQLAliasPropType;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverPropertyCollection;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class AliasChangesHandler {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AliasChangesHandler.class);
    public static final String I18N_ALIAS_CHANGES_HANDLER_CHANGE_FROM_TO = "AliasChangesHandler.changeFromTo";
    private ChangeReport _changeReport = new ChangeReport();
    private List<AliasChange> _aliasChanges = new ArrayList<AliasChange>();
    private boolean _schemaTableWasCleared;

    public boolean isEmpty() {
        return 0 == this._changeReport.length();
    }

    public ChangeReport getChangeReport() {
        return this._changeReport;
    }

    public void addChange(SQLAliasPropType sqlAliasPropType, PropertyDescriptor pd, Object uneditedAliasPropValue, Object editedAliasPropValue) {
        this._aliasChanges.add(new AliasChange(pd, sqlAliasPropType, editedAliasPropValue));
        this._changeReport.append(sqlAliasPropType.isNested() ? "   " : "");
        if (sqlAliasPropType.isSchemaProp()) {
            this.writeSchemaPropertyChangeReport(sqlAliasPropType, uneditedAliasPropValue, editedAliasPropValue);
        } else if (sqlAliasPropType.isDriverProp()) {
            this.writeDriverPropertyChangeReport(sqlAliasPropType, uneditedAliasPropValue, editedAliasPropValue);
        } else if (sqlAliasPropType.isColorProp()) {
            this.writeColorPropertyChangeReport(sqlAliasPropType, uneditedAliasPropValue, editedAliasPropValue);
        } else if (sqlAliasPropType.isConnectionProp()) {
            this.writeConnectionPropertyChangeReport(sqlAliasPropType, uneditedAliasPropValue, editedAliasPropValue);
        } else {
            this.writeAliasPropertyChangeReport(sqlAliasPropType, uneditedAliasPropValue, editedAliasPropValue);
        }
    }

    private void writeAliasPropertyChangeReport(SQLAliasPropType sqlAliasPropType, Object uneditedAliasPropValue, Object editedAliasPropValue) {
        this._changeReport.append(s_stringMgr.getString("AliasChangesHandler.alias.prefix")).append(" ");
        String changeMsg = sqlAliasPropType == SQLAliasPropType.driverIdentifier ? s_stringMgr.getString(I18N_ALIAS_CHANGES_HANDLER_CHANGE_FROM_TO, sqlAliasPropType.getI18nString(), this.getDriverNameByIdentifier((IIdentifier)uneditedAliasPropValue), this.getDriverNameByIdentifier((IIdentifier)editedAliasPropValue)) : s_stringMgr.getString(I18N_ALIAS_CHANGES_HANDLER_CHANGE_FROM_TO, sqlAliasPropType.getI18nString(), uneditedAliasPropValue, editedAliasPropValue);
        this._changeReport.append(changeMsg).append('\n');
    }

    private Object getDriverNameByIdentifier(IIdentifier driverIdentifier) {
        if (null == driverIdentifier) {
            return "<null>";
        }
        return Main.getApplication().getAliasesAndDriversManager().getDriver(driverIdentifier).getName();
    }

    private void writeConnectionPropertyChangeReport(SQLAliasPropType sqlAliasPropType, Object uneditedAliasPropValue, Object editedAliasPropValue) {
        String changeMsg;
        if (sqlAliasPropType == SQLAliasPropType.connectionProp_keepAliveSqlStatement) {
            this._changeReport.append(s_stringMgr.getString("AliasChangesUtil.driverProp.prefix")).append(" ");
            changeMsg = s_stringMgr.getString(I18N_ALIAS_CHANGES_HANDLER_CHANGE_FROM_TO, s_stringMgr.getString("AliasChangesHandler.connectionProp.keepAliveSql"), uneditedAliasPropValue, editedAliasPropValue);
        } else {
            this._changeReport.append(s_stringMgr.getString("AliasChangesUtil.driverProp.prefix")).append(" ");
            changeMsg = s_stringMgr.getString(I18N_ALIAS_CHANGES_HANDLER_CHANGE_FROM_TO, sqlAliasPropType.getI18nString(), uneditedAliasPropValue, editedAliasPropValue);
        }
        this._changeReport.append(changeMsg).append('\n');
    }

    private void writeDriverPropertyChangeReport(SQLAliasPropType sqlAliasPropType, Object previousAliasPropValue, Object editedAliasPropValue) {
        if (sqlAliasPropType == SQLAliasPropType.driverProp_useDriverProperties) {
            this._changeReport.append(s_stringMgr.getString("AliasChangesUtil.driverProp.prefix")).append(" ");
            String changeMsg = s_stringMgr.getString(I18N_ALIAS_CHANGES_HANDLER_CHANGE_FROM_TO, sqlAliasPropType.getI18nString(), previousAliasPropValue, editedAliasPropValue);
            this._changeReport.append(changeMsg).append('\n');
        } else if (sqlAliasPropType == SQLAliasPropType.driverProp_driverPropertyCollection) {
            AliasChangesUtil.compareSQLDriverPropertyCollection((SQLDriverPropertyCollection)previousAliasPropValue, (SQLDriverPropertyCollection)editedAliasPropValue, this._changeReport);
        }
    }

    private void writeSchemaPropertyChangeReport(SQLAliasPropType sqlAliasPropType, Object uneditedAliasPropValue, Object editedAliasPropValue) {
        if (sqlAliasPropType == SQLAliasPropType.schemaProp_globalState) {
            this._changeReport.append(s_stringMgr.getString("AliasChangesUtil.schemaProp.prefix")).append(" ");
            String changeMsg = s_stringMgr.getString("AliasChangesHandler.globalState.changeFromTo", AliasChangesHandler.getGlobalSchemaLoadingState((Integer)uneditedAliasPropValue), AliasChangesHandler.getGlobalSchemaLoadingState((Integer)editedAliasPropValue));
            this._changeReport.append(changeMsg).append('\n');
        } else if (sqlAliasPropType == SQLAliasPropType.schemaProp_schemaDetails) {
            SQLAliasSchemaDetailProperties[] uneditedSchemaDetails = (SQLAliasSchemaDetailProperties[])uneditedAliasPropValue;
            SQLAliasSchemaDetailProperties[] editedSchemaDetails = (SQLAliasSchemaDetailProperties[])editedAliasPropValue;
            AliasChangesUtil.compareSchemaDetailProperties(editedSchemaDetails, uneditedSchemaDetails, this._changeReport);
        } else if (sqlAliasPropType == SQLAliasPropType.schemaProp_schemaTableWasCleared_transientForMultiAliasModificationOnly) {
            if (((Boolean)editedAliasPropValue).booleanValue()) {
                this._schemaTableWasCleared = true;
                this._changeReport.append(s_stringMgr.getString("AliasChangesUtil.schemaProp.prefix")).append(" ");
                this._changeReport.append(s_stringMgr.getString("AliasChangesHandler.aliasBackground.color.prop.schemaTableWasCleared")).append('\n');
            }
        } else {
            this._changeReport.append(s_stringMgr.getString("AliasChangesUtil.schemaProp.prefix")).append(" ");
            String changeMsg = s_stringMgr.getString(I18N_ALIAS_CHANGES_HANDLER_CHANGE_FROM_TO, sqlAliasPropType.getI18nString(), uneditedAliasPropValue, editedAliasPropValue);
            this._changeReport.append(changeMsg).append('\n');
        }
    }

    private static String getGlobalSchemaLoadingState(Integer globalSchemaLoadingState) {
        String previousGlobalState;
        switch (globalSchemaLoadingState) {
            case 0: {
                previousGlobalState = s_stringMgr.getString("AliasChangesHandler.GLOBAL_STATE_LOAD_ALL_CACHE_NONE");
                break;
            }
            case 1: {
                previousGlobalState = s_stringMgr.getString("AliasChangesHandler.GLOBAL_STATE_LOAD_AND_CACHE_ALL");
                break;
            }
            case 3: {
                previousGlobalState = s_stringMgr.getString("AliasChangesHandler.GLOBAL_STATE_SPECIFY_SCHEMAS_BY_LIKE_STRING");
                break;
            }
            case 2: {
                previousGlobalState = s_stringMgr.getString("AliasChangesHandler.GLOBAL_STATE_SPECIFY_SCHEMAS");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Global schema loading and caching state");
            }
        }
        return previousGlobalState;
    }

    private void writeColorPropertyChangeReport(SQLAliasPropType sqlAliasPropType, Object uneditedAliasPropValue, Object editedAliasPropValue) {
        this._changeReport.append(s_stringMgr.getString("AliasChangesHandler.color.prop.prefix")).append(" ");
        if (sqlAliasPropType == SQLAliasPropType.colorProp_overrideToolbarBackgroundColor) {
            this._changeReport.append(s_stringMgr.getString("AliasChangesHandler.toolbarBackground.color.prop.override.changeFromTo", uneditedAliasPropValue, editedAliasPropValue));
        } else if (sqlAliasPropType == SQLAliasPropType.colorProp_toolbarBackgroundColor) {
            this._changeReport.append(s_stringMgr.getString("AliasChangesHandler.toolbarBackground.color.prop.changeFromTo", new Color((Integer)uneditedAliasPropValue), new Color((Integer)editedAliasPropValue)));
        } else if (sqlAliasPropType == SQLAliasPropType.colorProp_overrideObjectTreeBackgroundColor) {
            this._changeReport.append(s_stringMgr.getString("AliasChangesHandler.objectTreeBackground.color.prop.override.changeFromTo", uneditedAliasPropValue, editedAliasPropValue));
        } else if (sqlAliasPropType == SQLAliasPropType.colorProp_objectTreeBackgroundColor) {
            this._changeReport.append(s_stringMgr.getString("AliasChangesHandler.objectTreeBackground.color.prop.changeFromTo", new Color((Integer)uneditedAliasPropValue), new Color((Integer)editedAliasPropValue)));
        } else if (sqlAliasPropType == SQLAliasPropType.colorProp_overrideStatusBarBackgroundColor) {
            this._changeReport.append(s_stringMgr.getString("AliasChangesHandler.statusBarBackground.color.prop.override.changeFromTo", uneditedAliasPropValue, editedAliasPropValue));
        } else if (sqlAliasPropType == SQLAliasPropType.colorProp_statusBarBackgroundColor) {
            this._changeReport.append(s_stringMgr.getString("AliasChangesHandler.statusBarBackground.color.prop.changeFromTo", new Color((Integer)uneditedAliasPropValue), new Color((Integer)editedAliasPropValue)));
        } else if (sqlAliasPropType == SQLAliasPropType.colorProp_overrideAliasBackgroundColor) {
            this._changeReport.append(s_stringMgr.getString("AliasChangesHandler.aliasBackground.color.prop.override.changeFromTo", uneditedAliasPropValue, editedAliasPropValue));
        } else if (sqlAliasPropType == SQLAliasPropType.colorProp_aliasBackgroundColor) {
            this._changeReport.append(s_stringMgr.getString("AliasChangesHandler.aliasBackground.color.prop.changeFromTo", new Color((Integer)uneditedAliasPropValue), new Color((Integer)editedAliasPropValue)));
        }
        this._changeReport.append('\n');
    }

    public void applyChanges(SQLAlias newSelectedAlias) {
        this._aliasChanges.forEach(aliasChange -> aliasChange.applyChange(newSelectedAlias));
        if (this._schemaTableWasCleared) {
            newSelectedAlias.getSchemaProperties().setSchemaDetails(new SQLAliasSchemaDetailProperties[0]);
        }
    }
}

