/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.modifyaliases;

import java.awt.Window;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.AliasInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.AliasWindowFactory;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.aliasdndtree.AliasDndTreeHandler;
import net.sourceforge.squirrel_sql.client.gui.db.modifyaliases.AliasChangesFinder;
import net.sourceforge.squirrel_sql.client.gui.db.modifyaliases.AliasChangesHandler;
import net.sourceforge.squirrel_sql.client.gui.db.modifyaliases.ModifyMultipleAliasesDlg;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.client.util.IdentifierFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.fileexport.ProgressAbortDialog;
import net.sourceforge.squirrel_sql.fw.id.IIdentifierFactory;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.commons.lang3.StringUtils;

public class ModifyMultipleAliasesCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ModifyMultipleAliasesCtrl.class);
    private static final ILogger s_log = LoggerController.createLogger(ModifyMultipleAliasesCtrl.class);
    public static final String LOG_PREFIX_MULTIPLE_ALIASES_UPDATE = "MULTIPLE ALIASES UPDATE: ";
    private final ModifyMultipleAliasesDlg _dlg = new ModifyMultipleAliasesDlg();
    private AliasChangesHandler _aliasChangesHandler;

    public ModifyMultipleAliasesCtrl() {
        AliasDndTreeHandler modifyAliasesTreeHandler = new AliasDndTreeHandler(this._dlg.treeAliasesToModify);
        this._dlg.btnEditTemplateAlias.addActionListener(e -> this.onEditAliases(modifyAliasesTreeHandler));
        this._dlg.btnApplyChanges.addActionListener(e -> this.onApplyChanges(modifyAliasesTreeHandler));
        this._dlg.btnCancel.addActionListener(e -> this.close());
        this.updateApplyButton();
        GUIUtils.initLocation(this._dlg, 800, 800);
        GUIUtils.enableCloseByEscape(this._dlg);
        this._dlg.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onApplyChanges(AliasDndTreeHandler modifyAliasesTreeHandler) {
        File aliasesBackupFile = null;
        try {
            s_log.info("MULTIPLE ALIASES UPDATE: ##################################################################");
            s_log.info("MULTIPLE ALIASES UPDATE: ########### Start applying modifications to multiple Aliases.");
            aliasesBackupFile = this.backupAliases();
            s_log.info("MULTIPLE ALIASES UPDATE: Applying the following modifications to the Aliases named below:");
            for (String changeReportLine : this._aliasChangesHandler.getChangeReport().getString().split("\n")) {
                s_log.info(LOG_PREFIX_MULTIPLE_ALIASES_UPDATE + changeReportLine);
            }
            for (SQLAlias sqlAlias : modifyAliasesTreeHandler.getSqlAliasList()) {
                this._aliasChangesHandler.applyChanges(sqlAlias);
                Main.getApplication().getWindowManager().getAliasesListInternalFrame().getAliasesList().getAliasTreeInterface().aliasNodeChanged(sqlAlias);
                s_log.info("MULTIPLE ALIASES UPDATE: Modifying Alias: \"" + sqlAlias.getName() + "\" (internal Identifier=" + sqlAlias.getIdentifier() + ")");
            }
            s_log.info("MULTIPLE ALIASES UPDATE: ########### Finished applying modifications to multiple Aliases.");
            s_log.info("MULTIPLE ALIASES UPDATE: ##################################################################");
            String msg = s_stringMgr.getString("ModifyMultipleAliasesCtrl.success.message", new ApplicationFiles().getDatabaseAliasesFile(), aliasesBackupFile.getAbsolutePath());
            Main.getApplication().getMessageHandler().showMessage(msg);
        }
        catch (Exception e) {
            s_log.error("MULTIPLE ALIASES UPDATE: Failed to modify multiple Aliases", e);
            if (null != aliasesBackupFile) {
                String msg = s_stringMgr.getString("ModifyMultipleAliasesCtrl.fail.message.with.backup", new ApplicationFiles().getDatabaseAliasesFile(), aliasesBackupFile.getAbsolutePath());
                Main.getApplication().getMessageHandler().showErrorMessage(msg, e);
            } else {
                String msg = s_stringMgr.getString("ModifyMultipleAliasesCtrl.fail.message.without.backup", new ApplicationFiles().getDatabaseAliasesFile());
                Main.getApplication().getMessageHandler().showErrorMessage(msg, e);
            }
        }
        finally {
            this.close();
        }
    }

    private void close() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private File backupAliases() {
        ProgressAbortDialog progressAbortDialog = new ProgressAbortDialog((Window)this._dlg, s_stringMgr.getString("ModifyMultipleAliasesCtrl.alias.backup"), null);
        File[] retRef = new File[1];
        Main.getApplication().getThreadPool().addTask(() -> {
            retRef[0] = ModifyMultipleAliasesCtrl.doBackupAliases(progressAbortDialog);
        });
        progressAbortDialog.setModal(true);
        progressAbortDialog.setVisible(true);
        return retRef[0];
    }

    private static File doBackupAliases(ProgressAbortDialog progressAbortDialog) {
        try {
            progressAbortDialog.setTaskStatus(s_stringMgr.getString("ModifyMultipleAliasesCtrl.prepare.aliases.backup.begin.save.existing"));
            File aliasesFileToBackUp = Main.getApplication().saveAliases();
            progressAbortDialog.setTaskStatus(s_stringMgr.getString("ModifyMultipleAliasesCtrl.prepare.aliases.backup.finished.save.existing"));
            progressAbortDialog.setTaskStatus(s_stringMgr.getString("ModifyMultipleAliasesCtrl.preparing.aliases.backup.file"));
            String datePostfix = LocalDateTime.now().format(DateTimeFormatter.ofPattern("__yyyy-MM-dd__HH-mm-ss"));
            File databaseAliasesBackupDir = new ApplicationFiles().getDatabaseAliasesBackupDir();
            String aliasesBackupFileName = "SQLAliases23" + datePostfix + ".xml";
            databaseAliasesBackupDir.mkdirs();
            File backupFile = new File(databaseAliasesBackupDir, aliasesBackupFileName);
            progressAbortDialog.setTaskStatus(s_stringMgr.getString("ModifyMultipleAliasesCtrl.begin.write.alias.backup.file", backupFile.getAbsolutePath()));
            Files.copy(aliasesFileToBackUp.toPath(), backupFile.toPath(), new CopyOption[0]);
            s_log.info("MULTIPLE ALIASES UPDATE: Backuped Aliases file " + new ApplicationFiles().getDatabaseAliasesFile().getAbsolutePath() + " to " + backupFile.getAbsolutePath());
            progressAbortDialog.setTaskStatus(s_stringMgr.getString("ModifyMultipleAliasesCtrl.finished.write.alias.backup.file", backupFile.getAbsolutePath()));
            File[] files = databaseAliasesBackupDir.listFiles((dir, name) -> StringUtils.startsWithIgnoreCase((CharSequence)name, (CharSequence)"SQLAliases23"));
            if (10 < files.length) {
                progressAbortDialog.setTaskStatus(s_stringMgr.getString("ModifyMultipleAliasesCtrl.begin.cleaning.backups"));
                int delCount = 0;
                for (File file : files) {
                    if (file.isDirectory() || file.lastModified() >= System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L)) continue;
                    Files.delete(file.toPath());
                    ++delCount;
                }
                progressAbortDialog.setTaskStatus(s_stringMgr.getString("ModifyMultipleAliasesCtrl.finished.cleaning.backups", delCount));
            }
            File file = backupFile;
            return file;
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
        finally {
            progressAbortDialog.closeProgressDialog();
        }
    }

    private void onEditAliases(AliasDndTreeHandler modifyAliasesTreeHandler) {
        SQLAlias selectedAlias = modifyAliasesTreeHandler.getSelectedAlias();
        if (null == selectedAlias) {
            JOptionPane.showMessageDialog(this._dlg, s_stringMgr.getString("ModifyMultipleAliasesCtrl.no.alias.selected"));
            return;
        }
        IIdentifierFactory factory = IdentifierFactory.getInstance();
        SQLAlias newAliasToEdit = Main.getApplication().getAliasesAndDriversManager().createAlias(factory.createIdentifier());
        newAliasToEdit.assignFrom(selectedAlias, false);
        newAliasToEdit.getSchemaProperties().setSchemaTableWasCleared_transientForMultiAliasModificationOnly(false);
        AliasInternalFrame modifyMultipleSheet = AliasWindowFactory.getModifyMultipleSheet(newAliasToEdit, this._dlg);
        modifyMultipleSheet.setOkListener(() -> this.onAliasSheetOk(selectedAlias, newAliasToEdit));
        modifyMultipleSheet.setVisible(true);
    }

    private void onAliasSheetOk(SQLAlias uneditedAlias, SQLAlias editedAlias) {
        try {
            AliasChangesHandler aliasChangesHandler = AliasChangesFinder.findChanges(uneditedAlias, editedAlias);
            this._dlg.txtChangeReport.setText(null);
            if (!aliasChangesHandler.isEmpty()) {
                this._dlg.txtChangeReport.setText(aliasChangesHandler.getChangeReport().getString());
                this._aliasChangesHandler = aliasChangesHandler;
                this._dlg._tabbedPane.setSelectedIndex(1);
                this.updateApplyButton();
            }
        }
        catch (Exception e) {
            throw Utilities.wrapRuntime(e);
        }
    }

    private void updateApplyButton() {
        this._dlg.btnApplyChanges.setEnabled(null != this._aliasChangesHandler);
    }
}

