/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.passwordaccess;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.passwordaccess.PasswordInAliasPanel;
import net.sourceforge.squirrel_sql.fw.gui.ClipboardUtil;

public class PasswordInAliasCtrl {
    private final PasswordInAliasPanel _panel = new PasswordInAliasPanel();

    public PasswordInAliasCtrl() {
        this._panel.btnCopyPassword.setVisible(Main.getApplication().getSquirrelPreferences().getShowAliasPasswordCopyButton());
        this._panel.btnShowPassword.setVisible(Main.getApplication().getSquirrelPreferences().getShowAliasPasswordShowButton());
        this._panel.btnCopyPassword.addActionListener(e -> this.onCopyPassword());
        this._panel.btnShowPassword.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PasswordInAliasCtrl.this.showPassword();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                PasswordInAliasCtrl.this.hidePassword();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PasswordInAliasCtrl.this.hidePassword();
            }
        });
    }

    private void hidePassword() {
        this._panel.passwordPanel.removeAll();
        this._panel.txtPasswordReadable.setText(null);
        this._panel.passwordPanel.add(this._panel.txtPassword);
        this.repaintPasswordPanel();
    }

    private void showPassword() {
        this._panel.passwordPanel.removeAll();
        this._panel.txtPasswordReadable.setText(new String(this._panel.txtPassword.getPassword()));
        this._panel.passwordPanel.add(this._panel.txtPasswordReadable);
        this.repaintPasswordPanel();
    }

    private void repaintPasswordPanel() {
        this._panel.passwordPanel.invalidate();
        this._panel.passwordPanel.doLayout();
        this._panel.passwordPanel.repaint();
    }

    private void onCopyPassword() {
        ClipboardUtil.copyToClip(new String(this._panel.txtPassword.getPassword()));
    }

    public void setPassword(String password) {
        this._panel.txtPassword.setText(password);
    }

    public char[] getPassword() {
        return this._panel.txtPassword.getPassword();
    }

    public void setColumns(int columnCount) {
        this._panel.txtPassword.setColumns(columnCount);
        this._panel.txtPasswordReadable.setColumns(columnCount);
    }

    public JPanel getPanel() {
        return this._panel;
    }
}

