/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.recentalias;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.db.AliasWindowManager;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.recentalias.RecentAliasListActionProxy;
import net.sourceforge.squirrel_sql.client.gui.db.recentalias.RecentAliasesJsonBean;
import net.sourceforge.squirrel_sql.client.gui.db.recentalias.RecentAliasesListDockWidget;
import net.sourceforge.squirrel_sql.client.gui.db.recentalias.ViewInAliasesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.AliasPropertiesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.AliasPropertiesCommand;
import net.sourceforge.squirrel_sql.client.mainframe.action.ConnectToAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ConnectToAliasCommand;
import net.sourceforge.squirrel_sql.client.mainframe.action.FindAliasListCellRenderer;
import net.sourceforge.squirrel_sql.client.mainframe.action.ModifyAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.findaliases.AliasSearchWrapper;
import net.sourceforge.squirrel_sql.client.mainframe.action.findaliases.AliasesUtil;
import net.sourceforge.squirrel_sql.client.mainframe.action.findaliases.FindAliasAction;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.id.UidIdentifier;
import net.sourceforge.squirrel_sql.fw.util.JsonMarshalUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class RecentAliasesListCtrl {
    private static ILogger s_log = LoggerController.createLogger(RecentAliasesListCtrl.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RecentAliasesListCtrl.class);
    private final RecentAliasesListDockWidget _widget = new RecentAliasesListDockWidget();

    public RecentAliasesListCtrl() {
        this._widget.lstAliases.setModel(new DefaultListModel());
        this._widget.lstAliases.setCellRenderer(new FindAliasListCellRenderer());
        this._widget.lstAliases.setSelectionMode(2);
        File jsonBeanFile = new ApplicationFiles().getRecentAliasesJsonBeanFile();
        RecentAliasesJsonBean jsonBean = new RecentAliasesJsonBean();
        if (jsonBeanFile.exists()) {
            try {
                jsonBean = JsonMarshalUtil.readObjectFromFileSave(jsonBeanFile, RecentAliasesJsonBean.class, jsonBean);
            }
            catch (Exception e2) {
                s_log.error("Failed to read RecentAliasesJsonBean", e2);
            }
        }
        this._widget.txtMaxNumRecent.setInt(jsonBean.getMaxRecentAliases());
        DefaultListModel model = (DefaultListModel)this._widget.lstAliases.getModel();
        for (String recentAliasIdentifier : jsonBean.getRecentAliasesIdentifier()) {
            SQLAlias alias = this.findAlias(recentAliasIdentifier);
            if (null == alias) continue;
            model.addElement(new AliasSearchWrapper(alias));
        }
        this._widget.lstAliases.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RecentAliasesListCtrl.this.onListClicked(e);
            }
        });
        this._widget.btnClearList.addActionListener(e -> this.onClearList(model));
        this._widget.btnRemoveSelected.addActionListener(e -> this.onRemoveSelected());
        this._widget.toolBar.add(this.proxy(ConnectToAliasAction.class, e -> this.onConnect()));
        this._widget.toolBar.add(this.proxy(ModifyAliasAction.class, e -> this.onModifyAlias()));
        this._widget.toolBar.add(this.proxy(AliasPropertiesAction.class, e -> this.onAliasProperties()));
        this._widget.toolBar.add(this.proxy(FindAliasAction.class, e -> this.onFindAlias()));
        this._widget.toolBar.add(this.proxy(ViewInAliasesAction.class, e -> this.onViewInAliases()));
    }

    private RecentAliasListActionProxy proxy(Class actionClass, ActionListener actionListener) {
        return new RecentAliasListActionProxy(Main.getApplication().getActionCollection().get(actionClass), actionListener);
    }

    private void onViewInAliases() {
        SQLAlias selectedAlias = this.getSelectedAliasChecked();
        if (selectedAlias == null) {
            return;
        }
        AliasesUtil.viewInAliasesDockWidget(selectedAlias);
    }

    private void onFindAlias() {
        Main.getApplication().getActionCollection().get(FindAliasAction.class).actionPerformed(new ActionEvent(this._widget.toolBar, 0, "Dummy"));
    }

    private void onAliasProperties() {
        SQLAlias selectedAlias = this.getSelectedAliasChecked();
        if (selectedAlias == null) {
            return;
        }
        new AliasPropertiesCommand(selectedAlias).execute();
    }

    private void onModifyAlias() {
        SQLAlias selectedAlias = this.getSelectedAliasChecked();
        if (selectedAlias == null) {
            return;
        }
        AliasWindowManager.showModifyAliasInternalFrame(selectedAlias);
    }

    private void onListClicked(MouseEvent e) {
        if (2 == e.getClickCount()) {
            this.onConnect();
        }
    }

    private void onConnect() {
        SQLAlias selectedAlias = this.getSelectedAliasChecked();
        if (selectedAlias == null) {
            return;
        }
        new ConnectToAliasCommand(selectedAlias).executeConnect();
    }

    private SQLAlias getSelectedAliasChecked() {
        AliasSearchWrapper selectedAliasSearchWrapper = this._widget.lstAliases.getSelectedValue();
        if (selectedAliasSearchWrapper == null) {
            String msg = s_stringMgr.getString("RecentAliasesListCtrl.no.selected.alias");
            JOptionPane.showMessageDialog(this._widget.getContentPane(), msg);
            return null;
        }
        SQLAlias orgAlias = this.findAlias(selectedAliasSearchWrapper.getAlias().getIdentifier().toString());
        if (null == orgAlias) {
            String msg = s_stringMgr.getString("RecentAliasesListCtrl.alias.doesnt.exist");
            JOptionPane.showMessageDialog(this._widget.getContentPane(), msg);
            ((DefaultListModel)this._widget.lstAliases.getModel()).removeElement(selectedAliasSearchWrapper);
            return null;
        }
        return selectedAliasSearchWrapper.getAlias();
    }

    private void onClearList(DefaultListModel model) {
        String msg = s_stringMgr.getString("RecentAliasesListCtrl.clearList.msg");
        if (0 == JOptionPane.showConfirmDialog(this._widget.getContentPane(), msg)) {
            model.clear();
        }
    }

    private void onRemoveSelected() {
        DefaultListModel model = (DefaultListModel)this._widget.lstAliases.getModel();
        for (AliasSearchWrapper aliasSearchWrapper : this._widget.lstAliases.getSelectedValuesList()) {
            model.removeElement(aliasSearchWrapper);
        }
    }

    private SQLAlias findAlias(String aliasIdentifierString) {
        return Main.getApplication().getAliasesAndDriversManager().getAlias(new UidIdentifier(aliasIdentifierString));
    }

    public RecentAliasesListDockWidget getWidget() {
        return this._widget;
    }

    public void startingCreateSession(SQLAlias sqlAlias) {
        DefaultListModel model = (DefaultListModel)this._widget.lstAliases.getModel();
        AliasSearchWrapper aliasSearchWrapper = new AliasSearchWrapper(sqlAlias);
        int curIx = model.indexOf(aliasSearchWrapper);
        while (-1 < curIx) {
            model.remove(curIx);
            curIx = model.indexOf(aliasSearchWrapper);
        }
        model.add(0, aliasSearchWrapper);
        while (this._widget.txtMaxNumRecent.getInt() < model.size()) {
            model.removeElementAt(model.size() - 1);
        }
    }

    public void saveRecentAliases() {
        RecentAliasesJsonBean jsonBean = new RecentAliasesJsonBean();
        jsonBean.setMaxRecentAliases(this._widget.txtMaxNumRecent.getInt());
        DefaultListModel model = (DefaultListModel)this._widget.lstAliases.getModel();
        for (Object aliasSearchWrapper : model.toArray()) {
            SQLAlias alias = this.findAlias(((AliasSearchWrapper)aliasSearchWrapper).getAlias().getIdentifier().toString());
            if (null == alias) continue;
            jsonBean.getRecentAliasesIdentifier().add(alias.getIdentifier().toString());
        }
        File jsonBeanFile = new ApplicationFiles().getRecentAliasesJsonBeanFile();
        JsonMarshalUtil.writeObjectToFile(jsonBeanFile, jsonBean);
    }

    public void aliasChanged(SQLAlias sqlAlias) {
        this._widget.lstAliases.repaint();
    }
}

