/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer;

import java.awt.Window;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogDelegate;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DockDelegate;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DockWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IDesktopContainer;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IDialogDelegate;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IDockDelegate;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ITabDelegate;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.InternalFrameDelegate;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ScrollableDesktopPane;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.TabDelegate;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.TabWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.DockTabDesktopPane;

public class DesktopContainerFactory {
    public static IDesktopContainer createDesktopContainer(IApplication app) {
        if (app.getDesktopStyle().isDockTabStyle()) {
            return new DockTabDesktopPane(app, true, null);
        }
        return new ScrollableDesktopPane(app);
    }

    public static IDialogDelegate createDialogDelegate(Window parent, String title, boolean resizeable, boolean closeable, boolean maximizeable, boolean iconifiable, DialogWidget dialogClient) {
        if (Main.getApplication().getDesktopStyle().isDockTabStyle()) {
            return new DialogDelegate(title, resizeable, closeable, maximizeable, iconifiable, dialogClient, parent);
        }
        return new InternalFrameDelegate(title, resizeable, closeable, maximizeable, iconifiable, dialogClient);
    }

    public static IDockDelegate createDockDelegate(IApplication app, String title, boolean resizeable, boolean closeable, boolean maximizeable, boolean iconifiable, DockWidget dockWidget) {
        if (app.getDesktopStyle().isDockTabStyle()) {
            return new DockDelegate(app, title, dockWidget);
        }
        return new InternalFrameDelegate(title, resizeable, closeable, maximizeable, iconifiable, dockWidget);
    }

    public static ITabDelegate createTabDelegate(IApplication app, String title, boolean resizeable, boolean closeable, boolean maximizeable, boolean iconifiable, TabWidget tabWidget) {
        if (app.getDesktopStyle().isDockTabStyle()) {
            return new TabDelegate(tabWidget, title);
        }
        return new InternalFrameDelegate(title, resizeable, closeable, maximizeable, iconifiable, tabWidget);
    }
}

