/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer;

import java.io.File;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ISessionWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.TabWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandler;
import net.sourceforge.squirrel_sql.client.gui.titlefilepath.TitleFilePathHandlerUtil;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.ModificationAwareSessionTitle;
import net.sourceforge.squirrel_sql.client.session.ModificationAwareSessionTitleChangeListener;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public abstract class SessionTabWidget
extends TabWidget
implements ISessionWidget {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SessionTabWidget.class);
    private final ModificationAwareSessionTitleChangeListener _titleChangeListener;
    private ISession _session;
    private ModificationAwareSessionTitle _titleWithoutFile;
    private TitleFilePathHandler _titleFileHandler;
    private String _titlePostFix = "";

    public SessionTabWidget(ModificationAwareSessionTitle title, boolean resizeable, boolean closeable, boolean maximizeable, boolean iconifiable, ISession session) {
        super(title.getTitle(), resizeable, closeable, maximizeable, iconifiable, session.getApplication());
        this._session = session;
        this._titleWithoutFile = title;
        this.setupSheet();
        this._titleChangeListener = (oldTitle, newTitle) -> this.setTitle(this._titleWithoutFile.getTitle());
        this._titleWithoutFile.addListener(this._titleChangeListener);
        this._titleFileHandler = new TitleFilePathHandler(() -> this.setTitle(this._titleWithoutFile.getTitle()));
    }

    @Override
    public ISession getSession() {
        return this._session;
    }

    @Override
    public void closeFrame(boolean withEvents) {
        if (!this._session.isfinishedLoading()) {
            return;
        }
        this._titleWithoutFile.removeListener(this._titleChangeListener);
        if (withEvents) {
            this.fireWidgetClosing();
        }
        this.dispose();
        if (withEvents) {
            this.fireWidgetClosed();
        }
    }

    private final void setupSheet() {
        this._session.getApplication().getWindowManager().registerSessionSheet(this);
        this.addWidgetListener(new SheetActivationListener());
    }

    @Override
    public void setTitle(String title) {
        this._titleWithoutFile.setTitle(title);
        this.updateTitle();
    }

    @Override
    public void setTitlePostFix(String titlePostFix) {
        this._titlePostFix = StringUtilities.isEmpty(titlePostFix, true) ? "" : titlePostFix;
        this.updateTitle();
    }

    private void updateTitle() {
        TitleFilePathHandlerUtil.setTitle(this._titleWithoutFile.getTitle() + this._titlePostFix, this._titleFileHandler, this, x$0 -> super.setTitle(x$0));
    }

    public void setMainSqlFile(File sqlFile) {
        this._titleFileHandler.setSqlFile(sqlFile);
    }

    public void displayUnsavedEditsInTabComponent(boolean unsavedEdits) {
        this._titleFileHandler.setUnsavedEdits(unsavedEdits);
    }

    protected TitleFilePathHandler getTitleFileHandler() {
        return this._titleFileHandler;
    }

    private class SheetActivationListener
    extends WidgetAdapter {
        private SheetActivationListener() {
        }

        @Override
        public void widgetActivated(WidgetEvent e) {
            SessionTabWidget.this._session.setActiveSessionWindow((ISessionWidget)e.getWidget());
            SessionTabWidget.this._session.getApplication().getSessionManager().setActiveSession(SessionTabWidget.this._session, false);
        }
    }
}

