/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class FontDesktopHints {
    private static final Map<RenderingHints.Key, Object> DEFAULT_HINTS = Collections.singletonMap(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    private static Map<String, Map<?, ?>> hintsCache = new HashMap();
    private static Set<String> cachedProperties = new HashSet<String>();
    private static PropertyChangeListener cacheInvalidator = evt -> hintsCache.clear();

    private FontDesktopHints() {
    }

    private static Map<RenderingHints.Key, Object> get(String deviceID) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Object fontHintsName = deviceID == null ? "awt.font.desktophints" : "awt.font.desktophints." + deviceID;
        if (cachedProperties.add((String)fontHintsName)) {
            toolkit.addPropertyChangeListener((String)fontHintsName, cacheInvalidator);
        }
        return (Map)toolkit.getDesktopProperty((String)fontHintsName);
    }

    public static void set(Graphics2D g) {
        String key = g.getDeviceConfiguration().getDevice().getIDstring();
        Map hints = hintsCache.computeIfAbsent(key, deviceID -> FontDesktopHints.onComputeHint(deviceID));
        g.addRenderingHints(hints);
    }

    private static Map<?, ?> onComputeHint(String deviceID) {
        Map textHints = Optional.ofNullable(FontDesktopHints.get(deviceID)).orElseGet(() -> FontDesktopHints.get(null));
        return Optional.ofNullable(textHints).orElse(DEFAULT_HINTS);
    }
}

