/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.Icon;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.FontDesktopHints;

class VerticalLabelIcon
implements Icon,
Serializable {
    private String caption;
    private Insets insets;
    private FontMetrics fm;
    private int iconWidth;
    private int iconHeight;

    public VerticalLabelIcon(String caption, Component c, Insets insets) {
        this.caption = caption;
        this.insets = (Insets)insets.clone();
        this.initMetrics(c);
    }

    private void initMetrics(Component c) {
        this.fm = c.getFontMetrics(c.getFont());
        this.iconWidth = this.fm.getHeight() + this.insets.top + this.insets.bottom;
        this.iconHeight = this.fm.stringWidth(this.caption) + this.insets.left + this.insets.right;
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        this.initMetrics(c);
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g.create(x, y, this.iconWidth, this.iconHeight);
            this.paintLabel(c, g2);
            g2.dispose();
        } else {
            BufferedImage image = new BufferedImage(this.iconWidth, this.iconHeight, 2);
            Graphics2D g2 = image.createGraphics();
            this.paintLabel(c, g2);
            g2.dispose();
            g.drawImage(image, x, y, null);
        }
    }

    private void paintLabel(Component c, Graphics2D g) {
        g.setColor(c.getForeground());
        g.setFont(this.fm.getFont());
        FontDesktopHints.set(g);
        g.rotate(-1.5707963267948966);
        g.translate(-this.iconHeight, this.iconWidth);
        g.drawString(this.caption, this.insets.left, -this.insets.bottom - this.fm.getDescent());
    }
}

