/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.jmeld;

import com.jidesoft.swing.JideTabbedPane;
import net.sourceforge.squirrel_sql.client.gui.jmeld.JMeldConfigPanel;
import net.sourceforge.squirrel_sql.client.gui.jmeld.JMeldCurveType;
import net.sourceforge.squirrel_sql.fw.props.Props;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.AbstractContentPanel;
import org.jmeld.ui.BufferDiffPanel;
import org.jmeld.ui.JMeldPanel;

public class JMeldConfigCtrl {
    public static final String PREF_IGNORE_WHITE_SPACES = "JMeldConfigCtrl.PREF_IGNORE_WHITE_SPACES";
    public static final String PREF_IGNORE_CASE = "JMeldConfigCtrl.PREF_IGNORE_CASE";
    public static final String PREF_DRAW_CURVES = "JMeldConfigCtrl.PREF_DRAW_CURVES";
    public static final String PREF_SELECTED_CURVE_TYPE = "JMeldConfigCtrl.PREF_SELECTED_CURVE_TYPE";
    private final JMeldPanel _meldPanel;
    private JMeldConfigPanel _jMeldConfigPanel;

    public JMeldConfigCtrl(JMeldPanel meldPanel) {
        this._meldPanel = meldPanel;
        this._jMeldConfigPanel = new JMeldConfigPanel();
        this._jMeldConfigPanel.chkIgnoreWhiteSpaces.setSelected(Props.getBoolean(PREF_IGNORE_WHITE_SPACES, false));
        this._jMeldConfigPanel.chkIgnoreCase.setSelected(Props.getBoolean(PREF_IGNORE_CASE, false));
        this._jMeldConfigPanel.chkDrawCurves.setSelected(Props.getBoolean(PREF_DRAW_CURVES, false));
        this._jMeldConfigPanel.cboCurveType.setSelectedItem((Object)JMeldConfigCtrl.getCurveTypeFromPrefs());
        this.onUpdateMeldPanel(this._meldPanel);
        this._jMeldConfigPanel.chkIgnoreWhiteSpaces.addActionListener(e -> this.onUpdateMeldPanel(this._meldPanel));
        this._jMeldConfigPanel.chkIgnoreCase.addActionListener(e -> this.onUpdateMeldPanel(this._meldPanel));
        this._jMeldConfigPanel.chkDrawCurves.addActionListener(e -> this.onUpdateMeldPanel(this._meldPanel));
        this._jMeldConfigPanel.cboCurveType.addActionListener(e -> this.onUpdateMeldPanel(this._meldPanel));
    }

    public JMeldConfigPanel getPanel() {
        return this._jMeldConfigPanel;
    }

    private static JMeldCurveType getCurveTypeFromPrefs() {
        String name = Props.getString(PREF_SELECTED_CURVE_TYPE, JMeldCurveType.TYPE_ZERO.name());
        try {
            return JMeldCurveType.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return JMeldCurveType.TYPE_ZERO;
        }
    }

    private void onUpdateMeldPanel(JMeldPanel meldPanel) {
        JMeldSettings.getInstance().getEditor().setIgnoreBlankLines(this._jMeldConfigPanel.chkIgnoreWhiteSpaces.isSelected());
        JMeldSettings.getInstance().getEditor().setIgnoreWhitespaceAtBegin(this._jMeldConfigPanel.chkIgnoreWhiteSpaces.isSelected());
        JMeldSettings.getInstance().getEditor().setIgnoreWhitespaceAtEnd(this._jMeldConfigPanel.chkIgnoreWhiteSpaces.isSelected());
        JMeldSettings.getInstance().getEditor().setIgnoreWhitespaceInBetween(this._jMeldConfigPanel.chkIgnoreWhiteSpaces.isSelected());
        JMeldSettings.getInstance().getEditor().setIgnoreCase(this._jMeldConfigPanel.chkIgnoreCase.isSelected());
        this._jMeldConfigPanel.cboCurveType.setEnabled(this._jMeldConfigPanel.chkDrawCurves.isSelected());
        JMeldSettings.getInstance().setDrawCurves(this._jMeldConfigPanel.chkDrawCurves.isSelected());
        if (this._jMeldConfigPanel.chkDrawCurves.isSelected()) {
            JMeldSettings.getInstance().setCurveType(this._jMeldConfigPanel.cboCurveType.getItemAt(this._jMeldConfigPanel.cboCurveType.getSelectedIndex()).getTypeId());
        }
        for (AbstractContentPanel abstractContentPanel : JMeldPanel.getContentPanelList((JideTabbedPane)meldPanel.getTabbedPane())) {
            if (!(abstractContentPanel instanceof BufferDiffPanel)) continue;
            ((BufferDiffPanel)abstractContentPanel).configurationChanged();
        }
        meldPanel.revalidate();
        Props.putBoolean(PREF_IGNORE_WHITE_SPACES, this._jMeldConfigPanel.chkIgnoreWhiteSpaces.isSelected());
        Props.putBoolean(PREF_IGNORE_CASE, this._jMeldConfigPanel.chkIgnoreCase.isSelected());
        Props.putBoolean(PREF_DRAW_CURVES, this._jMeldConfigPanel.chkDrawCurves.isSelected());
        Props.putString(PREF_SELECTED_CURVE_TYPE, ((JMeldCurveType)((Object)this._jMeldConfigPanel.cboCurveType.getSelectedItem())).name());
    }
}

